/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.search;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import info.textgrid.lab.core.model.util.StringToOM;
import info.textgrid.lab.search.AbstractRequest;
import info.textgrid.lab.search.ExtendedContentProposalAdapter;
import java.io.IOException;
import java.net.URLEncoder;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.statushandlers.StatusManager;

public abstract class AutocompletionClient
implements IContentProposalProvider {
    protected ExtendedContentProposalAdapter contentProposalAdapter;
    protected static final IContentProposal[] NONE = new IContentProposal[0];
    protected String whereToComplete = "type";
    protected AbstractRequest request;

    public ExtendedContentProposalAdapter getContentProposalAdapter() {
        return this.contentProposalAdapter;
    }

    public void setContentProposalAdapter(ExtendedContentProposalAdapter contentProposalAdapter) {
        this.contentProposalAdapter = contentProposalAdapter;
    }

    public void setWhereToComplete(String field) {
        this.whereToComplete = field;
    }

    public AutocompletionClient(String whichField) {
        this.setWhereToComplete(whichField);
    }

    protected abstract AbstractRequest createRequest(String var1, String var2);

    protected int getMinimalLength() {
        return 1;
    }

    public IContentProposal[] getProposals(String contents, int position) {
        if (contents.length() < this.getMinimalLength()) {
            return NONE;
        }
        String query = contents.substring(0, position);
        if ("".equals(query)) {
            return NONE;
        }
        if (this.request == null || !this.request.isApplicableFor(query)) {
            if (this.request != null) {
                this.request.cancel();
            }
            this.request = this.createRequest(this.whereToComplete, query);
            this.request.schedule();
        }
        Iterable<String> proposals = this.request.getResultsFor(query);
        return (IContentProposal[])Iterables.toArray((Iterable)Iterables.transform(proposals, (Function)this.getContentProposalConvertor()), IContentProposal.class);
    }

    protected ContentProposalConvertor getContentProposalConvertor() {
        return new ContentProposalConvertor();
    }

    protected OMElement getHttpResponse(String url, String query) throws HttpException, IOException, XMLStreamException, FactoryConfigurationError {
        HttpClient httpclient = new HttpClient();
        String completeUrl = String.valueOf(url) + URLEncoder.encode(query, "UTF-8");
        GetMethod method = new GetMethod(completeUrl);
        httpclient.executeMethod((HttpMethod)method);
        String result = new String(method.getResponseBody(), "UTF-8");
        method.releaseConnection();
        int statusCode = method.getStatusCode();
        if (statusCode != 200) {
            Status status = new Status(4, "info.textgrid.lab.search", "Error: Couldn't fetch results (Reason: " + method.getStatusLine() + ")" + "\nURL: " + completeUrl);
            StatusManager.getManager().handle((IStatus)status, 1);
            return null;
        }
        return StringToOM.getOMElement((String)result);
    }

    protected void forceOpenPopupIfClosed() {
        if (!this.contentProposalAdapter.isProposalPopupOpen()) {
            new UIJob(""){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    AutocompletionClient.this.contentProposalAdapter.openPopup();
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
    }

    private final class ContentProposalConvertor
    implements Function<String, IContentProposal> {
        private ContentProposalConvertor() {
        }

        public IContentProposal apply(final String result) {
            return new IContentProposal(){

                public String getLabel() {
                    return result;
                }

                public String getDescription() {
                    return null;
                }

                public int getCursorPosition() {
                    return result.length();
                }

                public String getContent() {
                    return result;
                }
            };
        }
    }
}

