/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.middleware.tgsearch.client;

import info.textgrid.middleware.tgsearch.api.Baseline;
import info.textgrid.middleware.tgsearch.api.Info;
import info.textgrid.middleware.tgsearch.api.Navigation;
import info.textgrid.middleware.tgsearch.api.Relation;
import info.textgrid.middleware.tgsearch.api.Search;
import info.textgrid.namespaces.middleware.tgsearch.PathResponse;
import info.textgrid.namespaces.middleware.tgsearch.Response;
import info.textgrid.namespaces.middleware.tgsearch.Revisions;
import info.textgrid.namespaces.middleware.tgsearch.TextgridUris;
import org.apache.cxf.jaxrs.client.ClientConfiguration;
import org.apache.cxf.jaxrs.client.JAXRSClientFactory;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.transport.common.gzip.GZIPInInterceptor;
import org.apache.cxf.transport.common.gzip.GZIPOutInterceptor;

public class SearchClient {
    private String sid = "";
    private String logstring = "";
    private int limit = 20;
    private String order = "asc:title";
    private String target = "both";
    private int kwicWidth = 40;
    private int wordDistance = -1;
    private boolean resolvePath = false;
    private Search search;
    private Navigation nav;
    private Info info;
    private Relation relation;
    private Baseline baseline;
    private static final String BOOLEAN_FALSE = "false";
    private static final String BOOLEAN_TRUE = "true";

    public SearchClient(String endpoint) {
        this.search = (Search)JAXRSClientFactory.create((String)(endpoint + "/search"), Search.class);
        this.nav = (Navigation)JAXRSClientFactory.create((String)(endpoint + "/navigation"), Navigation.class);
        this.info = (Info)JAXRSClientFactory.create((String)(endpoint + "/info"), Info.class);
        this.relation = (Relation)JAXRSClientFactory.create((String)(endpoint + "/relation"), Relation.class);
        this.baseline = (Baseline)JAXRSClientFactory.create((String)(endpoint + "/baseline"), Baseline.class);
    }

    public void enableGzipCompression() {
        ClientConfiguration sconfig = WebClient.getConfig((Object)this.search);
        sconfig.getInInterceptors().add(new GZIPInInterceptor());
        sconfig.getOutInterceptors().add(new GZIPOutInterceptor());
        ClientConfiguration nconfig = WebClient.getConfig((Object)this.nav);
        nconfig.getInInterceptors().add(new GZIPInInterceptor());
        nconfig.getOutInterceptors().add(new GZIPOutInterceptor());
        ClientConfiguration iconfig = WebClient.getConfig((Object)this.info);
        iconfig.getInInterceptors().add(new GZIPInInterceptor());
        iconfig.getOutInterceptors().add(new GZIPOutInterceptor());
        ClientConfiguration rconfig = WebClient.getConfig((Object)this.relation);
        rconfig.getInInterceptors().add(new GZIPInInterceptor());
        rconfig.getOutInterceptors().add(new GZIPOutInterceptor());
        ClientConfiguration bconfig = WebClient.getConfig((Object)this.baseline);
        bconfig.getInInterceptors().add(new GZIPInInterceptor());
        bconfig.getOutInterceptors().add(new GZIPOutInterceptor());
    }

    public Response query(String query) {
        int start = 0;
        String pstring = Boolean.valueOf(this.resolvePath).toString();
        return this.search.getQuery(query, this.target, this.sid, this.logstring, "", this.order, start, this.limit, this.kwicWidth, this.wordDistance, pstring, BOOLEAN_FALSE, BOOLEAN_FALSE);
    }

    public Response query(String query, String order, String sessionid, int start, int limit) {
        String pstring = Boolean.valueOf(this.resolvePath).toString();
        return this.search.getQuery(query, this.target, this.sid, this.logstring, sessionid, order, start, limit, this.kwicWidth, this.wordDistance, pstring, BOOLEAN_FALSE, BOOLEAN_FALSE);
    }

    public Response queryAllProjects(String query, String order, String sessionid, int start, int limit) {
        String pstring = Boolean.valueOf(this.resolvePath).toString();
        return this.search.getQuery(query, this.target, this.sid, this.logstring, sessionid, order, start, limit, this.kwicWidth, this.wordDistance, pstring, BOOLEAN_TRUE, BOOLEAN_FALSE);
    }

    public Response queryBaseline(String query, String order, String sessionid, int start, int limit) {
        return this.baseline.getQuery(query, this.sid, order, this.logstring, start, limit);
    }

    public Response queryBaseline(String query, int start) {
        return this.baseline.getQuery(query, this.sid, this.order, this.logstring, start, this.limit);
    }

    public Response listProject(String id) {
        return this.nav.listProject(id, this.sid, this.logstring);
    }

    public Response listAggregation(String id) {
        return this.nav.listAggregation(id, this.sid, this.logstring);
    }

    public Response listToplevelAggregations() {
        return this.nav.listToplevelAggregations();
    }

    public Revisions listRevisions(String uri) {
        return this.info.revisions(uri);
    }

    public Response listRevisionsAndMeta(String uri) {
        return this.info.revisionsAndMeta(uri, this.sid);
    }

    public Response getMetadata(String uri) {
        String pstring = Boolean.valueOf(this.resolvePath).toString();
        return this.info.metadata(uri, this.sid, pstring);
    }

    public Response getRelated(String relation, String uri) {
        return this.relation.getRelation(this.sid, this.logstring, relation, uri);
    }

    public Response getMeta4Relation(String relation, String uri) {
        String pstring = Boolean.valueOf(this.resolvePath).toString();
        return this.relation.getOnlyMetadata(this.sid, this.logstring, relation, uri, pstring);
    }

    public Response getRelatedAndMeta(String relation, String uri) {
        return this.relation.getCombined(this.sid, this.logstring, relation, uri);
    }

    public PathResponse getPath(String uri) {
        return this.info.getPath(uri);
    }

    public Response getEditionWorkMeta(String uri) {
        return this.info.getEditionWorkMeta(uri, this.sid);
    }

    public TextgridUris getParents(String uri) {
        return this.info.getParents(uri);
    }

    public TextgridUris getChildren(String uri) {
        return this.info.getChildren(uri);
    }

    public void setSid(String sid) {
        this.sid = sid;
    }

    public String getSid() {
        return this.sid;
    }

    public void setLogstring(String logstring) {
        this.logstring = logstring;
    }

    public String getLogstring() {
        return this.logstring;
    }

    public void setLIMIT(int limit) {
        this.limit = limit;
    }

    public void setORDER(String order) {
        this.order = order;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void setKwicWidth(int kwicWidth) {
        this.kwicWidth = kwicWidth;
    }

    public int getKwicWidth() {
        return this.kwicWidth;
    }

    public void setWordDistance(int wordDistance) {
        this.wordDistance = wordDistance;
    }

    public int getWordDistance() {
        return this.wordDistance;
    }

    public void setResolvePath(boolean getPath) {
        this.resolvePath = getPath;
    }

    public boolean isResolvePath() {
        return this.resolvePath;
    }
}

