/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.action;

import java.util.ArrayList;
import net.sf.vex.action.AbstractVexAction;
import net.sf.vex.action.ActionUtils;
import net.sf.vex.action.TableCellCallback;
import net.sf.vex.core.IntRange;
import net.sf.vex.widget.IVexWidget;

public class DeleteColumnAction
extends AbstractVexAction {
    @Override
    public void run(final IVexWidget vexWidget) {
        vexWidget.doWork(new Runnable(){

            @Override
            public void run() {
                final ActionUtils.RowColumnInfo rcInfo = ActionUtils.getRowColumnInfo(vexWidget);
                if (rcInfo == null) {
                    return;
                }
                final ArrayList cellsToDelete = new ArrayList();
                ActionUtils.iterateTableCells(vexWidget, new TableCellCallback(){

                    @Override
                    public void startRow(Object row, int rowIndex) {
                    }

                    @Override
                    public void onCell(Object row, Object cell, int rowIndex, int cellIndex) {
                        if (cellIndex == rcInfo.cellIndex) {
                            cellsToDelete.add(cell);
                        }
                    }

                    @Override
                    public void endRow(Object row, int rowIndex) {
                    }
                });
                int i = cellsToDelete.size() - 1;
                while (i >= 0) {
                    Object cell = cellsToDelete.get(i);
                    IntRange range = ActionUtils.getOuterRange(cell);
                    vexWidget.moveTo(range.getStart());
                    vexWidget.moveTo(range.getEnd(), true);
                    vexWidget.deleteSelection();
                    --i;
                }
            }
        });
    }

    @Override
    public boolean isEnabled(IVexWidget vexWidget) {
        return ActionUtils.getCurrentColumnIndex(vexWidget) != -1;
    }
}

