/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.action;

import net.sf.vex.action.AbstractVexAction;
import net.sf.vex.action.ActionUtils;
import net.sf.vex.layout.Box;
import net.sf.vex.layout.TableRowBox;
import net.sf.vex.widget.IBoxFilter;
import net.sf.vex.widget.IVexWidget;

public class NextTableCellAction
extends AbstractVexAction {
    @Override
    public void run(IVexWidget vexWidget) {
        TableRowBox tr = (TableRowBox)vexWidget.findInnermostBox(new IBoxFilter(){

            @Override
            public boolean matches(Box box) {
                return box instanceof TableRowBox;
            }
        });
        if (tr == null) {
            return;
        }
        int offset = vexWidget.getCaretOffset();
        Box[] cells = tr.getChildren();
        int i = 0;
        while (i < cells.length) {
            if (cells[i].getStartOffset() > offset) {
                vexWidget.moveTo(cells[i].getStartOffset());
                vexWidget.moveTo(cells[i].getEndOffset(), true);
                return;
            }
            ++i;
        }
        Box[] rows = tr.getParent().getChildren();
        int i2 = 0;
        while (i2 < rows.length) {
            if (rows[i2].getStartOffset() > offset) {
                cells = rows[i2].getChildren();
                if (cells.length > 0) {
                    Box cell = cells[0];
                    vexWidget.moveTo(cell.getStartOffset());
                    vexWidget.moveTo(cell.getEndOffset(), true);
                } else {
                    System.out.println("TODO - dup row into new empty row");
                }
                return;
            }
            ++i2;
        }
        ActionUtils.duplicateTableRow(vexWidget, tr);
    }
}

