/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.css;

import net.sf.vex.core.DisplayDevice;
import net.sf.vex.css.AbstractProperty;
import net.sf.vex.css.Styles;
import org.w3c.css.sac.LexicalUnit;

public class BorderWidthProperty
extends AbstractProperty {
    private String borderStyleName;
    private byte axis;
    private static final int BORDER_WIDTH_THIN = 1;
    private static final int BORDER_WIDTH_MEDIUM = 3;
    private static final int BORDER_WIDTH_THICK = 5;

    public BorderWidthProperty(String name, String borderStyleName, byte axis) {
        super(name);
        this.borderStyleName = borderStyleName;
        this.axis = axis;
    }

    public static boolean isBorderWidth(LexicalUnit lu) {
        if (lu == null) {
            return false;
        }
        if (BorderWidthProperty.isLength(lu)) {
            return true;
        }
        if (lu.getLexicalUnitType() == 35) {
            String s = lu.getStringValue();
            return s.equalsIgnoreCase("thin") || s.equalsIgnoreCase("medium") || s.equalsIgnoreCase("thick");
        }
        return false;
    }

    @Override
    public Object calculate(LexicalUnit lu, Styles parentStyles, Styles styles) {
        return new Integer(this.calculateInternal(lu, parentStyles, styles));
    }

    private int calculateInternal(LexicalUnit lu, Styles parentStyles, Styles styles) {
        DisplayDevice device = DisplayDevice.getCurrent();
        int ppi = this.axis == 0 ? device.getHorizontalPPI() : device.getVerticalPPI();
        String borderStyle = (String)styles.get(this.borderStyleName);
        if (borderStyle.equalsIgnoreCase("none") || borderStyle.equals("hidden")) {
            return 0;
        }
        if (BorderWidthProperty.isBorderWidth(lu)) {
            return BorderWidthProperty.getBorderWidth(lu, styles.getFontSize(), ppi);
        }
        if (BorderWidthProperty.isInherit(lu) && parentStyles != null) {
            return (Integer)parentStyles.get(this.getName());
        }
        return 3;
    }

    private static int getBorderWidth(LexicalUnit lu, float fontSize, int ppi) {
        if (BorderWidthProperty.isLength(lu)) {
            return BorderWidthProperty.getIntLength(lu, fontSize, ppi);
        }
        if (lu.getLexicalUnitType() == 35) {
            String s = lu.getStringValue();
            if (s.equalsIgnoreCase("thin")) {
                return 1;
            }
            if (s.equalsIgnoreCase("medium")) {
                return 3;
            }
            if (s.equalsIgnoreCase("thick")) {
                return 5;
            }
            return 0;
        }
        return 0;
    }
}

