/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.dom.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import net.sf.vex.dom.DocumentEvent;
import net.sf.vex.dom.DocumentValidationException;
import net.sf.vex.dom.IVexDocument;
import net.sf.vex.dom.IVexElement;
import net.sf.vex.dom.IVexNode;
import net.sf.vex.dom.IVexRootElement;
import net.sf.vex.dom.IWhitespacePolicy;
import net.sf.vex.dom.impl.Document;
import net.sf.vex.dom.impl.Node;
import net.sf.vex.dom.impl.WrongModelException;
import net.sf.vex.undo.IUndoableEdit;

public class Element
extends Node
implements Cloneable,
IVexElement {
    private String name;
    private IVexElement parent = null;
    private List children = new ArrayList();
    private Map attributes = new HashMap();

    public Element(String name) {
        this.name = name;
    }

    @Override
    public void addChild(IVexElement child) {
        WrongModelException.throwIfNeeded(child, Element.class);
        this.children.add(child);
        ((Element)child).parent = this;
    }

    @Override
    public String getAttribute(String name) {
        return (String)this.attributes.get(name);
    }

    @Override
    public String[] getAttributeNames() {
        Set names = this.attributes.keySet();
        return names.toArray(new String[names.size()]);
    }

    @Override
    public Iterator getChildIterator() {
        return this.children.iterator();
    }

    @Override
    public IVexElement[] getChildElements() {
        int size = this.children.size();
        return this.children.toArray(new IVexElement[size]);
    }

    @Override
    public IVexNode[] getChildNodes() {
        return Document.createNodeArray(this.getContent(), this.getStartOffset() + 1, this.getEndOffset(), this.getChildElements());
    }

    @Override
    public IVexDocument getDocument() {
        IVexElement root = this;
        while (root.getParent() != null) {
            root = root.getParent();
        }
        if (root instanceof IVexRootElement) {
            return ((IVexRootElement)root).getDocument();
        }
        return null;
    }

    @Override
    public IVexElement clone() {
        try {
            Element element = new Element(this.getName());
            for (String attrName : this.attributes.keySet()) {
                element.setAttribute(attrName, (String)this.attributes.get(attrName));
            }
            return element;
        }
        catch (DocumentValidationException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IVexElement getParent() {
        return this.parent;
    }

    @Override
    public String getText() {
        String s = super.getText();
        StringBuffer sb = new StringBuffer(s.length());
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c != '\u0000') {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    @Override
    public void internalInsertChild(int index, IVexElement child) {
        this.children.add(index, child);
        child.setParent(this);
    }

    @Override
    public boolean isEmpty() {
        return this.getStartOffset() + 1 == this.getEndOffset();
    }

    @Override
    public void removeAttribute(String name) throws DocumentValidationException {
        Document doc;
        String oldValue = this.getAttribute(name);
        String newValue = null;
        if (oldValue != null) {
            this.attributes.remove(name);
        }
        if ((doc = (Document)this.getDocument()) != null) {
            AttributeChangeEdit edit = doc.isUndoEnabled() ? new AttributeChangeEdit(name, oldValue, newValue) : null;
            doc.fireAttributeChanged(new DocumentEvent(doc, this, name, oldValue, newValue, edit));
        }
    }

    @Override
    public void setAttribute(String name, String value) throws DocumentValidationException {
        String oldValue = this.getAttribute(name);
        if (value == null && oldValue == null) {
            return;
        }
        if (value == null) {
            this.removeAttribute(name);
        } else {
            if (value.equals(oldValue)) {
                return;
            }
            this.attributes.put(name, value);
            Document doc = (Document)this.getDocument();
            if (doc != null) {
                AttributeChangeEdit edit = doc.isUndoEnabled() ? new AttributeChangeEdit(name, oldValue, value) : null;
                doc.fireAttributeChanged(new DocumentEvent(doc, this, name, oldValue, value, edit));
            }
        }
    }

    @Override
    public void setParent(IVexElement parent) {
        this.parent = parent;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<");
        sb.append(this.getName());
        String[] attrs = this.getAttributeNames();
        int i = 0;
        while (i < attrs.length) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(" ");
            sb.append(attrs[i]);
            sb.append("=\"");
            sb.append(this.getAttribute(attrs[i]));
            sb.append("\"");
            ++i;
        }
        sb.append("> (");
        sb.append(this.getStartPosition());
        sb.append(",");
        sb.append(this.getEndPosition());
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean isPre() {
        IWhitespacePolicy policy = this.getDocument().getWhitespacePolicy();
        if (policy != null) {
            return policy.isPre(this);
        }
        return false;
    }

    private class AttributeChangeEdit
    implements IUndoableEdit {
        private String name;
        private String oldValue;
        private String newValue;

        public AttributeChangeEdit(String name, String oldValue, String newValue) {
            this.name = name;
            this.oldValue = oldValue;
            this.newValue = newValue;
        }

        @Override
        public boolean combine(IUndoableEdit edit) {
            return false;
        }

        @Override
        public void undo() throws CannotUndoException {
            IVexDocument doc = Element.this.getDocument();
            try {
                try {
                    doc.setUndoEnabled(false);
                    Element.this.setAttribute(this.name, this.oldValue);
                }
                catch (DocumentValidationException documentValidationException) {
                    throw new CannotUndoException();
                }
            }
            finally {
                doc.setUndoEnabled(true);
            }
        }

        @Override
        public void redo() throws CannotRedoException {
            IVexDocument doc = Element.this.getDocument();
            try {
                try {
                    doc.setUndoEnabled(false);
                    Element.this.setAttribute(this.name, this.newValue);
                }
                catch (DocumentValidationException documentValidationException) {
                    throw new CannotUndoException();
                }
            }
            finally {
                doc.setUndoEnabled(true);
            }
        }
    }
}

