/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.layout;

import java.util.ArrayList;
import net.sf.vex.core.FontMetrics;
import net.sf.vex.core.FontResource;
import net.sf.vex.core.Graphics;
import net.sf.vex.core.Insets;
import net.sf.vex.core.Rectangle;
import net.sf.vex.css.Styles;
import net.sf.vex.dom.IVexCDATASection;
import net.sf.vex.dom.IVexComment;
import net.sf.vex.dom.IVexNonElement;
import net.sf.vex.layout.Box;
import net.sf.vex.layout.CDATASectionBox;
import net.sf.vex.layout.CommentBox;
import net.sf.vex.layout.CompositeInlineBox;
import net.sf.vex.layout.DocumentTextBox;
import net.sf.vex.layout.InlineBox;
import net.sf.vex.layout.InlineElementBox;
import net.sf.vex.layout.LayoutContext;

public abstract class NonElementBox
extends CompositeInlineBox {
    protected IVexNonElement element;
    protected InlineBox[] children;
    protected InlineBox firstContentChild = null;
    protected InlineBox lastContentChild = null;

    public NonElementBox(LayoutContext context, IVexNonElement element, int startOffset, int endOffset) {
        this.element = element;
        ArrayList<InlineBox> childList = new ArrayList<InlineBox>();
        childList.add(this.getStartMarker(context));
        DocumentTextBox text = new DocumentTextBox(context, element, this.getStyles(), startOffset + 1, endOffset + 1);
        childList.add(text);
        this.firstContentChild = text;
        this.lastContentChild = text;
        childList.add(this.getEndMarker(context));
        this.children = childList.toArray(new InlineBox[childList.size()]);
        this.layout(context);
    }

    @Override
    public int getBaseline() {
        return 0;
    }

    public static NonElementBox createNonElementBox(LayoutContext context, IVexNonElement element, int startOffset, int endOffset) {
        if (element instanceof IVexComment) {
            return new CommentBox(context, (IVexComment)element, startOffset, endOffset);
        }
        if (element instanceof IVexCDATASection) {
            return new CDATASectionBox(context, (IVexCDATASection)element, startOffset, endOffset);
        }
        throw new IllegalArgumentException("Must be of type IVexComment or IVexCDATASection");
    }

    protected static NonElementBox createNonElementBox(LayoutContext context, IVexNonElement element, InlineBox[] children) {
        if (element instanceof IVexComment) {
            return new CommentBox(context, (IVexComment)element, children);
        }
        if (element instanceof IVexCDATASection) {
            return new CDATASectionBox(context, (IVexCDATASection)element, children);
        }
        throw new IllegalArgumentException("Must be of type IVexComment or IVexCDATASection");
    }

    protected NonElementBox(LayoutContext context, IVexNonElement element, InlineBox[] children) {
        this.element = element;
        this.children = children;
        InlineBox[] inlineBoxArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            InlineBox c = inlineBoxArray[n2];
            if (this.firstContentChild == null && c.hasContent()) {
                this.firstContentChild = c;
            }
            if (c.hasContent()) {
                this.lastContentChild = c;
            }
            ++n2;
        }
        this.layout(context);
    }

    @Override
    public InlineBox.Pair split(LayoutContext context, InlineBox[] lefts, InlineBox[] rights) {
        NonElementBox left = null;
        NonElementBox right = null;
        if (lefts.length > 0 || rights.length == 0) {
            left = NonElementBox.createNonElementBox(context, this.element, lefts);
        }
        if (rights.length > 0) {
            right = NonElementBox.createNonElementBox(context, this.element, rights);
        }
        return new InlineBox.Pair(left, right);
    }

    @Override
    public Box[] getChildren() {
        return this.children;
    }

    @Override
    public int getEndOffset() {
        if (this.lastContentChild == null) {
            return this.getElement().getEndOffset();
        }
        return this.lastContentChild.getEndOffset();
    }

    @Override
    public int getStartOffset() {
        if (this.firstContentChild == null) {
            return this.getElement().getStartOffset();
        }
        return this.firstContentChild.getStartOffset();
    }

    protected void layout(LayoutContext context) {
        Graphics g = context.getGraphics();
        FontResource font = g.createFont(this.getStyles().getFont());
        FontResource oldFont = g.setFont(font);
        FontMetrics fm = g.getFontMetrics();
        this.setHeight(this.getStyles().getLineHeight());
        int cfr_ignored_0 = (this.getStyles().getLineHeight() - fm.getAscent() - fm.getDescent()) / 2;
        Insets ins = this.getInsets(context, this.getWidth());
        int x = 0;
        int i = 0;
        while (i < this.children.length) {
            InlineBox child = this.children[i];
            Insets childIns = child.getInsets(context, this.getWidth());
            child.setX(x + ins.getLeft());
            x += child.getWidth() + childIns.getLeft() + childIns.getRight();
            this.setHeight(Math.max(this.getHeight(), child.getHeight() + childIns.getTop() + childIns.getBottom()));
            ++i;
        }
        this.setWidth(x);
        InlineBox[] inlineBoxArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            InlineBox b = inlineBoxArray[n2];
            Insets childIns = Insets.ZERO_INSETS;
            if (b instanceof InlineElementBox) {
                childIns = b.getInsets(context, this.getWidth());
            }
            b.setY(ins.getTop() + (this.getHeight() - b.getHeight() - childIns.getTop() - childIns.getBottom()) / 2);
            ++n2;
        }
        g.setFont(oldFont);
        font.dispose();
    }

    @Override
    public void paint(LayoutContext context, int x, int y, Rectangle area) {
        Insets ins = this.getInsets(context, this.getWidth());
        boolean drawSelected = context.isElementSelected(this.getElement());
        this.drawBox(context, x + ins.getLeft(), y + ins.getTop(), 0, drawSelected);
        super.paint(context, x, y, area);
    }

    protected abstract Styles getStyles();

    protected abstract InlineBox getStartMarker(LayoutContext var1);

    protected abstract InlineBox getEndMarker(LayoutContext var1);
}

