/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.layout;

import net.sf.vex.core.Caret;
import net.sf.vex.core.FontMetrics;
import net.sf.vex.core.FontResource;
import net.sf.vex.core.Graphics;
import net.sf.vex.css.Styles;
import net.sf.vex.dom.IVexElement;
import net.sf.vex.layout.AbstractBox;
import net.sf.vex.layout.InlineBox;
import net.sf.vex.layout.LayoutContext;
import net.sf.vex.layout.TextCaret;

public class PlaceholderBox
extends AbstractBox
implements InlineBox {
    private IVexElement element;
    private int relOffset;
    private int textTop;
    private int baseline;

    public PlaceholderBox(LayoutContext context, IVexElement element, int relOffset) {
        this.element = element;
        this.relOffset = relOffset;
        this.setWidth(0);
        Graphics g = context.getGraphics();
        Styles styles = context.getStyleSheet().getStyles(element);
        FontResource font = g.createFont(styles.getFont());
        FontResource oldFont = g.setFont(font);
        FontMetrics fm = g.getFontMetrics();
        int height = fm.getAscent() + fm.getDescent();
        int lineHeight = styles.getLineHeight();
        this.textTop = (lineHeight - height) / 2;
        this.baseline = this.textTop + fm.getAscent();
        this.setHeight(lineHeight);
        g.setFont(oldFont);
        font.dispose();
    }

    @Override
    public int getBaseline() {
        return this.baseline;
    }

    @Override
    public InlineBox.Pair split(LayoutContext context, int maxWidth, boolean force) {
        return new InlineBox.Pair(null, this);
    }

    @Override
    public Caret getCaret(LayoutContext context, int offset) {
        return new TextCaret(0, this.textTop, this.baseline - this.textTop);
    }

    @Override
    public IVexElement getElement() {
        return this.element;
    }

    @Override
    public int getEndOffset() {
        return this.element.getStartOffset() + this.relOffset;
    }

    @Override
    public int getStartOffset() {
        return this.element.getStartOffset() + this.relOffset;
    }

    @Override
    public boolean hasContent() {
        return true;
    }

    @Override
    public boolean isEOL() {
        return false;
    }

    public String toString() {
        return "[placeholder(" + this.getStartOffset() + ")]";
    }

    @Override
    public int viewToModel(LayoutContext context, int x, int y) {
        return this.getStartOffset();
    }
}

