/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.editor.config;

import java.util.ArrayList;
import net.sf.vex.editor.config.IConfigElement;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class DomConfigurationElement
implements IConfigElement {
    private Element element;

    public DomConfigurationElement(Element element) {
        this.element = element;
    }

    @Override
    public String getAttribute(String name) {
        return this.element.getAttribute(name);
    }

    @Override
    public String[] getAttributeNames() {
        int n = this.element.getAttributes().getLength();
        String[] names = new String[n];
        int i = 0;
        while (i < n) {
            Node node = this.element.getAttributes().item(i);
            names[i] = node.getLocalName();
            ++i;
        }
        return names;
    }

    @Override
    public IConfigElement[] getChildren() {
        return this.getChildren(null);
    }

    @Override
    public IConfigElement[] getChildren(String name) {
        ArrayList<Node> children = new ArrayList<Node>();
        NodeList list = this.element.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Node node = list.item(i);
            if (node instanceof Element && (name == null || name.equals(node.getNodeName()))) {
                children.add(node);
            }
            ++i;
        }
        int n = children.size();
        IConfigElement[] childArray = new IConfigElement[n];
        int i2 = 0;
        while (i2 < n) {
            childArray[i2] = new DomConfigurationElement((Element)children.get(i2));
            ++i2;
        }
        return childArray;
    }

    @Override
    public String getName() {
        return this.element.getLocalName();
    }

    @Override
    public String getValue() {
        StringBuffer sb = new StringBuffer();
        NodeList list = this.element.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Node node = list.item(i);
            if (node instanceof Text) {
                sb.append(node.getNodeValue());
            }
            ++i;
        }
        return sb.toString();
    }
}

