/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.editor;

import java.lang.reflect.Field;
import net.sf.vex.dom.IVexElement;
import net.sf.vex.editor.VexEditor;
import net.sf.vex.swt.VexWidget;
import net.sf.vex.widget.VexWidgetImpl;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.IPageSite;

class InsertViewPage
implements IPageBookViewPage {
    private static Field implField;
    private static Field rootBoxField;
    private static Field caretField;
    private static Field hostComponentField;
    private IPageSite site;
    private VexEditor vexEditor;
    private VexWidget vexWidget;
    private VexWidgetImpl impl;
    private ScrolledComposite composite;
    private Composite elementList;
    private Label loadingLabel;
    private IVexElement currentElement;
    private ISelectionChangedListener selectionListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            InsertViewPage.this.createInsertPanel();
        }
    };

    static {
        try {
            implField = VexWidget.class.getDeclaredField("impl");
            implField.setAccessible(true);
            rootBoxField = VexWidgetImpl.class.getDeclaredField("rootBox");
            rootBoxField.setAccessible(true);
            caretField = VexWidgetImpl.class.getDeclaredField("caret");
            caretField.setAccessible(true);
            hostComponentField = VexWidgetImpl.class.getDeclaredField("hostComponent");
            hostComponentField.setAccessible(true);
        }
        catch (Exception exception) {}
    }

    public InsertViewPage(VexEditor vexEditor) {
        this.vexEditor = vexEditor;
    }

    public void createControl(Composite parent) {
        this.composite = new ScrolledComposite(parent, 2560);
        this.composite.setLayout((Layout)new FillLayout());
        this.composite.setExpandHorizontal(true);
        this.composite.setExpandVertical(true);
        if (this.vexEditor.isLoaded()) {
            this.createInsertPanel();
        } else {
            this.loadingLabel = new Label((Composite)this.composite, 0);
            this.loadingLabel.setText("Loading...");
        }
        this.vexEditor.getEditorSite().getSelectionProvider().addSelectionChangedListener(this.selectionListener);
    }

    public void dispose() {
        this.vexEditor.getEditorSite().getSelectionProvider().removeSelectionChangedListener(this.selectionListener);
    }

    public Control getControl() {
        return this.composite;
    }

    public IPageSite getSite() {
        return this.site;
    }

    public void init(IPageSite site) throws PartInitException {
        this.site = site;
    }

    public void setActionBars(IActionBars actionBars) {
    }

    public void setFocus() {
    }

    private void createInsertPanel() {
        if (this.loadingLabel != null) {
            this.loadingLabel.dispose();
            this.loadingLabel = null;
        }
        this.vexWidget = this.vexEditor.getVexWidget();
        try {
            this.impl = (VexWidgetImpl)implField.get(this.vexWidget);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        if (this.currentElement == null || this.vexWidget.getCurrentElement() != this.currentElement) {
            IAction[] validActions;
            this.currentElement = this.vexWidget.getCurrentElement();
            if (this.elementList != null) {
                this.elementList.dispose();
            }
            this.elementList = new Composite((Composite)this.composite, 0);
            RowLayout rl = new RowLayout(256);
            rl.wrap = true;
            this.elementList.setLayout((Layout)rl);
            IAction[] iActionArray = validActions = this.vexWidget.getValidInsertActions();
            int n = validActions.length;
            int n2 = 0;
            while (n2 < n) {
                IAction a = iActionArray[n2];
                Button elementButton = new Button(this.elementList, 8);
                elementButton.setText(a.getText());
                elementButton.addSelectionListener((SelectionListener)new InsertSelectionListener(a));
                ++n2;
            }
            this.composite.setContent((Control)this.elementList);
            this.composite.addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent e) {
                    Rectangle r = InsertViewPage.this.composite.getClientArea();
                    InsertViewPage.this.composite.setMinSize(InsertViewPage.this.elementList.computeSize(r.width, -1));
                    InsertViewPage.this.elementList.layout();
                }
            });
        }
    }

    private class InsertSelectionListener
    implements SelectionListener {
        protected IAction action;

        public InsertSelectionListener(IAction a) {
            this.action = a;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            this.action.run();
            Workbench.getInstance().getActiveWorkbenchWindow().getActivePage().getActiveEditor().setFocus();
        }
    }
}

