/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.css;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import net.sf.vex.core.Log;
import net.sf.vex.css.PropertyDecl;
import net.sf.vex.css.PseudoElement;
import net.sf.vex.dom.IVexElement;
import org.w3c.css.sac.AttributeCondition;
import org.w3c.css.sac.CombinatorCondition;
import org.w3c.css.sac.Condition;
import org.w3c.css.sac.ConditionalSelector;
import org.w3c.css.sac.DescendantSelector;
import org.w3c.css.sac.ElementSelector;
import org.w3c.css.sac.NegativeSelector;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SiblingSelector;

public class Rule
implements Serializable {
    private static final long serialVersionUID = 1L;
    private byte source;
    private Selector selector;
    private List propertyDecls = new ArrayList();

    public Rule(byte source, Selector selector) {
        this.source = source;
        this.selector = selector;
    }

    public void add(PropertyDecl decl) {
        this.propertyDecls.add(decl);
    }

    public Selector getSelector() {
        return this.selector;
    }

    public byte getSource() {
        return this.source;
    }

    public PropertyDecl[] getPropertyDecls() {
        return this.propertyDecls.toArray(new PropertyDecl[this.propertyDecls.size()]);
    }

    public int getSpecificity() {
        return Rule.specificity(this.getSelector());
    }

    public boolean matches(IVexElement element) {
        return Rule.matches(this.selector, element);
    }

    private static boolean matches(Selector selector, IVexElement element) {
        if (element == null) {
            return false;
        }
        String elementName = element.getName();
        short selectorType = selector.getSelectorType();
        switch (selectorType) {
            case 1: {
                return true;
            }
            case 0: {
                ConditionalSelector cs = (ConditionalSelector)selector;
                if (cs.getCondition().getConditionType() == 10) {
                    if (element instanceof PseudoElement) {
                        AttributeCondition ac = (AttributeCondition)cs.getCondition();
                        if (element.getName().equals("first-letter") || element.getName().equals("first-line")) {
                            return ac.getValue().equals(element.getName());
                        }
                        return ac.getValue().equals(element.getName()) && Rule.matches((Selector)cs.getSimpleSelector(), element.getParent());
                    }
                    return false;
                }
                return Rule.matches((Selector)cs.getSimpleSelector(), element) && Rule.matchesCondition(cs.getCondition(), element);
            }
            case 4: {
                String selectorName = ((ElementSelector)selector).getLocalName();
                if (selectorName == null) {
                    return true;
                }
                if (!selectorName.equals(elementName)) break;
                return true;
            }
            case 10: {
                DescendantSelector ds = (DescendantSelector)selector;
                return Rule.matches((Selector)ds.getSimpleSelector(), element) && Rule.matchesAncestor(ds.getAncestorSelector(), element.getParent());
            }
            case 11: {
                DescendantSelector ds2 = (DescendantSelector)selector;
                IVexElement parent = element.getParent();
                if (element instanceof PseudoElement) {
                    parent = parent.getParent();
                }
                return Rule.matches((Selector)ds2.getSimpleSelector(), element) && Rule.matches(ds2.getAncestorSelector(), parent);
            }
            case 12: {
                SiblingSelector ss = (SiblingSelector)selector;
                if (element != null && element.getParent() != null && Rule.matches((Selector)ss.getSiblingSelector(), element)) {
                    Iterator i = element.getParent().getChildIterator();
                    IVexElement e = null;
                    IVexElement f = null;
                    while (i.hasNext() && e != element) {
                        f = e;
                        e = (IVexElement)i.next();
                    }
                    if (e == element) {
                        return Rule.matches(ss.getSelector(), f);
                    }
                }
                return false;
            }
            default: {
                Exception ex = new Exception("I have a stack trace");
                Log.logWarning("CSS: Unsupported condition type " + selectorType, ex);
            }
        }
        return false;
    }

    private static boolean matchesAncestor(Selector selector, IVexElement element) {
        IVexElement e = element;
        while (e != null) {
            if (Rule.matches(selector, e)) {
                return true;
            }
            e = e.getParent();
        }
        return false;
    }

    private static boolean matchesCondition(Condition condition, IVexElement element) {
        switch (condition.getConditionType()) {
            case 10: {
                return false;
            }
            case 4: {
                AttributeCondition acon = (AttributeCondition)condition;
                String value = element.getAttribute(acon.getLocalName());
                if (acon.getValue() != null) {
                    return acon.getValue().equals(value);
                }
                return value != null;
            }
            case 7: 
            case 9: {
                AttributeCondition acon = (AttributeCondition)condition;
                String attributeName = condition.getConditionType() == 9 ? "class" : acon.getLocalName();
                String value = element.getAttribute(attributeName);
                if (value == null) {
                    return false;
                }
                StringTokenizer st = new StringTokenizer(value);
                while (st.hasMoreTokens()) {
                    if (!st.nextToken().equals(acon.getValue())) continue;
                    return true;
                }
                return false;
            }
            case 0: {
                CombinatorCondition ccon = (CombinatorCondition)condition;
                return Rule.matchesCondition(ccon.getFirstCondition(), element) && Rule.matchesCondition(ccon.getSecondCondition(), element);
            }
        }
        Exception ex = new Exception("I have a stack trace");
        Log.logWarning("CSS: Unsupported condition type " + condition.getConditionType(), ex);
        return false;
    }

    private static int specificity(Selector sel) {
        if (sel instanceof ElementSelector) {
            if (((ElementSelector)sel).getLocalName() == null) {
                return 0;
            }
            return 1;
        }
        if (sel instanceof DescendantSelector) {
            DescendantSelector ds = (DescendantSelector)sel;
            return Rule.specificity(ds.getAncestorSelector()) + Rule.specificity((Selector)ds.getSimpleSelector());
        }
        if (sel instanceof SiblingSelector) {
            SiblingSelector ss = (SiblingSelector)sel;
            return Rule.specificity(ss.getSelector()) + Rule.specificity((Selector)ss.getSiblingSelector());
        }
        if (sel instanceof NegativeSelector) {
            NegativeSelector ns = (NegativeSelector)sel;
            return Rule.specificity((Selector)ns.getSimpleSelector());
        }
        if (sel instanceof ConditionalSelector) {
            ConditionalSelector cs = (ConditionalSelector)sel;
            return Rule.specificity(cs.getCondition()) + Rule.specificity((Selector)cs.getSimpleSelector());
        }
        return 0;
    }

    private static int specificity(Condition cond) {
        if (cond instanceof CombinatorCondition) {
            CombinatorCondition cc = (CombinatorCondition)cond;
            return Rule.specificity(cc.getFirstCondition()) + Rule.specificity(cc.getSecondCondition());
        }
        if (cond instanceof AttributeCondition) {
            if (cond.getConditionType() == 5) {
                return 1000000;
            }
            return 1000;
        }
        return 0;
    }
}

