/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.layout;

import net.sf.vex.core.ColorResource;
import net.sf.vex.core.FontResource;
import net.sf.vex.core.Graphics;
import net.sf.vex.core.Rectangle;
import net.sf.vex.css.Styles;
import net.sf.vex.dom.IVexElement;
import net.sf.vex.dom.IVexNode;
import net.sf.vex.layout.InlineBox;
import net.sf.vex.layout.LayoutContext;
import net.sf.vex.layout.TextBox;

public class StaticTextBox
extends TextBox {
    public static final byte NO_MARKER = 0;
    public static final byte START_MARKER = 1;
    public static final byte END_MARKER = 2;
    private String text;
    private byte marker;

    public StaticTextBox(LayoutContext context, IVexElement pseudoElement, String text) {
        this(context, pseudoElement, text, 0);
        if (text.length() == 0) {
            throw new IllegalArgumentException("StaticTextBox cannot have an empty text string.");
        }
    }

    public StaticTextBox(LayoutContext context, IVexElement pseudoElement, String text, byte marker) {
        super(pseudoElement);
        this.text = text;
        this.marker = marker;
        this.calculateSize(context);
    }

    public StaticTextBox(LayoutContext context, IVexNode node, Styles styles, String text, byte marker) {
        super(styles, node);
        this.text = text;
        this.marker = marker;
        this.calculateSize(context);
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public boolean hasContent() {
        return false;
    }

    @Override
    public void paint(LayoutContext context, int x, int y, Rectangle area) {
        Styles styles = this.getStyles(context);
        Graphics g = context.getGraphics();
        boolean drawSelected = false;
        if (this.marker == 1) {
            drawSelected = this.getNode().getStartOffset() >= context.getSelectionStart() && this.getNode().getStartOffset() + 1 <= context.getSelectionEnd();
        } else if (this.marker == 2) {
            drawSelected = this.getNode().getEndOffset() >= context.getSelectionStart() && this.getNode().getEndOffset() + 1 <= context.getSelectionEnd();
        }
        FontResource font = g.createFont(styles.getFont());
        ColorResource color = g.createColor(styles.getColor());
        FontResource oldFont = g.setFont(font);
        ColorResource oldColor = g.setColor(color);
        String textToPaint = this.getText();
        if (textToPaint.length() > 0 && StaticTextBox.isNewline(textToPaint.charAt(textToPaint.length() - 1))) {
            textToPaint = textToPaint.substring(0, textToPaint.length() - 1);
        }
        if (drawSelected) {
            this.paintSelectedText(context, textToPaint, x, y);
        } else {
            g.drawString(textToPaint, x, y);
        }
        this.paintTextDecoration(context, styles, textToPaint, -1, -1, x, y);
        g.setFont(oldFont);
        g.setColor(oldColor);
        font.dispose();
        color.dispose();
    }

    @Override
    public InlineBox.Pair splitAt(LayoutContext context, int offset) {
        StaticTextBox left = offset == 0 ? null : new StaticTextBox(context, this.getNode(), this.getStyles(context), this.getText().substring(0, offset), this.marker);
        StaticTextBox right = offset == this.getText().length() ? null : new StaticTextBox(context, this.getNode(), this.getStyles(context), this.getText().substring(offset), this.marker);
        return new InlineBox.Pair(left, right);
    }
}

