/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.xmleditor.mpeditor.links;

import com.google.common.collect.Lists;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FragmentXPointer {
    private static final String ATTRIBUTE_LOCALNAME_ID = "id";
    private Node node;

    protected FragmentXPointer(Node node) {
        this.node = node;
    }

    public static FragmentXPointer of(Node node) {
        return new FragmentXPointer(node);
    }

    public Node getNode() {
        return this.node;
    }

    public String toString() {
        List<Node> pathFromId = this.getPathFromID();
        if (pathFromId.size() == 1) {
            return "#" + FragmentXPointer.getID(this.node);
        }
        StringBuilder result = new StringBuilder("#xpointer(");
        if (FragmentXPointer.getID(pathFromId.get(0)) != null) {
            result.append("id('").append(FragmentXPointer.getID(pathFromId.get(0))).append("')");
        }
        for (Node pathElement : pathFromId.subList(1, pathFromId.size())) {
            result.append('/');
            result.append(pathElement.getNodeName());
            result.append('[').append(FragmentXPointer.getNamedPosition(pathElement)).append(']');
        }
        result.append(")");
        return result.toString();
    }

    private List<Node> getPathFromID() {
        Node currentNode = this.node;
        LinkedList pathToId = Lists.newLinkedList();
        while (FragmentXPointer.getID(currentNode) == null && currentNode.getParentNode() != null) {
            pathToId.add(currentNode);
            currentNode = currentNode.getParentNode();
        }
        pathToId.add(currentNode);
        LinkedList pathFromId = Lists.newLinkedList((Iterable)pathToId);
        Collections.reverse(pathFromId);
        return pathFromId;
    }

    public static int getNamedPosition(Node pathElement) {
        assert (pathElement.getParentNode() != null);
        int pos = 0;
        NodeList childNodes = pathElement.getParentNode().getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            if (childNodes.item(i).getNodeName().equals(pathElement.getNodeName())) {
                ++pos;
                if (childNodes.item(i) == pathElement) {
                    return pos;
                }
            }
            ++i;
        }
        throw new IllegalStateException(MessageFormat.format("The element {0} wasn't found in the list of its parent node's ({1}) children", pathElement, pathElement.getParentNode()));
    }

    private static String getID(Node node) {
        NamedNodeMap attributes;
        if (node instanceof Attr) {
            node = ((Attr)node).getOwnerElement();
        }
        if ((attributes = node.getAttributes()) != null) {
            Attr idAttribute = (Attr)attributes.getNamedItemNS("http://www.w3.org/XML/1998/namespace", ATTRIBUTE_LOCALNAME_ID);
            if (idAttribute == null) {
                idAttribute = (Attr)attributes.getNamedItem(ATTRIBUTE_LOCALNAME_ID);
            }
            if (idAttribute == null) {
                idAttribute = (Attr)attributes.getNamedItem("xml:id");
            }
            if (idAttribute != null) {
                return idAttribute.getValue();
            }
        }
        return null;
    }
}

