/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.debug.decoraters;

import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.regex.Pattern;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.handlers.HandlerUtil;

public class ListIconsHandler
extends AbstractHandler
implements IHandler {
    private PrintStream out;
    private static Pattern ICON = Pattern.compile(".*(icon|image)$");

    public Object execute(ExecutionEvent event) throws ExecutionException {
        FileDialog dialog = new FileDialog(HandlerUtil.getActiveShell((ExecutionEvent)event), 1);
        dialog.setFileName("icons.tsv");
        dialog.setFilterExtensions(new String[]{"tsv"});
        dialog.setFilterIndex(0);
        dialog.setFilterPath(System.getProperty("user.home", "/"));
        dialog.setText("Generate icon list");
        String filename = dialog.open();
        if (filename != null) {
            try {
                this.out = new PrintStream(filename);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.out = System.out;
            }
        } else {
            this.out = System.out;
        }
        try {
            this.out.println("Contributor\tExtension Point\tElement\tAttribute\tFile");
            IExtensionRegistry registry = RegistryFactory.getRegistry();
            String[] stringArray = registry.getNamespaces();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String namespace = stringArray[n2];
                IExtension[] iExtensionArray = registry.getExtensions(namespace);
                int n3 = iExtensionArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IExtension extension = iExtensionArray[n4];
                    IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                    int n5 = iConfigurationElementArray.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        IConfigurationElement config = iConfigurationElementArray[n6];
                        this.handleConfigurationElement("", config);
                        ++n6;
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        finally {
            if (this.out != System.out) {
                this.out.close();
            }
        }
        return null;
    }

    private void handleConfigurationElement(String path, IConfigurationElement config) {
        if (ICON.matcher(config.getName()).matches() && config.getValue() != null && !config.getValue().isEmpty()) {
            this.handleMatch(path, config, "", config.getValue());
        }
        String[] stringArray = config.getAttributeNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String attr = stringArray[n2];
            String value = config.getAttribute(attr);
            if (ICON.matcher(attr).matches() && value != null && !value.isEmpty() || value != null && (value.endsWith(".png") || value.endsWith(".gif"))) {
                this.handleMatch(path, config, attr, value);
            }
            ++n2;
        }
        stringArray = config.getChildren();
        n = stringArray.length;
        n2 = 0;
        while (n2 < n) {
            String child = stringArray[n2];
            this.handleConfigurationElement(String.valueOf(path) + "/" + config.getName(), (IConfigurationElement)child);
            ++n2;
        }
    }

    private void handleMatch(String path, IConfigurationElement config, String attr, String value) {
        this.out.println(MessageFormat.format("{0}\t{1}\t{2}/{3}\t{4}\t{5}", config.getContributor().getName(), config.getDeclaringExtension().getExtensionPointUniqueIdentifier(), path, config.getName(), attr, value));
    }
}

