/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.search.ui;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.core.swtutils.AdapterUtils;
import info.textgrid.lab.search.KWICEntry;
import info.textgrid.lab.search.ui.Messages;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedList;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.statushandlers.StatusManager;

public class CopyKWICURI
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection currentSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (currentSelection instanceof IStructuredSelection) {
            KWICEntry[] kwicEntries = (KWICEntry[])AdapterUtils.getAdapters((Object[])((IStructuredSelection)currentSelection).toArray(), KWICEntry.class, (boolean)false);
            try {
                LinkedList uris = Lists.newLinkedList();
                KWICEntry[] kWICEntryArray = kwicEntries;
                int n = kwicEntries.length;
                int n2 = 0;
                while (n2 < n) {
                    KWICEntry kwicEntry = kWICEntryArray[n2];
                    URI objectUri = ((TextGridObject)AdapterUtils.getAdapterChecked((Object)kwicEntry, TextGridObject.class)).getURI();
                    String path = kwicEntry.getPath();
                    URI uri = new URI(objectUri.getScheme(), objectUri.getSchemeSpecificPart(), "xpath(" + path + ")");
                    uris.add(uri);
                    ++n2;
                }
                String uriString = Joiner.on((String)"\n").join((Iterable)uris);
                if (uriString.length() > 0) {
                    Clipboard clipboard = new Clipboard(HandlerUtil.getActiveShell((ExecutionEvent)event).getDisplay());
                    clipboard.setContents(new Object[]{uriString.toString()}, new Transfer[]{TextTransfer.getInstance()});
                }
            }
            catch (AdapterUtils.AdapterNotFoundException e) {
                StatusManager.getManager().handle((CoreException)((Object)e), "info.textgrid.lab.search.ui");
            }
            catch (URISyntaxException e) {
                StatusManager.getManager().handle((IStatus)new Status(4, "info.textgrid.lab.search.ui", Messages.CopyKWICURI_ErrorMessage1, (Throwable)e));
            }
        }
        return null;
    }
}

