/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.action;

import java.util.ArrayList;
import net.sf.vex.action.AbstractVexAction;
import net.sf.vex.action.ActionUtils;
import net.sf.vex.action.TableCellCallback;
import net.sf.vex.dom.IVexElement;
import net.sf.vex.widget.IVexWidget;

public class InsertColumnBeforeAction
extends AbstractVexAction {
    @Override
    public void run(final IVexWidget vexWidget) {
        vexWidget.doWork(new Runnable(){

            @Override
            public void run() {
                final int indexToDup = ActionUtils.getCurrentColumnIndex(vexWidget);
                if (indexToDup == -1) {
                    return;
                }
                final ArrayList cellsToDup = new ArrayList();
                ActionUtils.iterateTableCells(vexWidget, new TableCellCallback(){

                    @Override
                    public void startRow(Object row, int rowIndex) {
                    }

                    @Override
                    public void onCell(Object row, Object cell, int rowIndex, int cellIndex) {
                        if (cellIndex == indexToDup && cell instanceof IVexElement) {
                            cellsToDup.add(cell);
                        }
                    }

                    @Override
                    public void endRow(Object row, int rowIndex) {
                    }
                });
                int finalOffset = -1;
                for (IVexElement element : cellsToDup) {
                    if (finalOffset == -1) {
                        finalOffset = element.getStartOffset() + 1;
                    }
                    vexWidget.moveTo(element.getStartOffset());
                    vexWidget.insertElement(element.clone());
                }
                if (finalOffset != -1) {
                    vexWidget.moveTo(finalOffset);
                }
            }
        });
    }

    @Override
    public boolean isEnabled(IVexWidget vexWidget) {
        return ActionUtils.getCurrentColumnIndex(vexWidget) != -1;
    }
}

