/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.css;

import net.sf.vex.css.AbstractProperty;
import net.sf.vex.css.Styles;
import org.w3c.css.sac.LexicalUnit;

public class ListStyleTypeProperty
extends AbstractProperty {
    public ListStyleTypeProperty() {
        super("list-style-type");
    }

    @Override
    public Object calculate(LexicalUnit lu, Styles parentStyles, Styles styles) {
        if (ListStyleTypeProperty.isListStyleType(lu)) {
            return lu.getStringValue();
        }
        if (parentStyles == null) {
            return "disc";
        }
        return parentStyles.getListStyleType();
    }

    private static boolean isListStyleType(LexicalUnit lu) {
        if (lu == null || lu.getLexicalUnitType() != 35) {
            return false;
        }
        String s = lu.getStringValue();
        return s.equalsIgnoreCase("armenian") || s.equalsIgnoreCase("circle") || s.equalsIgnoreCase("cjk-ideographic") || s.equalsIgnoreCase("decimal") || s.equalsIgnoreCase("decimal-leading-zero") || s.equalsIgnoreCase("disc") || s.equalsIgnoreCase("georgian") || s.equalsIgnoreCase("hebrew") || s.equalsIgnoreCase("hiragana") || s.equalsIgnoreCase("hiragana-iroha") || s.equalsIgnoreCase("katakana") || s.equalsIgnoreCase("katakana-iroha") || s.equalsIgnoreCase("lower-alpha") || s.equalsIgnoreCase("lower-greek") || s.equalsIgnoreCase("lower-latin") || s.equalsIgnoreCase("lower-roman") || s.equalsIgnoreCase("none") || s.equalsIgnoreCase("square") || s.equalsIgnoreCase("upper-alpha") || s.equalsIgnoreCase("upper-latin") || s.equalsIgnoreCase("upper-roman");
    }
}

