/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.dom.linked;

import java.text.MessageFormat;
import net.sf.vex.dom.linked.LinkedNode;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.w3c.dom.CharacterData;

public abstract class LinkedNonElement
extends LinkedNode {
    protected LinkedNonElement(CharacterData cdata) {
        super(cdata);
    }

    @Override
    public CharacterData getDomNode() {
        return (CharacterData)super.getDomNode();
    }

    protected void deleteTextAbs(int startOffset, int endOffset) {
        if (startOffset < this.getStartOffset() || endOffset > this.getEndOffset()) {
            throw new IllegalArgumentException(MessageFormat.format("The text fragment to delete ({0}..{1}) is not completely managed by this NonElement node ({2})", startOffset, endOffset, this));
        }
        int relOffset = startOffset - this.getStartOffset();
        int length = endOffset - startOffset;
        this.getDomNode().deleteData(relOffset + this.getCorrectionForContentPos() - 4, length);
    }

    public void insertTextAbs(int offset, String s) {
        int startOffset = this.getStartOffset();
        if (--offset < startOffset || offset > this.getEndOffset()) {
            throw new IllegalArgumentException(MessageFormat.format("Cannot insert {0} into {1} at offset {2}: Off limits", s, this, offset));
        }
        int relOffset = offset - startOffset;
        this.getDomNode().insertData(relOffset + this.getCorrectionForContentPos() - 3, s);
        if (relOffset == 0) {
            this.setContent(this.getContent(), startOffset, this.getEndOffset());
        }
    }

    @Override
    public void notifyChanged(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
        switch (eventType) {
            case 1: 
            case 2: {
                if (!(newValue instanceof String)) break;
                String newContent = (String)newValue;
                newContent.length();
                int startOffset = this.getStartOffset();
                int endOffset = this.getEndOffset();
                int oldLength = endOffset - startOffset;
                this.getContent().insertString(endOffset, newContent);
                this.getContent().remove(startOffset + 1, oldLength - 1);
                return;
            }
        }
        super.notifyChanged(notifier, eventType, changedFeature, oldValue, newValue, pos);
    }

    public int getContentOffsetFor(int sourceOffset) {
        int nodeSourceOffset = ((IndexedRegion)this.getAdapter(IndexedRegion.class)).getStartOffset();
        int relOffset = sourceOffset - nodeSourceOffset;
        return this.getStartOffset() + (relOffset += this.getCorrectionForSourcePos());
    }

    public abstract int getCorrectionForSourcePos();

    public abstract int getCorrectionForContentPos();
}

