/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.editor.config;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import net.sf.vex.dom.Validator;
import net.sf.vex.editor.VexPlugin;
import net.sf.vex.editor.config.ConfigEvent;
import net.sf.vex.editor.config.ConfigRegistry;
import net.sf.vex.editor.config.DocumentType;
import net.sf.vex.editor.config.IConfigListener;
import net.sf.vex.editor.config.Messages;
import net.sf.vex.editor.config.PluginProject;
import org.eclipse.core.resources.IFile;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;

public class DoctypePropertyPage
extends PropertyPage {
    private DocumentType doctype;
    private static final int NAME_WIDTH = 150;
    private Composite pane;
    private Text nameText;
    private Text publicIdText;
    private Text systemIdText;
    private Table rootElementsTable;
    private IConfigListener configListener;

    protected Control createContents(Composite parent) {
        this.pane = new Composite(parent, 0);
        this.createPropertySheet();
        this.configListener = new IConfigListener(){

            @Override
            public void configChanged(ConfigEvent e) {
                String resourcePath = ((IFile)DoctypePropertyPage.this.getElement()).getProjectRelativePath().toString();
                PluginProject config = DoctypePropertyPage.this.getPluginProject();
                DoctypePropertyPage.this.doctype = (DocumentType)config.getItemForResource(resourcePath);
                DoctypePropertyPage.this.populateRootElements();
            }

            @Override
            public void configLoaded(ConfigEvent e) {
                DoctypePropertyPage.this.setMessage(DoctypePropertyPage.this.getTitle());
                DoctypePropertyPage.this.populateDoctype();
                DoctypePropertyPage.this.setValid(true);
                try {
                    DoctypePropertyPage.this.getPluginProject().writeConfigXml();
                }
                catch (Exception ex) {
                    String message = MessageFormat.format(Messages.getString("DoctypePropertyPage.errorWritingConfig"), "vex-plugin.xml");
                    VexPlugin.getInstance().log(4, message, ex);
                }
            }
        };
        ConfigRegistry.getInstance().addConfigListener(this.configListener);
        if (ConfigRegistry.getInstance().isConfigLoaded()) {
            this.populateDoctype();
            this.populateRootElements();
        } else {
            this.setValid(false);
            this.setMessage(Messages.getString("DoctypePropertyPage.loading"));
        }
        return this.pane;
    }

    private void createPropertySheet() {
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this.pane.setLayout((Layout)layout);
        Label label = new Label(this.pane, 0);
        label.setText(Messages.getString("DoctypePropertyPage.name"));
        this.nameText = new Text(this.pane, 2048);
        GridData gd = new GridData();
        gd.widthHint = 150;
        this.nameText.setLayoutData((Object)gd);
        label = new Label(this.pane, 0);
        label.setText(Messages.getString("DoctypePropertyPage.publicId"));
        this.publicIdText = new Text(this.pane, 2048);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.publicIdText.setLayoutData((Object)gd);
        label = new Label(this.pane, 0);
        label.setText(Messages.getString("DoctypePropertyPage.systemId"));
        this.systemIdText = new Text(this.pane, 2048);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.systemIdText.setLayoutData((Object)gd);
        String resourcePath = ((IFile)this.getElement()).getProjectRelativePath().toString();
        PluginProject config = this.getPluginProject();
        this.doctype = (DocumentType)config.getItemForResource(resourcePath);
        if (this.doctype == null) {
            this.doctype = new DocumentType(config);
            this.doctype.setResourcePath(resourcePath);
            config.addItem(this.doctype);
        }
        if (this.doctype.getSimpleId() == null || this.doctype.getSimpleId().length() == 0) {
            this.doctype.setSimpleId(this.doctype.generateSimpleId());
        }
        label = new Label(this.pane, 0);
        label.setText(Messages.getString("DoctypePropertyPage.rootElements"));
        gd = new GridData();
        gd.verticalAlignment = 1;
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        Composite tablePane = new Composite(this.pane, 2048);
        gd = new GridData(1808);
        gd.heightHint = 200;
        gd.horizontalSpan = 2;
        tablePane.setLayoutData((Object)gd);
        FillLayout fillLayout = new FillLayout();
        tablePane.setLayout((Layout)fillLayout);
        this.rootElementsTable = new Table(tablePane, 32);
    }

    public PluginProject getPluginProject() {
        IFile file = (IFile)this.getElement();
        return PluginProject.get(file.getProject());
    }

    public boolean performOk() {
        this.performApply();
        return super.performOk();
    }

    public void performApply() {
        this.doctype.setName(this.nameText.getText());
        this.doctype.setPublicId(this.publicIdText.getText());
        this.doctype.setSystemId(this.systemIdText.getText());
        TableItem[] tia = this.rootElementsTable.getItems();
        ArrayList<String> selectedRootElements = new ArrayList<String>();
        int i = 0;
        while (i < tia.length) {
            if (tia[i].getChecked()) {
                selectedRootElements.add(tia[i].getText());
            }
            ++i;
        }
        String[] selectedRootElementsArray = new String[selectedRootElements.size()];
        int i2 = 0;
        while (i2 < selectedRootElementsArray.length) {
            selectedRootElementsArray[i2] = (String)selectedRootElements.get(i2);
            ++i2;
        }
        this.doctype.setRootElements(selectedRootElementsArray);
        try {
            this.getPluginProject().writeConfigXml();
        }
        catch (Exception ex) {
            String message = MessageFormat.format(Messages.getString("DoctypePropertyPage.errorWritingConfig"), "vex-plugin.xml");
            VexPlugin.getInstance().log(4, message, ex);
        }
        ConfigRegistry.getInstance().fireConfigChanged(new ConfigEvent((Object)this));
    }

    public void performDefaults() {
        super.performDefaults();
        this.populateDoctype();
        this.populateRootElements();
    }

    public void dispose() {
        super.dispose();
        if (this.configListener != null) {
            ConfigRegistry.getInstance().removeConfigListener(this.configListener);
        }
    }

    private void populateDoctype() {
        this.setText(this.nameText, this.doctype.getName());
        this.setText(this.publicIdText, this.doctype.getPublicId());
        this.setText(this.systemIdText, this.doctype.getSystemId());
    }

    private void populateRootElements() {
        String resourcePath = ((IFile)this.getElement()).getProjectRelativePath().toString();
        Validator validator = (Validator)this.getPluginProject().getParsedResource(resourcePath);
        if (validator != null) {
            List<String> list = Arrays.asList(this.doctype.getRootElements());
            TreeSet<String> selectedRootElements = new TreeSet<String>(list);
            this.rootElementsTable.removeAll();
            ArrayList l = new ArrayList(validator.getValidRootElements());
            Collections.sort(l);
            int i = 0;
            while (i < l.size()) {
                TableItem item1 = new TableItem(this.rootElementsTable, 0);
                item1.setText((String)l.get(i));
                if (selectedRootElements.contains((String)l.get(i))) {
                    item1.setChecked(true);
                }
                ++i;
            }
        } else {
            try {
                this.getPluginProject().writeConfigXml();
            }
            catch (Exception ex) {
                String message = MessageFormat.format(Messages.getString("DoctypePropertyPage.errorWritingConfig"), "vex-plugin.xml");
                VexPlugin.getInstance().log(4, message, ex);
            }
        }
    }

    private void setText(Text textBox, String s) {
        textBox.setText(s == null ? "" : s);
    }
}

