/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.ui.core.handlers;

import info.textgrid.lab.authn.AuthBrowser;
import info.textgrid.lab.authn.RBACSession;
import info.textgrid.lab.conf.OnlineStatus;
import info.textgrid.lab.core.model.TextGridProject;
import info.textgrid.lab.log.logsession;
import info.textgrid.lab.ui.core.Activator;
import info.textgrid.lab.ui.core.handlers.Messages;
import info.textgrid.namespaces.middleware.tgauth.AuthenticationFault;
import info.textgrid.namespaces.middleware.tgauth.BooleanResponse;
import info.textgrid.namespaces.middleware.tgauth.DeactivateProjectRequest;
import info.textgrid.namespaces.middleware.tgauth.PortTgextra;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class DeactivateProjectDialog
extends Dialog {
    Map<TextGridProject, Boolean> projectsToDeactivate = new HashMap<TextGridProject, Boolean>();
    Map<TextGridProject, String> projectsMessage = new HashMap<TextGridProject, String>();
    Button okButton;
    Job currentJob;
    PortTgextra stub;
    TableViewer tableViewer;
    Label statusLabel;
    private static final String DEACTIVATE_INFO1 = Messages.DeactivateProjectDialog_Info1;
    private static final String DEACTIVATE_INFO2 = Messages.DeactivateProjectDialog_Info2;

    public DeactivateProjectDialog(Shell shell, Object[] obj) {
        super(shell);
        this.initialise(obj);
    }

    public DeactivateProjectDialog(IShellProvider parentShell, Object[] obj) {
        super(parentShell);
        this.initialise(obj);
    }

    protected void initialise(Object[] obj) {
        int i = 0;
        while (i < obj.length) {
            if (obj[i] instanceof TextGridProject) {
                this.projectsToDeactivate.put((TextGridProject)obj[i], false);
            }
            ++i;
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, true).setFocus();
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        OnlineStatus.isOnlineWithNotification((String)Messages.DeactivateProjectDialog_IM_Online);
        this.okButton.setEnabled(false);
    }

    protected void buttonPressed(int buttonId) {
        super.buttonPressed(buttonId);
        if (buttonId == 1) {
            if (this.currentJob != null) {
                this.currentJob.cancel();
            }
            this.close();
        } else if (buttonId == 0) {
            DeactivateProjectRequest request = new DeactivateProjectRequest();
            request.setAuth(RBACSession.getInstance().getSID(true));
            request.setLog(logsession.getInstance().getloginfo());
            boolean deactivated = true;
            for (TextGridProject p : this.projectsToDeactivate.keySet()) {
                if (!this.projectsToDeactivate.get(p).booleanValue()) continue;
                request.setProject(p.getId());
                try {
                    BooleanResponse br = this.stub.deactivateProject(request);
                    deactivated = br.isResult();
                }
                catch (AuthenticationFault e) {
                    Activator.handleError(e, Messages.DeactivateProjectDialog_IM_NotAllowed, p);
                }
            }
            if (!deactivated) {
                MessageDialog.open((int)1, null, (String)Messages.DeactivateProjectDialog_IM_OperationFailed, (String)Messages.DeactivateProjectDialog_IM_OperationNotSucceed, (int)0);
            } else {
                AuthBrowser.sessionChanged();
            }
            this.close();
        }
    }

    protected Control createDialogArea(Composite parent) {
        Group g = new Group(parent, 0);
        g.setLayout((Layout)new GridLayout());
        this.tableViewer = new TableViewer((Composite)g, 2560);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new DeleteTableContentProvider());
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableViewer.setSorter(new ViewerSorter());
        this.tableViewer.setInput(this.projectsToDeactivate.keySet());
        GridData gd = new GridData(4, 4, false, false);
        gd.heightHint = 100;
        gd.widthHint = 500;
        this.tableViewer.getControl().setLayoutData((Object)gd);
        this.statusLabel = new Label((Composite)g, 0);
        this.statusLabel.setText(String.valueOf(DEACTIVATE_INFO1) + DEACTIVATE_INFO2);
        this.getShell().setText(Messages.DeactivateProjectDialog_DeactivateProject);
        this.launchCheckJob(this.projectsToDeactivate);
        return g;
    }

    private void launchCheckJob(final Map<TextGridProject, Boolean> projectMap) {
        this.currentJob = new Job(Messages.DeactivateProjectDialog_CheckPermissions){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(Messages.DeactivateProjectDialog_CheckPermissions, -1);
                DeactivateProjectDialog.this.stub = TextGridProject.ensureStubIsLoaded();
                monitor.worked(1);
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                boolean projectToDeactivate = false;
                for (final TextGridProject project : projectMap.keySet()) {
                    boolean canDelete = true;
                    String whyNot = "";
                    if (!project.iAmLeader()) {
                        canDelete = false;
                        whyNot = NLS.bind((String)Messages.DeactivateProjectDialog_IM_OperationNotPermitted, (Object)TextGridProject.findLabelForRBACRole((String)"Projektleiter"));
                    }
                    monitor.worked(1);
                    if (monitor.isCanceled() || DeactivateProjectDialog.this.tableViewer.getControl().isDisposed()) {
                        return Status.CANCEL_STATUS;
                    }
                    if (canDelete) {
                        DeactivateProjectDialog.this.projectsToDeactivate.put(project, true);
                        DeactivateProjectDialog.this.projectsMessage.put(project, Messages.DeactivateProjectDialog_IM_OperationPermitted);
                        projectToDeactivate = true;
                    } else {
                        DeactivateProjectDialog.this.projectsMessage.put(project, whyNot);
                    }
                    DeactivateProjectDialog.this.tableViewer.getControl().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            (this).DeactivateProjectDialog.this.tableViewer.refresh((Object)project);
                            (this).DeactivateProjectDialog.this.tableViewer.reveal((Object)project);
                        }
                    });
                }
                final boolean deactivate = projectToDeactivate;
                DeactivateProjectDialog.this.tableViewer.getControl().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (deactivate) {
                            (this).DeactivateProjectDialog.this.okButton.setEnabled(true);
                        }
                        (this).DeactivateProjectDialog.this.statusLabel.setText(DEACTIVATE_INFO1);
                    }
                });
                return Status.OK_STATUS;
            }
        };
        this.currentJob.setPriority(30);
        this.currentJob.schedule();
    }

    class DeleteTableContentProvider
    extends LabelProvider {
        DeleteTableContentProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof TextGridProject) {
                if (DeactivateProjectDialog.this.projectsToDeactivate.get(element).booleanValue()) {
                    return Activator.getDefault().getImageRegistry().getDescriptor("complete").createImage();
                }
                return Activator.getDefault().getImageRegistry().getDescriptor("forbidden_object").createImage();
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof TextGridProject && DeactivateProjectDialog.this.projectsMessage.get(element) != null) {
                return String.valueOf(element.toString()) + " - " + DeactivateProjectDialog.this.projectsMessage.get(element);
            }
            return element.toString();
        }
    }
}

