/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.dom.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import net.sf.vex.dom.Content;
import net.sf.vex.dom.DocumentValidationException;
import net.sf.vex.dom.IVexDocumentFragment;
import net.sf.vex.dom.IVexElement;
import net.sf.vex.dom.IVexNode;
import net.sf.vex.dom.IVexText;
import net.sf.vex.dom.impl.Document;
import net.sf.vex.dom.impl.Element;
import net.sf.vex.dom.impl.SwingGapContentWrapper;

public class DocumentFragment
implements Serializable,
IVexDocumentFragment {
    private Content content;
    private IVexElement[] elements;

    public DocumentFragment(Content content, IVexElement[] elements) {
        this.content = content;
        this.elements = elements;
    }

    @Override
    public Content getContent() {
        return this.content;
    }

    @Override
    public int getLength() {
        return this.content.getLength();
    }

    @Override
    public IVexElement[] getElements() {
        return this.elements;
    }

    @Override
    public String[] getNodeNames() {
        IVexNode[] nodes = this.getNodes();
        String[] names = new String[nodes.length];
        int i = 0;
        while (i < nodes.length) {
            names[i] = nodes[i] instanceof IVexText ? "#PCDATA" : ((IVexElement)nodes[i]).getName();
            ++i;
        }
        return names;
    }

    @Override
    public IVexNode[] getNodes() {
        return Document.createNodeArray(this.getContent(), 0, this.getContent().getLength(), this.getElements());
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeUTF(this.content.getString(0, this.content.getLength()));
        out.writeInt(this.elements.length);
        int i = 0;
        while (i < this.elements.length) {
            this.writeElement(this.elements[i], out);
            ++i;
        }
    }

    private void writeElement(IVexElement element, ObjectOutputStream out) throws IOException {
        out.writeObject(element.getName());
        out.writeInt(element.getStartOffset());
        out.writeInt(element.getEndOffset());
        String[] attrNames = element.getAttributeNames();
        out.writeInt(attrNames.length);
        int i = 0;
        while (i < attrNames.length) {
            out.writeObject(attrNames[i]);
            out.writeObject(element.getAttribute(attrNames[i]));
            ++i;
        }
        IVexElement[] children = element.getChildElements();
        out.writeInt(children.length);
        int i2 = 0;
        while (i2 < children.length) {
            this.writeElement(children[i2], out);
            ++i2;
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        String s = in.readUTF();
        this.content = new SwingGapContentWrapper(s.length());
        this.content.insertString(0, s);
        int n = in.readInt();
        this.elements = new IVexElement[n];
        int i = 0;
        while (i < n) {
            this.elements[i] = this.readElement(in);
            ++i;
        }
    }

    private IVexElement readElement(ObjectInputStream in) throws IOException, ClassNotFoundException {
        String name = (String)in.readObject();
        int startOffset = in.readInt();
        int endOffset = in.readInt();
        Element element = new Element(name);
        element.setContent(this.content, startOffset, endOffset);
        int attrCount = in.readInt();
        int i = 0;
        while (i < attrCount) {
            String key = (String)in.readObject();
            String value = (String)in.readObject();
            try {
                element.setAttribute(key, value);
            }
            catch (DocumentValidationException e) {
                e.printStackTrace();
            }
            ++i;
        }
        int childCount = in.readInt();
        int i2 = 0;
        while (i2 < childCount) {
            IVexElement child = this.readElement(in);
            child.setParent(element);
            element.internalInsertChild(i2, child);
            ++i2;
        }
        return element;
    }
}

