/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.layout;

import net.sf.vex.core.Color;
import net.sf.vex.core.ColorResource;
import net.sf.vex.core.FontMetrics;
import net.sf.vex.core.FontResource;
import net.sf.vex.core.FontSpec;
import net.sf.vex.core.Graphics;
import net.sf.vex.core.Insets;
import net.sf.vex.core.Rectangle;
import net.sf.vex.css.Styles;
import net.sf.vex.dom.IVexElement;
import net.sf.vex.layout.AbstractBox;
import net.sf.vex.layout.AnnotationRenderingInfo;
import net.sf.vex.layout.Clickable;
import net.sf.vex.layout.InlineBox;
import net.sf.vex.layout.LayoutContext;
import net.sf.vex.layout.VexAnnotationTracker;

public class LabeledInlineMarkerBox
extends AbstractBox
implements InlineBox,
Clickable {
    private IVexElement element;
    protected int size;
    protected static final int[] colorSpec = new int[]{150, 150, 255};
    String[] fontFamily = new String[]{"sans-serif"};
    protected String elementName;
    protected int width;
    protected FontResource fr;
    protected boolean isLeftMarker;

    public LabeledInlineMarkerBox(LayoutContext context, float markerSize, IVexElement element, boolean isLeftMarker) {
        this.element = element;
        this.size = (int)markerSize;
        FontResource font = context.getGraphics().createFont(new FontSpec(this.fontFamily, 0, (float)this.size * 0.8f));
        FontResource oldFont = context.getGraphics().setFont(font);
        this.elementName = element.getName();
        this.width = context.getGraphics().charsWidth(this.elementName.toCharArray(), 0, this.elementName.length());
        this.isLeftMarker = isLeftMarker;
        this.setWidth(this.width + this.size);
        this.setHeight(this.size);
        context.getGraphics().setFont(oldFont);
        font.dispose();
    }

    @Override
    public int getBaseline() {
        return 0;
    }

    @Override
    public IVexElement getElement() {
        return this.element;
    }

    @Override
    public boolean isEOL() {
        return false;
    }

    @Override
    public InlineBox.Pair split(LayoutContext context, int maxWidth, boolean force) {
        return new InlineBox.Pair(null, this);
    }

    @Override
    public void paint(LayoutContext context, int x, int y, Rectangle area) {
        Graphics g = context.getGraphics();
        Styles styles = context.getStyleSheet().getStyles(this.element);
        boolean drawSelected = false;
        drawSelected = this.isLeftMarker ? this.getElement().getStartOffset() >= context.getSelectionStart() && this.getElement().getStartOffset() + 1 <= context.getSelectionEnd() : this.getElement().getEndOffset() >= context.getSelectionStart() && this.getElement().getEndOffset() + 1 <= context.getSelectionEnd();
        FontMetrics fm = g.getFontMetrics();
        FontResource oldFont = g.getFont();
        ColorResource oldColor = g.getColor();
        FontResource font = context.getGraphics().createFont(new FontSpec(this.fontFamily, 0, (int)((float)this.size * 0.8f)));
        AnnotationRenderingInfo rendering = VexAnnotationTracker.getRenderingInfo(context, this.getElement());
        ColorResource color = rendering != null && rendering.isShownInText() ? g.createColor(rendering.getColor()) : g.createColor(new Color(colorSpec[0], colorSpec[1], colorSpec[2]));
        if (drawSelected) {
            Rectangle bounds = this.getBounds();
            g.setColor(g.getSystemColor(0));
            g.fillRect(x + bounds.getX(), y, bounds.getWidth(), styles.getLineHeight() - fm.getDescent());
            g.setColor(g.getSystemColor(1));
        } else {
            g.setColor(color);
        }
        g.setFont(font);
        g.setLineStyle(0);
        g.setLineWidth(1);
        if (this.isLeftMarker) {
            g.drawLine(x, y, x, y + this.size);
            g.drawLine(x, y, x + this.width, y);
            g.drawLine(x, y + this.size, x + this.width, y + this.size);
            g.drawLine(x + this.width, y + this.size, x + this.width + this.size - 1, y + this.size / 2);
            g.drawLine(x + this.width + this.size - 1, y + this.size / 2, x + this.width, y);
            g.drawString(this.elementName, x + 2, y + (int)((float)this.size * 0.1f) - 2);
        } else {
            g.drawString(this.elementName, x - 2 + this.size, y + (int)((float)this.size * 0.1f) - 2);
            g.drawLine(x + this.width + this.size, y, x + this.width + this.size, y + this.size);
            g.drawLine(x + this.size, y, x + this.width + this.size, y);
            g.drawLine(x + this.size, y + this.size, x + this.width + this.size, y + this.size);
            g.drawLine(x + this.size, y + this.size, x + 1, y + this.size / 2);
            g.drawLine(x + 1, y + this.size / 2, x + this.size, y);
            g.setFont(oldFont);
            g.setColor(oldColor);
            font.dispose();
            color.dispose();
        }
    }

    public String toString() {
        return "[shape]";
    }

    public Rectangle getBounds() {
        return new Rectangle(0, this.size, this.width + this.size, this.size);
    }

    @Override
    public Insets getInsets(LayoutContext context, int containerWidth) {
        return new Insets(3, 3, 3, 3);
    }

    @Override
    public void click(int x, int y) {
    }
}

