/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.layout;

import java.util.List;
import net.sf.vex.core.Rectangle;
import net.sf.vex.css.Styles;
import net.sf.vex.dom.IVexElement;
import net.sf.vex.layout.AbstractBlockBox;
import net.sf.vex.layout.BlockBox;
import net.sf.vex.layout.LayoutContext;

public class TableCellBox
extends AbstractBlockBox {
    public TableCellBox(LayoutContext context, BlockBox parent, IVexElement element, int width) {
        super(context, parent, element);
        Styles styles = context.getStyleSheet().getStyles(element);
        this.setWidth(width - styles.getBorderLeftWidth() - styles.getPaddingLeft().get(parent.getWidth()) - styles.getPaddingRight().get(parent.getWidth()) - styles.getBorderRightWidth());
    }

    public TableCellBox(LayoutContext context, BlockBox parent, int startOffset, int endOffset, int width) {
        super(context, parent, startOffset, endOffset);
        this.setWidth(width);
    }

    @Override
    protected List createChildren(LayoutContext context) {
        return this.createBlockBoxes(context, this.getStartOffset(), this.getEndOffset(), this.getWidth(), null, null);
    }

    @Override
    public void setInitialSize(LayoutContext context) {
        this.setHeight(this.getEstimatedHeight(context));
    }

    @Override
    public void paint(LayoutContext context, int x, int y, Rectangle area) {
        super.paint(context, x, y, area);
        if (this.getElement() != null && context.showBlockMarkers()) {
            this.paintMarkerFrame(context, x, y, this.getParent().getWidth());
        }
    }
}

