/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.layout;

import java.text.MessageFormat;
import net.sf.vex.core.Caret;
import net.sf.vex.core.ColorResource;
import net.sf.vex.core.FontMetrics;
import net.sf.vex.core.FontResource;
import net.sf.vex.core.Graphics;
import net.sf.vex.css.Styles;
import net.sf.vex.dom.IVexElement;
import net.sf.vex.dom.IVexNode;
import net.sf.vex.layout.AbstractBox;
import net.sf.vex.layout.AnnotationRenderingInfo;
import net.sf.vex.layout.InlineBox;
import net.sf.vex.layout.LayoutContext;
import net.sf.vex.layout.TextCaret;
import net.sf.vex.layout.VexAnnotationTracker;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.statushandlers.StatusManager;

public abstract class TextBox
extends AbstractBox
implements InlineBox {
    private IVexNode node;
    private Styles styles = null;
    private int baseline;
    public static final char NEWLINE_CHAR = '\n';
    public static final String NEWLINE_STRING = "\n";

    public static boolean isNewline(char ch) {
        return ch == '\n' || ch == '\n';
    }

    public TextBox(IVexElement pseudoElement) {
        this.node = pseudoElement;
    }

    public TextBox(Styles styles, IVexNode node) {
        this.styles = styles;
        this.node = node;
    }

    protected Styles getStyles(LayoutContext context) {
        if (this.styles != null) {
            return this.styles;
        }
        if (this.node instanceof IVexElement) {
            return context.getStyleSheet().getStyles(this.getElement());
        }
        throw new IllegalStateException("I have got no style and no element!");
    }

    protected void calculateSize(LayoutContext context) {
        String s = this.getText();
        if (s.endsWith(NEWLINE_STRING)) {
            s = s.substring(0, s.length() - 1);
        }
        Graphics g = context.getGraphics();
        Styles styles = this.getStyles(context);
        FontResource font = g.createFont(styles.getFont());
        FontResource oldFont = g.setFont(font);
        FontMetrics fm = g.getFontMetrics();
        this.setWidth(g.stringWidth(s));
        this.setHeight(styles.getLineHeight());
        int halfLeading = (this.getHeight() - (fm.getAscent() + fm.getDescent())) / 2;
        this.baseline = halfLeading + fm.getAscent();
        g.setFont(oldFont);
        font.dispose();
    }

    @Override
    public int getBaseline() {
        return this.baseline;
    }

    @Override
    public Caret getCaret(LayoutContext context, int offset) {
        Graphics g = context.getGraphics();
        Styles styles = this.getStyles(context);
        FontResource oldFont = g.getFont();
        FontResource font = g.createFont(styles.getFont());
        g.setFont(font);
        char[] chars = this.getText().toCharArray();
        int x = g.charsWidth(chars, 0, offset - this.getStartOffset());
        g.setFont(oldFont);
        font.dispose();
        return new TextCaret(x, 0, this.getHeight());
    }

    @Override
    public IVexElement getElement() {
        if (this.node instanceof IVexElement) {
            return (IVexElement)this.node;
        }
        return null;
    }

    public IVexNode getNode() {
        return this.node;
    }

    public abstract String getText();

    public static boolean isSplitChar(char c) {
        return Character.isWhitespace(c);
    }

    @Override
    public boolean isEOL() {
        String s = this.getText();
        return s.length() > 0 && TextBox.isNewline(s.charAt(s.length() - 1));
    }

    protected void paintSelectedText(LayoutContext context, String s, int x, int y) {
        Graphics g = context.getGraphics();
        int width = g.stringWidth(s);
        g.setColor(g.getSystemColor(0));
        g.fillRect(x, y, width, this.getHeight());
        g.setColor(g.getSystemColor(1));
        g.drawString(s, x, y);
    }

    protected void paintTextDecoration(LayoutContext context, Styles styles, String s, int startOffset, int endOffset, int x, int y) {
        int ypos;
        int lineWidth;
        int fontStyle = styles.getFont().getStyle();
        Graphics g = context.getGraphics();
        FontMetrics fm = g.getFontMetrics();
        if ((fontStyle & 4) != 0) {
            lineWidth = fm.getAscent() / 12;
            ypos = y + fm.getAscent() + lineWidth;
            this.paintBaseLine(g, s, x, ypos + 5);
        }
        if ((fontStyle & 8) != 0) {
            lineWidth = fm.getAscent() / 12;
            ypos = y + lineWidth / 2;
            this.paintBaseLine(g, s, x, ypos);
        }
        if ((fontStyle & 0x10) != 0) {
            int ypos2 = y + fm.getHeight() / 2;
            this.paintBaseLine(g, s, x, ypos2);
        }
        this.paintTextAnnotations(context, startOffset, endOffset, s, x, y, g, fm);
    }

    protected void paintTextAnnotations(LayoutContext context, int startOffset, int endOffset, String s, int x, int y, Graphics g, FontMetrics fm) {
        AnnotationRenderingInfo rendering = VexAnnotationTracker.getRenderingInfo(context, this.getNode());
        if (rendering != null && rendering.isShownInText()) {
            ColorResource oldColor = g.getColor();
            ColorResource annotationColor = g.createColor(rendering.getColor());
            try {
                g.setColor(annotationColor);
                int lineWidth = fm.getAscent() / 12;
                int ypos = y + fm.getAscent() + lineWidth;
                this.paintBaseLine(g, s, x, ypos);
            }
            finally {
                g.setColor(oldColor);
                annotationColor.dispose();
            }
        }
    }

    protected void paintBaseLine(Graphics g, String s, int x, int y) {
        FontMetrics fm = g.getFontMetrics();
        int width = g.stringWidth(s);
        int lineWidth = fm.getAscent() / 12;
        g.setLineStyle(0);
        g.setLineWidth(lineWidth);
        g.drawLine(x, y, x + width, y);
    }

    @Override
    public InlineBox.Pair split(LayoutContext context, int maxWidth, boolean force) {
        char[] chars = this.getText().toCharArray();
        if (chars.length == 0) {
            StatusManager.getManager().handle((IStatus)new Status(2, "net.sf.vex.toolkit", MessageFormat.format("Someone tried to split a text box that does not contain text. Node: {0}, box start: {1}, end: {2}, text: {3}", this.getNode(), this.getStartOffset(), this.getEndOffset(), this.getText()), (Throwable)new IllegalStateException("I don't want to be split! I'm only 0 characters long!!!\n   (Love, net.sf.vex.layout.TextBox)")));
            return new InlineBox.Pair(this, null);
        }
        Graphics g = context.getGraphics();
        Styles styles = this.getStyles(context);
        FontResource font = g.createFont(styles.getFont());
        FontResource oldFont = g.setFont(font);
        int split = 0;
        int next = 1;
        boolean eol = false;
        while (next < chars.length) {
            if (TextBox.isSplitChar(chars[next - 1])) {
                if (g.charsWidth(chars, 0, next) > maxWidth) break;
                split = next;
                if (TextBox.isNewline(chars[next - 1])) {
                    eol = true;
                    break;
                }
            }
            ++next;
        }
        if (force && split == 0) {
            split = 1;
            while (split < chars.length) {
                if (g.charsWidth(chars, 0, split + 1) > maxWidth) break;
                ++split;
            }
        }
        int i = 0;
        while (i < chars.length) {
            if (TextBox.isNewline(chars[i])) {
                split = i + 1;
                eol = true;
            }
            ++i;
        }
        if (!eol) {
            while (split < chars.length - 1 && chars[split] == ' ') {
                ++split;
            }
        }
        g.setFont(oldFont);
        font.dispose();
        return this.splitAt(context, split);
    }

    public abstract InlineBox.Pair splitAt(LayoutContext var1, int var2);

    public String toString() {
        return this.getText();
    }
}

