/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.swing;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.vex.core.Color;
import net.sf.vex.core.ColorResource;
import net.sf.vex.core.DisplayDevice;
import net.sf.vex.core.Rectangle;
import net.sf.vex.css.StyleSheet;
import net.sf.vex.dom.DocumentValidationException;
import net.sf.vex.dom.IVexDocument;
import net.sf.vex.dom.IVexDocumentFragment;
import net.sf.vex.dom.IVexElement;
import net.sf.vex.dom.impl.Element;
import net.sf.vex.layout.Box;
import net.sf.vex.layout.BoxFactory;
import net.sf.vex.swing.AwtDisplayDevice;
import net.sf.vex.swing.AwtGraphics;
import net.sf.vex.swing.SelectionListener;
import net.sf.vex.swing.SelectionProvider;
import net.sf.vex.swing.SelectionProviderImpl;
import net.sf.vex.swing.VexSelection;
import net.sf.vex.widget.HostComponent;
import net.sf.vex.widget.IBoxFilter;
import net.sf.vex.widget.VexWidgetImpl;
import org.xml.sax.SAXException;

public class VexComponent
extends JComponent
implements Scrollable,
SelectionProvider {
    private VexWidgetImpl impl;
    private ActionMap staticActionMap = this.createActionMap();
    private static InputMap staticInputMap = VexComponent.createInputMap();
    private Timer caretTimer;
    private int originX = 0;
    private int originY = 0;
    private Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
    private SelectionProviderImpl selectionProvider = new SelectionProviderImpl();
    private static ResourceBundle uiStringBundle;
    private static VexComponent lastFocusedComponent;
    private ActionListener caretTimerListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            VexComponent.this.impl.toggleCaret();
        }
    };
    private ComponentListener componentListener = new ComponentAdapter(){

        @Override
        public void componentResized(ComponentEvent e) {
            int width = VexComponent.this.getWidth();
            VexComponent.this.impl.setLayoutWidth(width);
        }
    };
    private FocusListener focusListener = new FocusListener(){

        @Override
        public void focusGained(FocusEvent e) {
            lastFocusedComponent = VexComponent.this;
            VexComponent.this.impl.setFocus(true);
            VexComponent.this.caretTimer.start();
        }

        @Override
        public void focusLost(FocusEvent e) {
            VexComponent.this.impl.setFocus(false);
            VexComponent.this.caretTimer.stop();
        }
    };
    private KeyListener keyListener = new KeyListener(){

        @Override
        public void keyPressed(KeyEvent e) {
            if (VexComponent.this.impl.getDocument() == null) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            if (e.getKeyCode() == 16) {
                return;
            }
            try {
                InputMap map = staticInputMap;
                KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(e);
                Object keyStrokeBinding = map.get(keyStroke);
                if (keyStrokeBinding != null) {
                    BaseAction action = (BaseAction)VexComponent.this.staticActionMap.get(map.get(keyStroke));
                    action.actionPerformed(new ActionEvent(VexComponent.this, 0, ""), VexComponent.this.impl);
                } else if (!Character.isISOControl(e.getKeyChar()) && !e.isControlDown()) {
                    if (VexComponent.this.impl.hasSelection()) {
                        VexComponent.this.impl.deleteSelection();
                    }
                    VexComponent.this.insertChar(e.getKeyChar());
                }
            }
            catch (DocumentValidationException documentValidationException) {
                Toolkit.getDefaultToolkit().beep();
            }
            catch (Exception ex) {
                Toolkit.getDefaultToolkit().beep();
                ex.printStackTrace();
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }
    };
    private MouseListener mouseListener = new MouseAdapter(){

        @Override
        public void mousePressed(MouseEvent e) {
            boolean isButton1;
            boolean bl = isButton1 = (e.getModifiers() & 0x10) > 0;
            if (VexComponent.this.impl.getRootBox() != null && isButton1) {
                if (VexComponent.this.hasFocus()) {
                    int offset = VexComponent.this.impl.viewToModel(e.getX() - VexComponent.this.originX, e.getY() - VexComponent.this.originY);
                    VexComponent.this.moveTo(offset);
                    if (e.getClickCount() == 2) {
                        VexComponent.this.selectWord();
                    }
                }
                VexComponent.this.requestFocus();
            }
        }
    };
    private MouseMotionListener mouseMotionListener = new MouseMotionAdapter(){

        @Override
        public void mouseDragged(MouseEvent e) {
            boolean isButton1;
            boolean bl = isButton1 = (e.getModifiers() & 0x10) > 0;
            if (VexComponent.this.impl.getRootBox() != null && isButton1) {
                int offset = VexComponent.this.viewToModel(e.getX(), e.getY());
                VexComponent.this.moveTo(offset, true);
                VexComponent.this.requestFocus();
            }
        }
    };
    private HostComponent hostComponent = new HostComponent(){
        private GraphicsEnvironment graphicsEnvironment = null;
        private BufferedImage dummyImage = null;

        @Override
        public net.sf.vex.core.Graphics createDefaultGraphics() {
            if (this.graphicsEnvironment == null) {
                this.graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
                GraphicsDevice gdev = this.graphicsEnvironment.getDefaultScreenDevice();
                GraphicsConfiguration gconf = gdev.getDefaultConfiguration();
                this.dummyImage = gconf.createCompatibleImage(1, 1);
            }
            Graphics2D g = this.graphicsEnvironment.createGraphics(this.dummyImage);
            return new AwtGraphics(g);
        }

        @Override
        public void fireSelectionChanged() {
            VexComponent.this.fireSelectionChanged();
        }

        @Override
        public void invokeLater(Runnable runnable) {
            SwingUtilities.invokeLater(runnable);
        }

        @Override
        public void repaint() {
            VexComponent.this.repaint();
        }

        @Override
        public void repaint(int x, int y, int width, int height) {
            VexComponent.this.repaint();
        }

        @Override
        public void scrollTo(int left, int top) {
            VexComponent.this.setOrigin(-left, -top);
        }

        @Override
        public void setPreferredSize(int width, int height) {
        }

        @Override
        public Rectangle getViewport() {
            return new Rectangle(0 - VexComponent.this.originX, 0 - VexComponent.this.originY, VexComponent.this.getWidth(), VexComponent.this.getHeight());
        }
    };

    @Override
    public void addSelectionListener(SelectionListener listener) {
        this.selectionProvider.addSelectionListener(listener);
    }

    public boolean canPaste() {
        return true;
    }

    public boolean canPasteText() {
        return true;
    }

    public void copySelection() {
        if (this.impl.hasSelection()) {
            VexSelection sel = new VexSelection(this.impl.getSelectedText(), this.impl.getSelectedFragment());
            this.clipboard.setContents(sel, sel);
        }
    }

    public void cutSelection() {
        this.copySelection();
        this.deleteSelection();
    }

    public void deleteSelection() {
        this.impl.deleteSelection();
    }

    public static VexComponent getLastFocusedComponent() {
        return lastFocusedComponent;
    }

    public static String getUIString(String name) {
        if (uiStringBundle == null) {
            uiStringBundle = ResourceBundle.getBundle("net.sf.vex.app.UIStrings");
        }
        try {
            return uiStringBundle.getString(name);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableBlockIncrement(java.awt.Rectangle visibleRect, int orientation, int direction) {
        return Math.max(visibleRect.height - 40, 40);
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    @Override
    public int getScrollableUnitIncrement(java.awt.Rectangle visibleRect, int orientation, int direction) {
        return 20;
    }

    public VexComponent() {
        ActionMap customActionMap = new ActionMap();
        customActionMap.setParent(this.staticActionMap);
        this.setActionMap(customActionMap);
        InputMap customInputMap = new InputMap();
        customInputMap.setParent(staticInputMap);
        this.setInputMap(0, customInputMap);
        this.addComponentListener(this.componentListener);
        this.addFocusListener(this.focusListener);
        this.addKeyListener(this.keyListener);
        this.addMouseListener(this.mouseListener);
        this.addMouseMotionListener(this.mouseMotionListener);
        this.setCursor(Cursor.getPredefinedCursor(2));
        this.caretTimer = new Timer(UIManager.getInt("TextPane.caretBlinkRate"), this.caretTimerListener);
        this.caretTimer.start();
        DisplayDevice.setCurrent(new AwtDisplayDevice());
        this.impl = new VexWidgetImpl(this.hostComponent);
    }

    public void insertElement(IVexElement element) throws DocumentValidationException {
        this.impl.insertElement(element);
    }

    public void morph(IVexElement element) throws DocumentValidationException {
        this.impl.morph(element);
    }

    @Override
    public void paint(Graphics g) {
        this.paintComponent(g);
    }

    @Override
    protected void paintComponent(Graphics g) {
        System.currentTimeMillis();
        if (this.impl.getDocument() == null) {
            return;
        }
        AwtGraphics awtg = new AwtGraphics((Graphics2D)g);
        awtg.setOrigin(0, this.originY);
        Color bgColor = this.impl.getBackgroundColor();
        if (bgColor == null) {
            bgColor = new Color(255, 255, 255);
        }
        ColorResource color = awtg.createColor(bgColor);
        ColorResource oldColor = awtg.setColor(color);
        java.awt.Rectangle r = g.getClipBounds();
        awtg.fillRect((int)r.getX() - this.originX, (int)r.getY() - this.originY, (int)r.getWidth(), (int)r.getHeight());
        awtg.setColor(oldColor);
        color.dispose();
        this.impl.paint(awtg, 0, 0);
        System.currentTimeMillis();
    }

    public void paste() throws DocumentValidationException {
        if (!this.canPaste()) {
            return;
        }
        try {
            Transferable tfbl = this.clipboard.getContents(null);
            DataFlavor flavor = VexSelection.VEX_DOCUMENT_FRAGMENT_FLAVOR;
            if (tfbl.isDataFlavorSupported(flavor)) {
                IVexDocumentFragment frag = (IVexDocumentFragment)tfbl.getTransferData(flavor);
                this.impl.insertFragment(frag);
            } else {
                this.pasteText();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (UnsupportedFlavorException ex) {
            ex.printStackTrace();
        }
    }

    public void pasteText() throws DocumentValidationException {
        try {
            Transferable tfbl = this.clipboard.getContents(null);
            DataFlavor plainText = new DataFlavor(String.class, "text/plain");
            if (tfbl.isDataFlavorSupported(plainText)) {
                String text = (String)tfbl.getTransferData(plainText);
                this.impl.insertText(text);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (UnsupportedFlavorException ex) {
            ex.printStackTrace();
        }
    }

    public void split() throws DocumentValidationException {
        this.impl.split();
    }

    public void undo() throws CannotUndoException {
        this.impl.undo();
    }

    public int viewToModel(int x, int y) {
        return this.impl.viewToModel(x, y);
    }

    public void deleteNextChar() throws DocumentValidationException {
        this.impl.deleteNextChar();
    }

    public void deletePreviousChar() throws DocumentValidationException {
        this.impl.deletePreviousChar();
    }

    public void doWork(Runnable runnable) {
        this.impl.doWork(runnable);
    }

    public void doWork(boolean savePosition, Runnable runnable) {
        this.impl.doWork(savePosition, runnable);
    }

    public void endWork(boolean success) {
        this.impl.endWork(success);
    }

    public Box findInnermostBox(IBoxFilter filter) {
        return this.impl.findInnermostBox(filter);
    }

    public BoxFactory getBoxFactory() {
        return this.impl.getBoxFactory();
    }

    public int getCaretOffset() {
        return this.impl.getCaretOffset();
    }

    public IVexElement getCurrentElement() {
        return this.impl.getCurrentElement();
    }

    public IVexDocument getDocument() {
        return this.impl.getDocument();
    }

    public int getLayoutWidth() {
        return this.impl.getLayoutWidth();
    }

    public int getSelectionEnd() {
        return this.impl.getSelectionEnd();
    }

    public int getSelectionStart() {
        return this.impl.getSelectionStart();
    }

    public IVexDocumentFragment getSelectedFragment() {
        return this.impl.getSelectedFragment();
    }

    public String getSelectedText() {
        return this.impl.getSelectedText();
    }

    public StyleSheet getStyleSheet() {
        return this.impl.getStyleSheet();
    }

    public int getUndoDepth() {
        return this.impl.getUndoDepth();
    }

    public String[] getValidInsertElements() {
        return this.impl.getValidInsertElements();
    }

    public String[] getValidMorphElements() {
        return this.impl.getValidMorphElements();
    }

    public boolean hasSelection() {
        return this.impl.hasSelection();
    }

    public void insertChar(char c) throws DocumentValidationException {
        this.impl.insertChar(c);
    }

    public void insertFragment(IVexDocumentFragment frag) throws DocumentValidationException {
        this.impl.insertFragment(frag);
    }

    public void insertText(String text) throws DocumentValidationException {
        this.impl.insertText(text);
    }

    public boolean isDebugging() {
        return this.impl.isDebugging();
    }

    public void moveBy(int distance) {
        this.impl.moveBy(distance);
    }

    public void moveBy(int distance, boolean select) {
        this.impl.moveBy(distance, select);
    }

    public void moveTo(int offset) {
        this.impl.moveTo(offset);
    }

    public void moveTo(int offset, boolean select) {
        this.impl.moveTo(offset, select);
    }

    public void moveToLineEnd(boolean select) {
        this.impl.moveToLineEnd(select);
    }

    public void moveToLineStart(boolean select) {
        this.impl.moveToLineStart(select);
    }

    public void moveToNextLine(boolean select) {
        this.impl.moveToNextLine(select);
    }

    public void moveToNextPage(boolean select) {
        this.impl.moveToNextPage(select);
    }

    public void moveToNextWord(boolean select) {
        this.impl.moveToNextWord(select);
    }

    public void moveToPreviousLine(boolean select) {
        this.impl.moveToPreviousLine(select);
    }

    public void moveToPreviousPage(boolean select) {
        this.impl.moveToPreviousPage(select);
    }

    public void moveToPreviousWord(boolean select) {
        this.impl.moveToPreviousWord(select);
    }

    public void redo() throws CannotRedoException {
        this.impl.redo();
    }

    public void removeAttribute(String attributeName) {
        this.impl.removeAttribute(attributeName);
    }

    public void savePosition(Runnable runnable) {
        this.impl.savePosition(runnable);
    }

    public void selectAll() {
        this.impl.selectAll();
    }

    public void selectWord() {
        this.impl.selectWord();
    }

    public void setAttribute(String attributeName, String value) {
        this.impl.setAttribute(attributeName, value);
    }

    public void setBoxFactory(BoxFactory boxFactory) {
        this.impl.setBoxFactory(boxFactory);
    }

    public void setDebugging(boolean debugging) {
        this.impl.setDebugging(debugging);
    }

    public void setDocument(IVexDocument doc, StyleSheet styleSheet) {
        this.impl.setDocument(doc, styleSheet);
    }

    public void setDocument(URL docUrl, URL ssURL) throws IOException, ParserConfigurationException, SAXException {
        this.impl.setDocument(docUrl, ssURL);
    }

    public void setLayoutWidth(int width) {
        this.impl.setLayoutWidth(width);
    }

    public void setStyleSheet(StyleSheet styleSheet) {
        this.impl.setStyleSheet(styleSheet);
    }

    public void setStyleSheet(URL ssUrl) throws IOException {
        this.impl.setStyleSheet(ssUrl);
    }

    @Override
    public void removeSelectionListener(SelectionListener listener) {
        this.selectionProvider.removeSelectionListener(listener);
    }

    public Action[] getInsertElementActions() {
        String[] names = this.getValidInsertElements();
        Action[] actions = new Action[names.length];
        int i = 0;
        while (i < names.length) {
            actions[i] = new InsertElementAction(names[i]);
            ++i;
        }
        return actions;
    }

    public Action[] getMorphElementActions() {
        String[] names = this.getValidMorphElements();
        Action[] actions = new Action[names.length];
        int i = 0;
        while (i < names.length) {
            actions[i] = new MorphAction(names[i]);
            ++i;
        }
        return actions;
    }

    public void showInsertElementPopup() {
        JPopupMenu popup = new JPopupMenu();
        Action[] actions = this.getInsertElementActions();
        if (actions.length == 0) {
            return;
        }
        int i = 0;
        while (i < actions.length) {
            popup.add(actions[i]);
            ++i;
        }
        Rectangle caretBounds = this.impl.getCaret().getBounds();
        popup.show(this, caretBounds.getX() + 10, caretBounds.getY());
    }

    public void showMorphElementPopup() {
        JPopupMenu popup = new JPopupMenu();
        Action[] actions = this.getMorphElementActions();
        if (actions.length == 0) {
            return;
        }
        int i = 0;
        while (i < actions.length) {
            popup.add(actions[i]);
            ++i;
        }
        Rectangle caretBounds = this.impl.getCaret().getBounds();
        popup.show(this, caretBounds.getX() + 10, caretBounds.getY());
    }

    @Override
    public int getHeight() {
        return this.impl.getHeight();
    }

    public void scrollBy(int x, int y) {
        this.setOrigin(this.originX - x, this.originY - y);
    }

    public void scrollTo(int x, int y) {
        this.setOrigin(-x, -y);
    }

    private void setOrigin(int x, int y) {
        this.originX = x;
        this.originY = y;
    }

    private ActionMap createActionMap() {
        ActionMap am = new ActionMap();
        am.put("copy-selection", new BaseAction(){

            @Override
            public void actionPerformed(ActionEvent e, VexWidgetImpl c) throws DocumentValidationException {
                VexComponent.this.copySelection();
            }
        });
        am.put("cut-selection", new BaseAction(){

            @Override
            public void actionPerformed(ActionEvent e, VexWidgetImpl c) throws DocumentValidationException {
                VexComponent.this.cutSelection();
            }
        });
        am.put("delete-next-char", new BaseAction(){

            @Override
            public void actionPerformed(ActionEvent e, VexWidgetImpl c) throws DocumentValidationException {
                c.deleteNextChar();
            }
        });
        am.put("delete-previous-char", new BaseAction(){

            @Override
            public void actionPerformed(ActionEvent e, VexWidgetImpl c) throws DocumentValidationException {
                c.deletePreviousChar();
            }
        });
        am.put("move-to-document-end", new BaseAction(){

            @Override
            public void actionPerformed(ActionEvent e, VexWidgetImpl c) throws DocumentValidationException {
                c.moveTo(c.getDocument().getLength() - 1, false);
            }
        });
        am.put("move-to-document-start", new BaseAction(){

            @Override
            public void actionPerformed(ActionEvent e, VexWidgetImpl c) throws DocumentValidationException {
                c.moveTo(1, false);
            }
        });
        am.put("move-to-line-end", new BaseAction(){

            @Override
            public void actionPerformed(ActionEvent e, VexWidgetImpl c) throws DocumentValidationException {
                c.moveToLineEnd(false);
            }
        });
        am.put("move-to-line-start", new BaseAction(){

            @Override
            public void actionPerformed(ActionEvent e, VexWidgetImpl c) throws DocumentValidationException {
                c.moveToLineStart(false);
            }
        });
        am.put("move-to-next-char", new BaseAction(){

            @Override
            public void actionPerformed(ActionEvent e, VexWidgetImpl c) throws DocumentValidationException {
                int offset = c.getCaretOffset();
                if (offset < c.getDocument().getLength() - 1) {
                    c.moveTo(offset + 1, false);
                }
            }
        });
        am.put("move-to-next-line", new BaseAction(){

            @Override
            public void actionPerformed(ActionEvent e, VexWidgetImpl c) throws DocumentValidationException {
                c.moveToNextLine(false);
            }
        });
        am.put("move-to-next-word", new BaseAction(){

            @Override
            public void actionPerformed(ActionEvent e, VexWidgetImpl c) throws DocumentValidationException {
                c.moveToNextWord(false);
            }
        });
        am.put("move-to-previous-char", new BaseAction(){

            @Override
            public void actionPerformed(ActionEvent e, VexWidgetImpl c) throws DocumentValidationException {
                int offset = c.getCaretOffset();
                if (offset > 1) {
                    c.moveTo(offset - 1, false);
                }
            }
        });
        am.put("move-to-previous-line", new BaseAction(){

            @Override
            public void actionPerformed(ActionEvent e, VexWidgetImpl c) throws DocumentValidationException {
                c.moveToPreviousLine(false);
            }
        });
        am.put("move-to-previous-word", new BaseAction(){

            @Override
            public void actionPerformed(ActionEvent e, VexWidgetImpl c) throws DocumentValidationException {
                c.moveToPreviousWord(false);
            }
        });
        am.put("paste", new BaseAction(){

            @Override
            public void actionPerformed(ActionEvent e, VexWidgetImpl c) throws DocumentValidationException {
                VexComponent.this.paste();
            }
        });
        am.put("paste-text", new BaseAction(){

            @Override
            public void actionPerformed(ActionEvent e, VexWidgetImpl c) throws DocumentValidationException {
                VexComponent.this.pasteText();
            }
        });
        am.put("redo", new BaseAction(){

            @Override
            public void actionPerformed(ActionEvent e, VexWidgetImpl c) throws DocumentValidationException {
                c.redo();
            }
        });
        am.put("select-to-document-end", new BaseAction(){

            @Override
            public void actionPerformed(ActionEvent e, VexWidgetImpl c) throws DocumentValidationException {
                c.moveTo(c.getDocument().getLength() - 1, true);
            }
        });
        am.put("select-to-document-start", new BaseAction(){

            @Override
            public void actionPerformed(ActionEvent e, VexWidgetImpl c) throws DocumentValidationException {
                c.moveTo(1, true);
            }
        });
        am.put("select-to-line-end", new BaseAction(){

            @Override
            public void actionPerformed(ActionEvent e, VexWidgetImpl c) throws DocumentValidationException {
                c.moveToLineEnd(true);
            }
        });
        am.put("select-to-line-start", new BaseAction(){

            @Override
            public void actionPerformed(ActionEvent e, VexWidgetImpl c) throws DocumentValidationException {
                c.moveToLineStart(true);
            }
        });
        am.put("select-to-next-char", new BaseAction(){

            @Override
            public void actionPerformed(ActionEvent e, VexWidgetImpl c) throws DocumentValidationException {
                int offset = c.getCaretOffset();
                if (offset < c.getDocument().getLength() - 1) {
                    c.moveTo(offset + 1, true);
                }
            }
        });
        am.put("select-to-next-line", new BaseAction(){

            @Override
            public void actionPerformed(ActionEvent e, VexWidgetImpl c) throws DocumentValidationException {
                c.moveToNextLine(true);
            }
        });
        am.put("select-to-next-word", new BaseAction(){

            @Override
            public void actionPerformed(ActionEvent e, VexWidgetImpl c) throws DocumentValidationException {
                c.moveToNextWord(true);
            }
        });
        am.put("select-to-previous-char", new BaseAction(){

            @Override
            public void actionPerformed(ActionEvent e, VexWidgetImpl c) throws DocumentValidationException {
                int offset = c.getCaretOffset();
                if (offset > 1) {
                    c.moveTo(offset - 1, true);
                }
            }
        });
        am.put("select-to-previous-line", new BaseAction(){

            @Override
            public void actionPerformed(ActionEvent e, VexWidgetImpl c) throws DocumentValidationException {
                c.moveToPreviousLine(true);
            }
        });
        am.put("select-to-previous-word", new BaseAction(){

            @Override
            public void actionPerformed(ActionEvent e, VexWidgetImpl c) throws DocumentValidationException {
                c.moveToPreviousWord(true);
            }
        });
        am.put("move-to-previous-page", new BaseAction(){

            @Override
            public void actionPerformed(ActionEvent e, VexWidgetImpl c) throws DocumentValidationException {
                c.moveToPreviousPage(false);
            }
        });
        am.put("select-to-previous-page", new BaseAction(){

            @Override
            public void actionPerformed(ActionEvent e, VexWidgetImpl c) throws DocumentValidationException {
                c.moveToPreviousPage(true);
            }
        });
        am.put("move-to-next-page", new BaseAction(){

            @Override
            public void actionPerformed(ActionEvent e, VexWidgetImpl c) throws DocumentValidationException {
                c.moveToNextPage(false);
            }
        });
        am.put("select-to-next-page", new BaseAction(){

            @Override
            public void actionPerformed(ActionEvent e, VexWidgetImpl c) throws DocumentValidationException {
                c.moveToNextPage(true);
            }
        });
        am.put("show-insert-element-popup", new BaseAction(){

            @Override
            public void actionPerformed(ActionEvent e, VexWidgetImpl c) throws DocumentValidationException {
                VexComponent.this.showInsertElementPopup();
            }
        });
        am.put("show-morph-element-popup", new BaseAction(){

            @Override
            public void actionPerformed(ActionEvent e, VexWidgetImpl c) throws DocumentValidationException {
                VexComponent.this.showMorphElementPopup();
            }
        });
        am.put("split", new BaseAction(){

            @Override
            public void actionPerformed(ActionEvent e, VexWidgetImpl c) throws DocumentValidationException {
                c.split();
            }
        });
        am.put("undo", new BaseAction(){

            @Override
            public void actionPerformed(ActionEvent e, VexWidgetImpl c) throws DocumentValidationException {
                c.undo();
            }
        });
        return am;
    }

    public static InputMap createInputMap() {
        InputMap im = new InputMap();
        im.put(KeyStroke.getKeyStroke("LEFT"), "move-to-previous-char");
        im.put(KeyStroke.getKeyStroke("RIGHT"), "move-to-next-char");
        im.put(KeyStroke.getKeyStroke("shift LEFT"), "select-to-previous-char");
        im.put(KeyStroke.getKeyStroke("shift RIGHT"), "select-to-next-char");
        im.put(KeyStroke.getKeyStroke("control LEFT"), "move-to-previous-word");
        im.put(KeyStroke.getKeyStroke("control RIGHT"), "move-to-next-word");
        im.put(KeyStroke.getKeyStroke("shift control LEFT"), "select-to-previous-word");
        im.put(KeyStroke.getKeyStroke("shift control RIGHT"), "select-to-next-word");
        im.put(KeyStroke.getKeyStroke("HOME"), "move-to-line-start");
        im.put(KeyStroke.getKeyStroke("END"), "move-to-line-end");
        im.put(KeyStroke.getKeyStroke("shift HOME"), "select-to-line-start");
        im.put(KeyStroke.getKeyStroke("shift END"), "select-to-line-end");
        im.put(KeyStroke.getKeyStroke("PAGE_UP"), "move-to-previous-page");
        im.put(KeyStroke.getKeyStroke("PAGE_DOWN"), "move-to-next-page");
        im.put(KeyStroke.getKeyStroke("shift PAGE_UP"), "select-to-previous-page");
        im.put(KeyStroke.getKeyStroke("shift PAGE_DOWN"), "select-to-next-page");
        im.put(KeyStroke.getKeyStroke("control HOME"), "move-to-document-start");
        im.put(KeyStroke.getKeyStroke("control END"), "move-to-document-end");
        im.put(KeyStroke.getKeyStroke("shift control HOME"), "select-to-document-start");
        im.put(KeyStroke.getKeyStroke("shift control END"), "select-to-document-end");
        im.put(KeyStroke.getKeyStroke("UP"), "move-to-previous-line");
        im.put(KeyStroke.getKeyStroke("DOWN"), "move-to-next-line");
        im.put(KeyStroke.getKeyStroke("shift UP"), "select-to-previous-line");
        im.put(KeyStroke.getKeyStroke("shift DOWN"), "select-to-next-line");
        im.put(KeyStroke.getKeyStroke("BACK_SPACE"), "delete-previous-char");
        im.put(KeyStroke.getKeyStroke("DELETE"), "delete-next-char");
        im.put(KeyStroke.getKeyStroke("ENTER"), "split");
        im.put(KeyStroke.getKeyStroke("control C"), "copy-selection");
        im.put(KeyStroke.getKeyStroke("control X"), "cut-selection");
        im.put(KeyStroke.getKeyStroke("control V"), "paste");
        im.put(KeyStroke.getKeyStroke("shift control V"), "paste-text");
        im.put(KeyStroke.getKeyStroke("control Y"), "redo");
        im.put(KeyStroke.getKeyStroke("control Z"), "undo");
        im.put(KeyStroke.getKeyStroke("control U"), "unwrap");
        im.put(KeyStroke.getKeyStroke("control SPACE"), "show-insert-element-popup");
        im.put(KeyStroke.getKeyStroke("control M"), "show-morph-element-popup");
        return im;
    }

    private void fireSelectionChanged() {
    }

    private static abstract class BaseAction
    extends AbstractAction {
        private BaseAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                if (e.getSource() instanceof VexWidgetImpl) {
                    this.actionPerformed(e, (VexWidgetImpl)e.getSource());
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                Toolkit.getDefaultToolkit().beep();
            }
        }

        public abstract void actionPerformed(ActionEvent var1, VexWidgetImpl var2) throws Exception;
    }

    private class InsertElementAction
    extends AbstractAction {
        private String name;

        public InsertElementAction(String name) {
            super(name);
            this.name = name;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                VexComponent.this.insertElement(new Element(this.name));
            }
            catch (DocumentValidationException documentValidationException) {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }

    private class MorphAction
    extends AbstractAction {
        private String name;

        public MorphAction(String name) {
            super(name);
            this.name = name;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                VexComponent.this.morph(new Element(this.name));
            }
            catch (DocumentValidationException documentValidationException) {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }
}

