/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.editor;

import net.sf.vex.action.ActionUtils;
import net.sf.vex.action.DeleteColumnAction;
import net.sf.vex.action.DeleteRowAction;
import net.sf.vex.action.IVexAction;
import net.sf.vex.action.InsertColumnAfterAction;
import net.sf.vex.action.InsertColumnBeforeAction;
import net.sf.vex.action.InsertRowAboveAction;
import net.sf.vex.action.InsertRowBelowAction;
import net.sf.vex.action.MoveColumnLeftAction;
import net.sf.vex.action.MoveColumnRightAction;
import net.sf.vex.action.MoveRowDownAction;
import net.sf.vex.action.MoveRowUpAction;
import net.sf.vex.action.linked.InsertElementAction;
import net.sf.vex.dom.DocumentValidationException;
import net.sf.vex.editor.IVexActionBarContributor;
import net.sf.vex.editor.Messages;
import net.sf.vex.editor.VexEditor;
import net.sf.vex.editor.VexEditorPage;
import net.sf.vex.editor.action.VexActionAdapter;
import net.sf.vex.editor.config.Style;
import net.sf.vex.swt.VexWidget;
import net.sf.vex.widget.IVexWidget;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.MultiPageEditorActionBarContributor;

public class VexPageActionBarContributor
extends MultiPageEditorActionBarContributor
implements IVexActionBarContributor {
    private IEditorPart activeEditor;
    private IAction globalCopyAction;
    private IAction globalCutAction;
    private IAction globalDeleteAction;
    private IAction globalPasteAction;
    private IAction globalRedoAction;
    private IAction globalUndoAction;
    private IAction copyAction = new CopyAction();
    private IAction cutAction = new CutAction();
    private IAction deleteAction = new DeleteAction();
    private IAction pasteAction = new PasteAction();
    private IAction redoAction = new RedoAction();
    private IAction selectAllAction = new SelectAllAction();
    private IAction undoAction = new UndoAction();
    private MenuManager contextMenuManager;
    private IMenuListener contextMenuListener = new IMenuListener(){

        public void menuAboutToShow(IMenuManager manager) {
            boolean showTableActions = false;
            VexWidget vexWidget = VexPageActionBarContributor.this.getVexWidget();
            if (vexWidget != null) {
                showTableActions = ActionUtils.getSelectedTableRows((IVexWidget)vexWidget).getRows() != null;
            }
            manager.add(VexPageActionBarContributor.this.globalUndoAction);
            manager.add(VexPageActionBarContributor.this.globalRedoAction);
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)new VexActionAdapter(VexPageActionBarContributor.this.getVexEditor(), (IVexAction)new InsertElementAction()));
            if (showTableActions) {
                manager.add((IContributionItem)new Separator());
                manager.add((IContributionItem)new RowMenuManager());
                manager.add((IContributionItem)new ColumnMenuManager());
            }
            manager.add((IContributionItem)new Separator());
            manager.add(VexPageActionBarContributor.this.globalCutAction);
            manager.add(VexPageActionBarContributor.this.globalCopyAction);
            manager.add(VexPageActionBarContributor.this.globalPasteAction);
            manager.add((IContributionItem)new Separator());
            manager.add(VexPageActionBarContributor.this.globalDeleteAction);
            manager.add((IContributionItem)new Separator());
            manager.add((IContributionItem)new StyleMenuManager());
            manager.add((IContributionItem)new GroupMarker("additions"));
        }
    };
    private ISelectionListener selectionListener = new ISelectionListener(){

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            VexPageActionBarContributor.this.enableActions();
        }
    };

    public void dispose() {
    }

    @Override
    public MenuManager getContextMenuManager() {
        return this.contextMenuManager;
    }

    @Override
    public VexEditor getVexEditor() {
        return this.activeEditor == null ? null : (VexEditor)((Object)this.activeEditor.getAdapter(VexEditor.class));
    }

    @Override
    public VexWidget getVexWidget() {
        if (this.activeEditor instanceof VexEditorPage) {
            return ((VexEditorPage)this.activeEditor).getVexWidget();
        }
        if (this.activeEditor != null) {
            return ((VexEditor)((Object)this.activeEditor.getAdapter(VexEditor.class))).getVexWidget();
        }
        return null;
    }

    public void init(IActionBars bars, IWorkbenchPage page) {
        super.init(bars, page);
        this.contextMenuManager = new MenuManager();
        this.contextMenuManager.setRemoveAllWhenShown(true);
        this.contextMenuManager.addMenuListener(this.contextMenuListener);
        page.addSelectionListener(this.selectionListener);
        this.globalCopyAction = ActionFactory.COPY.create(page.getWorkbenchWindow());
        this.globalCutAction = ActionFactory.CUT.create(page.getWorkbenchWindow());
        this.globalDeleteAction = ActionFactory.DELETE.create(page.getWorkbenchWindow());
        this.globalPasteAction = ActionFactory.PASTE.create(page.getWorkbenchWindow());
        this.globalRedoAction = ActionFactory.REDO.create(page.getWorkbenchWindow());
        this.globalUndoAction = ActionFactory.UNDO.create(page.getWorkbenchWindow());
    }

    public void setActivePage(IEditorPart activeEditor) {
        if (activeEditor instanceof VexEditorPage) {
            this.activeEditor = activeEditor;
            this.setGlobalActionHandlers();
            this.enableActions();
        }
    }

    public void setActiveEditor(IEditorPart activeEditor) {
        if (activeEditor instanceof VexEditorPage) {
            this.setActivePage(activeEditor);
        }
    }

    public void setViewerSpecificContributionsEnabled(boolean enabled) {
        this.setGlobalActionHandlers();
        this.enableActions();
    }

    private void setGlobalActionHandlers() {
        this.getActionBars().setGlobalActionHandler(ActionFactory.COPY.getId(), this.copyAction);
        this.getActionBars().setGlobalActionHandler(ActionFactory.CUT.getId(), this.cutAction);
        this.getActionBars().setGlobalActionHandler(ActionFactory.DELETE.getId(), this.deleteAction);
        this.getActionBars().setGlobalActionHandler(ActionFactory.PASTE.getId(), this.pasteAction);
        this.getActionBars().setGlobalActionHandler(ActionFactory.REDO.getId(), this.redoAction);
        this.getActionBars().setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), this.selectAllAction);
        this.getActionBars().setGlobalActionHandler(ActionFactory.UNDO.getId(), this.undoAction);
        this.getActionBars().updateActionBars();
    }

    private void enableActions() {
        VexWidget widget = this.getVexWidget();
        if (widget == null) {
            return;
        }
        this.copyAction.setEnabled(widget != null && widget.hasSelection());
        this.cutAction.setEnabled(widget != null && widget.hasSelection());
        this.deleteAction.setEnabled(widget != null && widget.hasSelection());
        this.redoAction.setEnabled(widget != null && widget.canRedo());
        this.undoAction.setEnabled(widget != null && widget.canUndo());
    }

    private class ColumnMenuManager
    extends MenuManager {
        public ColumnMenuManager() {
            super(Messages.getString("VexActionBarContributor.columnMenu.name"));
            this.add((IAction)new VexActionAdapter(VexPageActionBarContributor.this.getVexEditor(), (IVexAction)new InsertColumnBeforeAction()));
            this.add((IAction)new VexActionAdapter(VexPageActionBarContributor.this.getVexEditor(), (IVexAction)new InsertColumnAfterAction()));
            this.add((IAction)new VexActionAdapter(VexPageActionBarContributor.this.getVexEditor(), (IVexAction)new DeleteColumnAction()));
            this.add((IAction)new VexActionAdapter(VexPageActionBarContributor.this.getVexEditor(), (IVexAction)new MoveColumnLeftAction()));
            this.add((IAction)new VexActionAdapter(VexPageActionBarContributor.this.getVexEditor(), (IVexAction)new MoveColumnRightAction()));
        }
    }

    private class CopyAction
    extends Action {
        private CopyAction() {
        }

        public void run() {
            VexPageActionBarContributor.this.getVexWidget().copySelection();
        }
    }

    private class CutAction
    extends Action {
        private CutAction() {
        }

        public void run() {
            VexPageActionBarContributor.this.getVexWidget().cutSelection();
        }
    }

    private class DeleteAction
    extends Action {
        private DeleteAction() {
        }

        public void run() {
            VexPageActionBarContributor.this.getVexWidget().deleteSelection();
        }
    }

    private class PasteAction
    extends Action {
        private PasteAction() {
        }

        public void run() {
            try {
                VexPageActionBarContributor.this.getVexWidget().paste();
            }
            catch (DocumentValidationException e) {
                e.printStackTrace();
            }
        }
    }

    private class RedoAction
    extends Action {
        private RedoAction() {
        }

        public void run() {
            if (VexPageActionBarContributor.this.getVexWidget().canRedo()) {
                VexPageActionBarContributor.this.getVexWidget().redo();
            }
        }
    }

    private class RowMenuManager
    extends MenuManager {
        public RowMenuManager() {
            super(Messages.getString("VexActionBarContributor.rowMenu.name"));
            this.add((IAction)new VexActionAdapter(VexPageActionBarContributor.this.getVexEditor(), (IVexAction)new InsertRowAboveAction()));
            this.add((IAction)new VexActionAdapter(VexPageActionBarContributor.this.getVexEditor(), (IVexAction)new InsertRowBelowAction()));
            this.add((IAction)new VexActionAdapter(VexPageActionBarContributor.this.getVexEditor(), (IVexAction)new DeleteRowAction()));
            this.add((IAction)new VexActionAdapter(VexPageActionBarContributor.this.getVexEditor(), (IVexAction)new MoveRowUpAction()));
            this.add((IAction)new VexActionAdapter(VexPageActionBarContributor.this.getVexEditor(), (IVexAction)new MoveRowDownAction()));
        }
    }

    private class SelectAllAction
    extends Action {
        private SelectAllAction() {
        }

        public void run() {
            VexPageActionBarContributor.this.getVexWidget().selectAll();
        }
    }

    private class SetStyleAction
    extends Action {
        private Style style;

        public SetStyleAction(Style style) {
            super(style.getName(), 8);
            this.style = style;
        }

        public void run() {
            VexPageActionBarContributor.this.getVexEditor().setStyle(this.style);
        }
    }

    private class StyleMenuManager
    extends MenuManager {
        public StyleMenuManager() {
            super(Messages.getString("VexActionBarContributor.styleMenu.name"));
            Action noItemsAction = new Action(Messages.getString("VexActionBarContributor.noValidItems")){

                public void run() {
                }
            };
            noItemsAction.setEnabled(false);
            noItemsAction.setChecked(true);
            this.add((IAction)noItemsAction);
            this.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager manager) {
                    manager.removeAll();
                    String publicId = VexPageActionBarContributor.this.getVexWidget().getDocument().getPublicID();
                    Style[] styles = Style.getStylesForDoctype(publicId);
                    int i = 0;
                    while (i < styles.length) {
                        SetStyleAction action = new SetStyleAction(styles[i]);
                        if (styles[i] == VexPageActionBarContributor.this.getVexEditor().getStyle()) {
                            action.setChecked(true);
                        }
                        manager.add((IAction)action);
                        ++i;
                    }
                }
            });
        }
    }

    private class UndoAction
    extends Action {
        private UndoAction() {
        }

        public void run() {
            if (VexPageActionBarContributor.this.getVexWidget().canUndo()) {
                VexPageActionBarContributor.this.getVexWidget().undo();
            }
        }
    }
}

