/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.middleware.confclient;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import javax.xml.stream.XMLStreamException;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.codehaus.jettison.mapped.MappedXMLStreamReader;

public class ConfservClient {
    private static int DEFAULT_SB_VALUE = 1024;
    private String confServUrl;

    public ConfservClient(String confServUrl) {
        this.confServUrl = confServUrl;
    }

    public String getValue(String key) throws IOException, JSONException {
        URL url = new URL(this.confServUrl + "/getValueJ?key=" + key);
        InputStream in = url.openStream();
        String body = ConfservClient.readStringFromStream(in);
        JSONObject obj = new JSONObject(body);
        return obj.getString("value");
    }

    public HashMap<String, String> getAll() throws IOException, JSONException, XMLStreamException {
        int event;
        HashMap<String, String> confMap = new HashMap<String, String>();
        URL url = new URL(this.confServUrl + "/getAllJ");
        InputStream in = url.openStream();
        String body = ConfservClient.readStringFromStream(in);
        JSONObject obj = new JSONObject(body);
        MappedXMLStreamReader reader = new MappedXMLStreamReader(obj);
        do {
            if ((event = reader.next()) != 1 || !reader.getLocalName().equals("set")) continue;
            reader.next();
            String key = reader.getText();
            reader.next();
            reader.next();
            reader.next();
            String value = reader.getText();
            confMap.put(key, value);
        } while (event != 8);
        reader.close();
        return confMap;
    }

    private static String readStringFromStream(InputStream in) throws IOException {
        StringBuilder sb = new StringBuilder(DEFAULT_SB_VALUE);
        int i = in.read();
        while (i != -1) {
            sb.append((char)i);
            i = in.read();
        }
        in.close();
        return sb.toString();
    }
}

