/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.core.model;

import info.textgrid.lab.core.model.Activator;
import info.textgrid.lab.core.model.Messages;
import info.textgrid.lab.core.model.TextGridErrorHandler;
import info.textgrid.namespaces.middleware.tgcrud.services.tgcrudservice.TextGridFaultType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;

public class CrudServiceException
extends CoreException {
    private static final long serialVersionUID = 5608618934688718145L;

    public CrudServiceException(Throwable cause, URI uri) {
        super(CrudServiceException.compileStatus(cause, uri));
        Activator.logServiceCall(Messages.CrudServiceException_ServiceCallFailed, uri, cause, this.getStatus());
    }

    protected static IStatus compileStatus(Throwable cause, URI uri) {
        TextGridFaultType faultType = CrudServiceException.getFaultType(cause, TextGridFaultType.class);
        IStatus status = null;
        status = faultType != null ? TextGridErrorHandler.getInstance().handleError(cause, faultType, uri) : Activator.handleError(cause, Messages.CrudServiceException_ErrorDuringOperation, cause.getClass().getName(), uri, cause.getLocalizedMessage());
        return status;
    }

    public static <T> T getFaultType(Throwable cause, Class<T> faultTypeClass) {
        if (cause != null) {
            try {
                Method getFaultInfo = cause.getClass().getMethod("getFaultInfo", new Class[0]);
                Object faultInfo = getFaultInfo.invoke((Object)cause, new Object[0]);
                if (faultInfo != null && faultTypeClass.isAssignableFrom(faultInfo.getClass())) {
                    Object faultType = faultInfo;
                    return (T)faultType;
                }
            }
            catch (SecurityException e) {
                Activator.handleProblem(2, e, "Could not extract a fault type from {0} due to security restrictions: {1}", cause, e.getMessage());
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException e) {
                Activator.handleProblem(2, e, "Could not extract a fault type from {0} due to security restrictions: {1}", cause, e.getMessage());
            }
            catch (InvocationTargetException invocationTargetException) {}
        }
        return null;
    }
}

