/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.core.tgauthclient;

import info.textgrid.lab.conf.ConfPlugin;
import info.textgrid.lab.conf.OfflineException;
import info.textgrid.lab.conf.OnlineStatus;
import info.textgrid.lab.conf.client.ConfClient;
import info.textgrid.namespaces.middleware.tgauth.PortTgextra;
import info.textgrid.namespaces.middleware.tgauth.Tgextra;
import java.net.URL;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.transport.common.gzip.GZIPInInterceptor;
import org.apache.cxf.transport.common.gzip.GZIPOutInterceptor;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.preference.IPreferenceStore;

public class TgAuthClientUtilities {
    private static Tgextra service;

    protected static Tgextra getService() {
        if (service == null) {
            URL wsdlLocation = PortTgextra.class.getResource("/wsdl/tgextra.wsdl");
            Assert.isNotNull((Object)wsdlLocation, (String)"tgextra.wsdl not found -- this is probaby a bug");
            service = new Tgextra(wsdlLocation, new QName("http://textgrid.info/namespaces/middleware/tgauth", "tgextra"));
        }
        return service;
    }

    private static String getTGauthEPR() {
        try {
            return ConfClient.getInstance().getValue("tgauth");
        }
        catch (OfflineException e) {
            OnlineStatus.netAccessFailed((String)"Could not retrieve TG-Auth EPR from configuration server", (Throwable)e);
            return null;
        }
    }

    public static PortTgextra getTgAuthServiceStub() {
        PortTgextra stub = TgAuthClientUtilities.getService().getTgextra();
        BindingProvider bindingProvider = (BindingProvider)stub;
        Map requestContext = bindingProvider.getRequestContext();
        requestContext.put("javax.xml.ws.service.endpoint.address", TgAuthClientUtilities.getTGauthEPR());
        bindingProvider.getRequestContext().put("com.sun.xml.internal.ws.request.timeout", 60000);
        bindingProvider.getRequestContext().put("com.sun.xml.internal.ws.connect.timeout", 60000);
        bindingProvider.getRequestContext().put("com.sun.xml.ws.request.timeout", 60000);
        bindingProvider.getRequestContext().put("com.sun.xml.ws.connect.timeout", 60000);
        Client client = ClientProxy.getClient((Object)stub);
        IPreferenceStore preferenceStore = ConfPlugin.getDefault().getPreferenceStore();
        if (preferenceStore.getBoolean("compressedTransfer")) {
            client.getInInterceptors().add(new GZIPInInterceptor());
            client.getOutInterceptors().add(new GZIPOutInterceptor());
        }
        return stub;
    }
}

