/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.css;

import net.sf.vex.css.AbstractProperty;
import net.sf.vex.css.Styles;
import org.w3c.css.sac.LexicalUnit;

public class DisplayProperty
extends AbstractProperty {
    public DisplayProperty() {
        super("display");
    }

    @Override
    public Object calculate(LexicalUnit lu, Styles parentStyles, Styles styles) {
        if (DisplayProperty.isDisplay(lu)) {
            return lu.getStringValue();
        }
        if (DisplayProperty.isInherit(lu) && parentStyles != null) {
            return parentStyles.getDisplay();
        }
        return "inline";
    }

    private static boolean isDisplay(LexicalUnit lu) {
        if (lu == null) {
            return false;
        }
        if (lu.getLexicalUnitType() == 35) {
            String s = lu.getStringValue();
            return s.equalsIgnoreCase("block") || s.equalsIgnoreCase("inline") || s.equalsIgnoreCase("inline-block") || s.equalsIgnoreCase("inline-table") || s.equalsIgnoreCase("list-item") || s.equalsIgnoreCase("none") || s.equalsIgnoreCase("run-in") || s.equalsIgnoreCase("table") || s.equalsIgnoreCase("table-caption") || s.equalsIgnoreCase("table-cell") || s.equalsIgnoreCase("table-column") || s.equalsIgnoreCase("table-column-group") || s.equalsIgnoreCase("table-footer-group") || s.equalsIgnoreCase("table-header-group") || s.equalsIgnoreCase("table-row") || s.equalsIgnoreCase("table-row-group");
        }
        return false;
    }
}

