/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.css;

import net.sf.vex.css.AbstractProperty;
import net.sf.vex.css.Styles;
import org.w3c.css.sac.LexicalUnit;

public class FontStyleProperty
extends AbstractProperty {
    public FontStyleProperty() {
        super("font-style");
    }

    @Override
    public Object calculate(LexicalUnit lu, Styles parentStyles, Styles styles) {
        if (FontStyleProperty.isFontStyle(lu)) {
            return lu.getStringValue();
        }
        if (parentStyles != null) {
            return parentStyles.getFontStyle();
        }
        return "normal";
    }

    public static boolean isFontStyle(LexicalUnit lu) {
        if (lu == null) {
            return false;
        }
        if (lu.getLexicalUnitType() == 35) {
            String s = lu.getStringValue();
            return s.equalsIgnoreCase("normal") || s.equalsIgnoreCase("italic") || s.equalsIgnoreCase("oblique");
        }
        return false;
    }
}

