/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.dom.linked;

import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.Queue;
import net.sf.vex.dom.Content;
import net.sf.vex.dom.DocumentReader;
import net.sf.vex.dom.IVexElement;
import net.sf.vex.dom.IVexNode;
import net.sf.vex.dom.IVexText;
import net.sf.vex.dom.IWhitespacePolicy;
import net.sf.vex.dom.IWhitespacePolicyFactory;
import net.sf.vex.dom.impl.SwingGapContentWrapper;
import net.sf.vex.dom.linked.LinkedCDATASection;
import net.sf.vex.dom.linked.LinkedComment;
import net.sf.vex.dom.linked.LinkedDocument;
import net.sf.vex.dom.linked.LinkedElement;
import net.sf.vex.dom.linked.LinkedModelException;
import net.sf.vex.dom.linked.LinkedText;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class LinkedDocumentReader
extends DocumentReader {
    private LinkedDocument doc;
    private IDOMDocument document;
    private Content content = new SwingGapContentWrapper(100);
    private IWhitespacePolicy whitespacePolicy;
    private SubMonitor progress = null;
    private int lastProgress = 0;
    protected Queue<SetContentCache> cache = new LinkedList<SetContentCache>();

    protected void reportProgress(Node node) throws ReadCanceledException {
        if (this.progress != null) {
            if (this.progress.isCanceled()) {
                throw new ReadCanceledException(node);
            }
            if (node instanceof IndexedRegion) {
                int startOffset = ((IndexedRegion)node).getStartOffset();
                this.progress.worked(startOffset - this.lastProgress);
                this.lastProgress = startOffset;
            }
        }
    }

    private void reportProgress(int worked) throws ReadCanceledException {
        if (this.progress != null) {
            if (this.progress.isCanceled()) {
                throw new ReadCanceledException();
            }
            this.progress.worked(worked);
        }
    }

    public LinkedDocument read(IDOMModel domModel, IProgressMonitor monitor) throws ReadCanceledException {
        this.progress = SubMonitor.convert((IProgressMonitor)monitor);
        LinkedDocument readDocument = this.read(domModel);
        this.progress.done();
        this.progress = null;
        return readDocument;
    }

    public LinkedDocument read(IDOMModel domModel) {
        this.document = domModel.getDocument();
        if (this.progress != null) {
            this.progress.setWorkRemaining(this.document.getLength() + 100);
        }
        if (this.document.getDocumentElement() == null) {
            Element newRoot = this.document.createElement("TEI");
            this.document.appendChild((Node)newRoot);
        }
        this.reportProgress(25);
        this.doc = new LinkedDocument(this.document);
        this.doc.setPublicID(this.document.getDocumentTypeId());
        this.whitespacePolicy = this.getWhitespacePolicyFactory().getPolicy(this.doc.getPublicID());
        this.doc.setWhitespacePolicy(this.whitespacePolicy);
        this.reportProgress(25);
        this.appendContent("\u0000");
        this.addChildren(this.doc.getRootElement(), this.document.getDocumentElement().getChildNodes());
        this.reportProgress(10);
        this.scheduleSetContent(this.doc.getRootElement(), this.content, 1, this.appendContent("\u0000"));
        this.doc.setContent(this.content);
        this.reportProgress(10);
        if (this.document.getSource().indexOf("stylesheet type=\"text/css\"") != -1) {
            int beg_css = this.document.getSource().indexOf("stylesheet type=\"text/css\"");
            int st_css = this.document.getSource().indexOf("href=\"", beg_css);
            int end_css = this.document.getSource().indexOf("\"", st_css + 6);
            String cssfile_location = this.document.getSource().substring(st_css + 6, end_css);
            this.doc.setCSSfileLocation(cssfile_location);
        }
        this.reportProgress(15);
        this.flushSetContent();
        this.reportProgress(20);
        return this.doc;
    }

    protected void scheduleSetContent(IVexNode node, Content content, int start, int end) {
        this.cache.add(new SetContentCache(node, content, start, end));
    }

    private void flushSetContent() {
        SetContentCache sc = this.cache.poll();
        while (sc != null) {
            sc.node.setContent(sc.content, sc.start, sc.end);
            sc = this.cache.poll();
        }
    }

    protected void addChildren(IVexNode parent, NodeList children) {
        int i = 0;
        while (i < children.getLength()) {
            this.add(parent, children.item(i));
            ++i;
        }
    }

    protected IVexNode add(IVexNode parent, Node item) {
        this.reportProgress(item);
        if (item instanceof Element) {
            return this.addElement(parent, (Element)item);
        }
        if (item instanceof Attr) {
            this.addAttr(parent, (Attr)item);
        } else {
            if (item instanceof Comment) {
                return this.addComment(parent, (Comment)item);
            }
            if (item instanceof CDATASection) {
                return this.addCDATASection(parent, (CDATASection)item);
            }
            if (item instanceof Text) {
                return this.addText(parent, (Text)item);
            }
            LinkedModelException.handleError("Adding a node is too abstract for me.\nPlease write an add method for {0}s, thanks.\n(Offending node: {1}, Parent: {2})", null, item.getClass(), item, parent);
            this.addChildren(parent, item.getChildNodes());
        }
        return null;
    }

    protected IVexElement addElement(IVexNode parent, Element element) {
        LinkedElement linkedElement = new LinkedElement(parent, element);
        ((IVexElement)parent).addChild(linkedElement);
        int start = this.appendContent("\u0000") - 1;
        this.addChildren(linkedElement, element.getChildNodes());
        int end = this.appendContent("\u0000") - 1;
        this.scheduleSetContent(linkedElement, this.content, start, end);
        return linkedElement;
    }

    private int appendContent(String string) {
        this.content.insertString(this.content.getLength(), string);
        int length = this.content.getLength();
        return length;
    }

    protected void addAttr(IVexNode parent, Attr attribute) {
        if (parent instanceof LinkedElement) {
            LinkedElement element = (LinkedElement)parent;
            element.setAttribute(attribute.getName(), attribute.getTextContent());
        }
    }

    protected IVexText addText(IVexNode parent, Text text) {
        LinkedText linkedText = new LinkedText(parent, text, this.content);
        int start = this.content.getLength();
        int end = this.appendContent(linkedText.getWSNormalizedString());
        this.scheduleSetContent(linkedText, this.content, start, end);
        ((LinkedElement)parent).addChild(linkedText);
        return linkedText;
    }

    protected LinkedComment addComment(IVexNode parent, Comment item) {
        LinkedComment linkedComment = new LinkedComment(item);
        ((LinkedElement)parent).addChild(linkedComment);
        int start = this.appendContent("\u0000") - 1;
        this.appendContent(item.getData());
        int end = this.appendContent("\u0000") - 1;
        this.scheduleSetContent(linkedComment, this.content, start, end);
        return linkedComment;
    }

    protected LinkedCDATASection addCDATASection(IVexNode parent, CDATASection item) {
        LinkedCDATASection linkedCS = new LinkedCDATASection(item);
        ((LinkedElement)parent).addChild(linkedCS);
        int start = this.appendContent("\u0000") - 1;
        this.appendContent(item.getData());
        int end = this.appendContent("\u0000") - 1;
        this.scheduleSetContent(linkedCS, this.content, start, end);
        return linkedCS;
    }

    public static LinkedDocument createVexDocument(IDocument document, IWhitespacePolicyFactory wsFactory) throws IllegalArgumentException {
        return LinkedDocumentReader.createVexDocument(document, wsFactory, null);
    }

    public static LinkedDocument createVexDocument(IDocument document, IWhitespacePolicyFactory wsFactory, IProgressMonitor monitor) throws IllegalArgumentException {
        IModelManager modelManager = StructuredModelManager.getModelManager();
        if (document instanceof IStructuredDocument) {
            IStructuredDocument sdocument = (IStructuredDocument)document;
            IStructuredModel modelForRead = modelManager.getModelForRead(sdocument);
            if (modelForRead instanceof IDOMModel) {
                LinkedDocument vexDocument;
                IDOMModel domModel = (IDOMModel)modelForRead;
                try {
                    LinkedDocumentReader reader = new LinkedDocumentReader();
                    reader.setWhitespacePolicyFactory(wsFactory);
                    vexDocument = reader.read(domModel, monitor);
                }
                finally {
                    domModel.releaseFromRead();
                }
                return vexDocument;
            }
            throw new IllegalArgumentException(MessageFormat.format("Cannot create linked document: Input document {0} must be associated with an IDOMModel (associated model: {1}", document, modelForRead));
        }
        throw new IllegalArgumentException(MessageFormat.format("Cannot create linked document: Input document {0} must be an IStructuredDocument.", document));
    }

    public class ReadCanceledException
    extends RuntimeException {
        private Node node;

        public ReadCanceledException(Node node) {
            super(MessageFormat.format("Read canceled while reading node {0}", node));
            this.node = node;
        }

        public ReadCanceledException() {
            super("Read canceled.");
        }

        public Node getNode() {
            return this.node;
        }
    }

    protected class SetContentCache {
        IVexNode node;
        Content content;
        int start;
        int end;

        protected SetContentCache(IVexNode node, Content content, int start, int end) {
            this.content = content;
            this.end = end;
            this.node = node;
            this.start = start;
        }
    }
}

