/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.dom.linked;

import com.google.common.collect.Iterators;
import info.textgrid.util.text.TextUtils;
import java.text.MessageFormat;
import java.util.Iterator;
import net.sf.vex.VexToolkitPlugin;
import net.sf.vex.dom.Content;
import net.sf.vex.dom.IVexNode;
import net.sf.vex.dom.impl.Node;
import net.sf.vex.dom.impl.WrongModelException;
import net.sf.vex.dom.linked.LinkedDocument;
import net.sf.vex.dom.linked.LinkedRootElement;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;

public abstract class LinkedNode
extends Node
implements IVexNode,
INodeAdapter,
IAdaptable,
Comparable<IVexNode> {
    private static final LinkedNode[] NO_CHILDREN = new LinkedNode[0];
    private org.w3c.dom.Node domNode;
    private LinkedNode parent;

    public LinkedNode(org.w3c.dom.Node domNode) {
        if (domNode == null) {
            throw new IllegalArgumentException("domNode must not be null");
        }
        this.setDomNode(domNode);
    }

    @Override
    public int compareTo(IVexNode o) {
        if (this.getStartPosition() != null && o.getStartPosition() != null) {
            return this.getStartOffset() - o.getStartOffset();
        }
        return 0;
    }

    public org.w3c.dom.Node getDomNode() {
        return this.domNode;
    }

    protected void setDomNode(org.w3c.dom.Node domNode) {
        this.domNode = domNode;
        if (domNode instanceof INodeNotifier) {
            ((INodeNotifier)domNode).addAdapter((INodeAdapter)this);
        }
    }

    public void setParent(IVexNode parent) {
        WrongModelException.throwIfNeeded(parent, LinkedNode.class);
        this.parent = (LinkedNode)parent;
    }

    public LinkedNode getParent() {
        return this.parent;
    }

    public String toString() {
        try {
            return MessageFormat.format("{0}({1}..{2}, {3}): {4}", this.getClass().getSimpleName(), this.getStartOffset(), this.getEndOffset(), TextUtils.visualizeControlChars((String)this.domNode.toString(), (boolean)false), TextUtils.visualizeControlChars((String)this.getContent().getString(this.getStartOffset(), this.getEndOffset() - this.getStartOffset()), (boolean)true));
        }
        catch (Exception e) {
            return MessageFormat.format("{0}({1}) !!! Exception during toString: {2}", this.getClass().getSimpleName(), this.getDomNode(), e);
        }
    }

    public boolean hasValidContent() {
        return true;
    }

    public boolean hasChildren() {
        return false;
    }

    public boolean isAdapterForType(Object type) {
        if (type instanceof Class) {
            Class clazz = (Class)type;
            return clazz.isInstance(this) || clazz.isInstance(this.getDomNode());
        }
        return false;
    }

    public void notifyChanged(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
        VexToolkitPlugin.log(1, null, "Unhandled change notification: " + this.formatNotification(notifier, eventType, changedFeature, oldValue, newValue, pos), new Object[0]);
        if (VexToolkitPlugin.isDebugging("net.sf.vex.toolkit/debug/syncevents")) {
            System.err.println(MessageFormat.format("ignored {1} in {0}", this, INodeNotifier.EVENT_TYPE_STRINGS[eventType]));
        }
    }

    protected String formatNotification(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
        return MessageFormat.format("notifyChanged({2}) on {0}\u00a0with: \n  changedFeature = {3},\n  oldValue = {4},\n  newValue = {5} (class {7}),\n  pos = {6}", this, notifier, INodeNotifier.EVENT_TYPE_STRINGS[eventType], changedFeature, oldValue, newValue, pos, newValue == null ? "null" : newValue.getClass().getSimpleName());
    }

    public LinkedDocument getDocument() {
        LinkedNode potentialRoot = this;
        while (!(potentialRoot instanceof LinkedRootElement)) {
            potentialRoot = potentialRoot.getParent();
        }
        if (potentialRoot == null) {
            return null;
        }
        return ((LinkedRootElement)potentialRoot).getDocument();
    }

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    @Override
    protected void setContent(Content content) {
        super.setContent(content);
    }

    protected Iterator<IVexNode> getChildNodeIterator() {
        return Iterators.emptyIterator();
    }

    protected IVexNode[] getChildNodes() {
        return NO_CHILDREN;
    }

    protected void dispose() {
        Iterator<IVexNode> iterator = this.getChildNodeIterator();
        while (iterator.hasNext()) {
            IVexNode child = iterator.next();
            if (child instanceof LinkedNode) {
                ((LinkedNode)child).dispose();
                continue;
            }
            VexToolkitPlugin.log(2, null, "Found a model inconsistency: child {0} of {1} is a {2} instead of a LinkedNode.", child, this, child.getClass());
        }
        if (this.domNode != null && this.domNode instanceof INodeNotifier) {
            ((INodeNotifier)this.domNode).removeAdapter((INodeAdapter)this);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        if (obj instanceof LinkedNode) {
            LinkedNode other = (LinkedNode)obj;
            if (this.getDomNode().equals(other.getDomNode()) && this.getStartOffset() == other.getStartOffset() && this.getEndOffset() == other.getEndOffset()) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int result = this.getClass().hashCode() ^ this.getDomNode().hashCode();
        if (this.getStartPosition() != null && this.getEndPosition() != null) {
            result ^= this.getStartOffset() << 4 ^ this.getEndOffset();
        }
        return result;
    }
}

