/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IRegion;
import org.eclipse.swt.events.VerifyEvent;

public class DocumentCommand {
    public boolean doit = false;
    public int offset;
    public int length;
    public String text;
    public IDocumentListener owner;
    public int caretOffset;
    private final List fCommands = new ArrayList();
    public boolean shiftsCaret;

    protected DocumentCommand() {
    }

    void setEvent(VerifyEvent event, IRegion modelRange) {
        this.doit = true;
        this.text = event.text;
        this.offset = modelRange.getOffset();
        this.length = modelRange.getLength();
        this.owner = null;
        this.caretOffset = -1;
        this.shiftsCaret = true;
        this.fCommands.clear();
    }

    boolean fillEvent(VerifyEvent event, IRegion modelRange) {
        event.text = this.text;
        event.doit = this.offset == modelRange.getOffset() && this.length == modelRange.getLength() && this.doit && this.caretOffset == -1;
        return event.doit;
    }

    public void addCommand(int commandOffset, int commandLength, String commandText, IDocumentListener commandOwner) throws BadLocationException {
        Command command = new Command(commandOffset, commandLength, commandText, commandOwner);
        if (this.intersects(command)) {
            throw new BadLocationException();
        }
        int index = Collections.binarySearch(this.fCommands, command);
        if (index >= 0) {
            throw new BadLocationException();
        }
        int insertionIndex = -(index + 1);
        if (insertionIndex != this.fCommands.size() && this.intersects((Command)this.fCommands.get(insertionIndex), command)) {
            throw new BadLocationException();
        }
        if (insertionIndex != 0 && this.intersects((Command)this.fCommands.get(insertionIndex - 1), command)) {
            throw new BadLocationException();
        }
        this.fCommands.add(insertionIndex, command);
    }

    public Iterator getCommandIterator() {
        Command command = new Command(this.offset, this.length, this.text, this.owner);
        return new CommandIterator(this.fCommands, command, true);
    }

    public int getCommandCount() {
        return 1 + this.fCommands.size();
    }

    private boolean intersects(Command command0, Command command1) {
        if (command0.fOffset + command0.fLength <= command1.fOffset || command1.fOffset + command1.fLength <= command0.fOffset) {
            return 2 * command0.fOffset + command0.fLength - (2 * command1.fOffset + command1.fLength) == 0;
        }
        return true;
    }

    private boolean intersects(Command command) {
        if (this.offset + this.length <= command.fOffset || command.fOffset + command.fLength <= this.offset) {
            return 2 * this.offset + this.length - (2 * command.fOffset + command.fLength) == 0;
        }
        return true;
    }

    /*
     * Exception decompiling
     */
    void execute(IDocument document) throws BadLocationException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [4 : 220->224)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean updateCaret() {
        return this.shiftsCaret && this.caretOffset != -1;
    }

    private String getCategory() {
        return this.toString();
    }

    private static class Command
    implements Comparable {
        private final int fOffset;
        private final int fLength;
        private final String fText;
        private final IDocumentListener fOwner;

        public Command(int offset, int length, String text, IDocumentListener owner) {
            if (offset < 0 || length < 0) {
                throw new IllegalArgumentException();
            }
            this.fOffset = offset;
            this.fLength = length;
            this.fText = text;
            this.fOwner = owner;
        }

        public void execute(IDocument document) throws BadLocationException {
            if (this.fLength == 0 && this.fText == null) {
                return;
            }
            if (this.fOwner != null) {
                document.removeDocumentListener(this.fOwner);
            }
            document.replace(this.fOffset, this.fLength, this.fText);
            if (this.fOwner != null) {
                document.addDocumentListener(this.fOwner);
            }
        }

        public int compareTo(Object object) {
            int value;
            if (this.isEqual(object)) {
                return 0;
            }
            Command command = (Command)object;
            if ((this.fOffset + this.fLength <= command.fOffset || command.fOffset + command.fLength <= this.fOffset) && (value = 2 * this.fOffset + this.fLength - (2 * command.fOffset + command.fLength)) != 0) {
                return value;
            }
            return 42;
        }

        private boolean isEqual(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Command)) {
                return false;
            }
            Command command = (Command)object;
            return command.fOffset == this.fOffset && command.fLength == this.fLength;
        }
    }

    private static class CommandIterator
    implements Iterator {
        private final Iterator fIterator;
        private Command fCommand;
        private boolean fForward;

        public CommandIterator(List commands, Command command, boolean forward) {
            if (commands == null || command == null) {
                throw new IllegalArgumentException();
            }
            this.fIterator = forward ? commands.iterator() : new ReverseListIterator(commands.listIterator(commands.size()));
            this.fCommand = command;
            this.fForward = forward;
        }

        public boolean hasNext() {
            return this.fCommand != null || this.fIterator.hasNext();
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.fCommand == null) {
                return this.fIterator.next();
            }
            if (!this.fIterator.hasNext()) {
                Command tempCommand = this.fCommand;
                this.fCommand = null;
                return tempCommand;
            }
            Command command = (Command)this.fIterator.next();
            int compareValue = command.compareTo(this.fCommand);
            if (compareValue < 0 ^ !this.fForward) {
                return command;
            }
            if (compareValue > 0 ^ !this.fForward) {
                Command tempCommand = this.fCommand;
                this.fCommand = command;
                return tempCommand;
            }
            throw new IllegalArgumentException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class ReverseListIterator
    implements Iterator {
        private final ListIterator fListIterator;

        public ReverseListIterator(ListIterator listIterator) {
            if (listIterator == null) {
                throw new IllegalArgumentException();
            }
            this.fListIterator = listIterator;
        }

        public boolean hasNext() {
            return this.fListIterator.hasPrevious();
        }

        public Object next() {
            return this.fListIterator.previous();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

