/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.ui.core.handlers;

import info.textgrid.lab.core.model.CrudServiceException;
import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.core.swtutils.AdapterUtils;
import info.textgrid.lab.ui.core.Activator;
import info.textgrid.lab.ui.core.dialogs.OpenURIDialog;
import info.textgrid.lab.ui.core.handlers.GenericOpenHandler;
import info.textgrid.lab.ui.core.handlers.Messages;
import java.net.URI;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class OpenURIHandler
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        TextGridObject object;
        OpenURIDialog dialog = new OpenURIDialog(HandlerUtil.getActiveShell((ExecutionEvent)event));
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof ITextSelection) {
            dialog.setInput(((ITextSelection)selection).getText().trim());
        } else if (selection instanceof IStructuredSelection && (object = (TextGridObject)AdapterUtils.getAdapter((Object)((IStructuredSelection)selection).getFirstElement(), TextGridObject.class)) != null) {
            dialog.setInput(object.getURI().toString());
        }
        if (dialog.open() == 0) {
            URI uri = dialog.getURI();
            try {
                IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
                if (window == null) {
                    window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                }
                GenericOpenHandler.openObject(TextGridObject.getInstance((URI)uri, (boolean)false));
            }
            catch (CrudServiceException e) {
                Activator.handleError(e, Messages.OpenURIHandler_CouldNotOpenObject, uri);
            }
        }
        return null;
    }
}

