/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.utils.export.aggregations;

import com.google.common.base.Optional;
import info.textgrid.namespaces.metadata.core._2010.ObjectType;
import info.textgrid.utils.export.aggregations.Aggregation;
import info.textgrid.utils.export.aggregations.IAggregationEntry;
import info.textgrid.utils.export.aggregations.ITransformableAggregationEntry;
import java.net.URI;
import java.text.MessageFormat;

public class AggregationEntry
implements IAggregationEntry,
ITransformableAggregationEntry {
    private final ObjectType metadata;
    protected final Optional<Aggregation> parent;
    private Optional<String> transformedFormat = Optional.absent();

    protected AggregationEntry(ObjectType metadata) {
        this(metadata, null);
    }

    public AggregationEntry(ObjectType metadata, Aggregation parent) {
        this.metadata = metadata;
        this.parent = Optional.fromNullable((Object)parent);
        if (this.parent.isPresent()) {
            parent.add(this);
        }
    }

    public Optional<Aggregation> getParent() {
        return this.parent;
    }

    @Override
    public ObjectType getMetadata() {
        return this.metadata;
    }

    public String getFormat() {
        return this.getMetadata().getGeneric().getProvided().getFormat();
    }

    @Override
    public String getFinalFormat() {
        if (this.transformedFormat.isPresent()) {
            return (String)this.transformedFormat.get();
        }
        return this.getFormat();
    }

    @Override
    public void setTransformedFormat(String format) {
        this.transformedFormat = Optional.of((Object)format);
    }

    public String toString() {
        try {
            return MessageFormat.format("{0} ({1}, {2})", this.metadata.getGeneric().getGenerated().getTextgridUri().getValue(), this.metadata.getGeneric().getProvided().getTitle().get(0), this.metadata.getGeneric().getProvided().getFormat());
        }
        catch (NullPointerException e) {
            return "<AggregationEntry w/o complete metadata>";
        }
    }

    @Override
    public URI getTextGridURI() {
        return URI.create(this.getMetadata().getGeneric().getGenerated().getTextgridUri().getValue());
    }
}

