/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.utils.linkrewriter;

import com.google.common.collect.Lists;
import info.textgrid._import.ImportObject;
import info.textgrid.utils.linkrewriter.ImportMapping;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class AbstractReplacement {
    protected final String from;
    protected final String to;

    public AbstractReplacement(String from, String to) {
        this.from = from;
        this.to = to;
    }

    public abstract String apply(String var1);

    public static <T extends AbstractReplacement> List<T> create(Class<T> replacementType, ImportMapping mapping, boolean export) {
        Collection<? extends ImportObject> objects = mapping.getImportObjects();
        ArrayList result = Lists.newArrayListWithCapacity((int)objects.size());
        for (ImportObject importObject : objects) {
            result.add(AbstractReplacement.create(replacementType, importObject, export));
        }
        return result;
    }

    public static <T extends AbstractReplacement> T create(Class<T> replacementType, ImportObject object, boolean export) throws IllegalArgumentException, IllegalStateException {
        try {
            String to;
            String from;
            Constructor<T> constructor = replacementType.getConstructor(String.class, String.class);
            if (!export) {
                from = object.getLocalData();
                to = object.getTextgridUri();
            } else {
                from = object.getTextgridUri();
                to = object.getLocalData();
            }
            return (T)((AbstractReplacement)constructor.newInstance(from, to));
        }
        catch (SecurityException e) {
            throw new IllegalStateException(e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Replacements must offer a constructor with the argments (String from, String to)", e);
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    public static String apply(List<? extends AbstractReplacement> replacements, String s) {
        for (AbstractReplacement abstractReplacement : replacements) {
            s = abstractReplacement.apply(s);
        }
        return s;
    }
}

