/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.editor.config;

import java.util.ArrayList;
import java.util.List;
import net.sf.vex.dom.Validator;
import net.sf.vex.editor.VexEditor;
import net.sf.vex.editor.config.ConfigItem;
import net.sf.vex.editor.config.ConfigRegistry;
import net.sf.vex.editor.config.ConfigSource;

public class DocumentType
extends ConfigItem
implements Comparable {
    public static final String EXTENSION_POINT = "net.sf.vex.editor.doctypes";
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private String publicId;
    private String systemId;
    private String outlineProvider;
    private String[] rootElements = EMPTY_STRING_ARRAY;

    public DocumentType(ConfigSource config) {
        super(config);
    }

    public static DocumentType getDocumentType(String publicId) {
        ConfigRegistry registry = ConfigRegistry.getInstance();
        List doctypes = registry.getAllConfigItems(EXTENSION_POINT);
        for (DocumentType doctype : doctypes) {
            if (!doctype.getPublicId().equals(publicId)) continue;
            return doctype;
        }
        return null;
    }

    public static DocumentType[] getDocumentTypesWithStyles() {
        ConfigRegistry registry = ConfigRegistry.getInstance();
        ArrayList<DocumentType> withStyles = new ArrayList<DocumentType>();
        List doctypes = registry.getAllConfigItems(EXTENSION_POINT);
        for (DocumentType doctype : doctypes) {
            if (VexEditor.findStyleForDoctype(doctype.getPublicId()) == null) continue;
            withStyles.add(doctype);
        }
        return withStyles.toArray(new DocumentType[withStyles.size()]);
    }

    public String getOutlineProvider() {
        return this.outlineProvider;
    }

    public String getPublicId() {
        return this.publicId;
    }

    public String getSystemId() {
        return this.systemId;
    }

    @Override
    public String getExtensionPointId() {
        return EXTENSION_POINT;
    }

    public void setOutlineProvider(String contentOutlinePage) {
        this.outlineProvider = contentOutlinePage;
    }

    public void setPublicId(String publicId) {
        this.publicId = publicId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public Validator getValidator() {
        return (Validator)this.getConfig().getParsedResource(this.getResourcePath());
    }

    @Override
    public boolean isValid() {
        return super.isValid() && !this.isBlank(this.publicId) && !this.isBlank(this.systemId) && this.getValidator() != null;
    }

    public String toString() {
        return this.getName();
    }

    public String[] getRootElements() {
        return this.rootElements;
    }

    public void setRootElements(String[] rootElements) {
        if (rootElements == null) {
            throw new IllegalArgumentException();
        }
        this.rootElements = rootElements;
    }
}

