/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import java.io.Serializable;
import java.util.HashMap;
import net.sf.saxon.lib.NamespaceConstant;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.om.StandardNames;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.value.Whitespace;

public class NamePool
implements Serializable {
    public static final int FP_MASK = 1048575;
    public static final int USER_DEFINED_MASK = 1047552;
    public static final int MAX_PREFIXES_PER_URI = 1023;
    private NameEntry[] hashslots = new NameEntry[1024];
    private String[] uris = new String[100];
    private String[][] prefixesForUri = new String[100][0];
    short urisUsed = 0;
    private HashMap<Class, Object> clientData;

    public NamePool() {
        this.uris[0] = "";
        this.prefixesForUri[0] = new String[]{""};
        this.uris[1] = "http://www.w3.org/XML/1998/namespace";
        this.prefixesForUri[1] = new String[]{"xml"};
        this.uris[2] = "http://www.w3.org/1999/XSL/Transform";
        this.prefixesForUri[2] = new String[]{"xsl"};
        this.uris[3] = "http://saxon.sf.net/";
        this.prefixesForUri[3] = new String[]{"saxon"};
        this.uris[4] = "http://www.w3.org/2001/XMLSchema";
        this.prefixesForUri[4] = new String[]{"xs"};
        this.uris[5] = "http://www.w3.org/2001/XMLSchema-instance";
        this.prefixesForUri[5] = new String[]{"xsi"};
        this.urisUsed = (short)6;
    }

    private NameEntry getNameEntry(int nameCode) {
        int hash = nameCode & 0x3FF;
        int depth = nameCode >> 10 & 0x3FF;
        NameEntry entry = this.hashslots[hash];
        for (int i = 1; i < depth; ++i) {
            if (entry == null) {
                return null;
            }
            entry = entry.nextEntry;
        }
        return entry;
    }

    private static int search(String[] codes, String value) {
        for (int i = 0; i < codes.length; ++i) {
            if (!codes[i].equals(value)) continue;
            return i;
        }
        return -1;
    }

    public NamespaceBinding getNamespaceBinding(int namecode) {
        short uriCode;
        int fp = namecode & 0xFFFFF;
        if ((fp & 0xFFC00) == 0) {
            uriCode = StandardNames.getURICode(fp);
            if (uriCode == 1) {
                return NamespaceBinding.XML;
            }
        } else {
            NameEntry entry = this.getNameEntry(namecode);
            if (entry == null) {
                return null;
            }
            uriCode = entry.uriCode;
        }
        int prefixIndex = namecode >> 20 & 0x3FF;
        return new NamespaceBinding(this.getPrefixWithIndex(uriCode, prefixIndex), this.getURIFromURICode(uriCode));
    }

    public StructuredQName getStructuredQName(int namecode) {
        String localName;
        short uriCode;
        int fp = namecode & 0xFFFFF;
        if ((fp & 0xFFC00) == 0) {
            uriCode = StandardNames.getURICode(fp);
            localName = StandardNames.getLocalName(fp);
        } else {
            NameEntry entry = this.getNameEntry(namecode);
            if (entry == null) {
                return null;
            }
            uriCode = entry.uriCode;
            localName = entry.localName;
        }
        int prefixIndex = namecode >> 20 & 0x3FF;
        return new StructuredQName(this.getPrefixWithIndex(uriCode, prefixIndex), this.getURIFromURICode(uriCode), localName);
    }

    public static boolean isPrefixed(int nameCode) {
        return (nameCode & 0x3FF00000) != 0;
    }

    public synchronized short allocateCodeForURI(String uri) {
        return this.allocateCodeForURIInternal(uri);
    }

    private short allocateCodeForURIInternal(String uri) {
        if (uri == null) {
            return 0;
        }
        for (short j = 0; j < this.urisUsed; j = (short)(j + 1)) {
            if (!this.uris[j].equals(uri)) continue;
            return j;
        }
        if (this.urisUsed >= this.uris.length) {
            if (this.urisUsed > 32000) {
                throw new NamePoolLimitException("Too many namespace URIs");
            }
            String[][] p = new String[this.urisUsed * 2][0];
            String[] u = new String[this.urisUsed * 2];
            System.arraycopy(this.prefixesForUri, 0, p, 0, this.urisUsed);
            System.arraycopy(this.uris, 0, u, 0, this.urisUsed);
            this.prefixesForUri = p;
            this.uris = u;
        }
        this.uris[this.urisUsed] = uri;
        short s = this.urisUsed;
        this.urisUsed = (short)(s + 1);
        return s;
    }

    public short getCodeForURI(String uri) {
        for (short j = 0; j < this.urisUsed; j = (short)(j + 1)) {
            if (!this.uris[j].equals(uri)) continue;
            return j;
        }
        return -1;
    }

    public String suggestPrefixForURI(String URI2) {
        if (URI2.equals("http://www.w3.org/XML/1998/namespace")) {
            return "xml";
        }
        short uriCode = this.getCodeForURI(URI2);
        if (uriCode == -1) {
            return null;
        }
        if (this.prefixesForUri[uriCode].length >= 1) {
            return this.prefixesForUri[uriCode][0];
        }
        return null;
    }

    private String getPrefixWithIndex(short uriCode, int index) {
        if (index == 0) {
            return "";
        }
        return this.prefixesForUri[uriCode][index - 1];
    }

    public synchronized int allocate(String prefix, String uri, String localName) {
        int prefixIndex;
        int fp;
        if ((NamespaceConstant.isReserved(uri) || "http://saxon.sf.net/".equals(uri)) && (fp = StandardNames.getFingerprint(uri, localName)) != -1) {
            int pindex;
            short uriCode = StandardNames.getURICode(fp);
            if (prefix.length() == 0) {
                pindex = 0;
            } else {
                String[] prefixes = this.prefixesForUri[uriCode];
                int prefixPosition = NamePool.search(prefixes, prefix);
                if (prefixPosition < 0) {
                    if (prefixes.length == 1023) {
                        throw new NamePoolLimitException("NamePool limit exceeded: max 1023 prefixes per URI");
                    }
                    String[] p2 = new String[prefixes.length + 1];
                    System.arraycopy(prefixes, 0, p2, 0, prefixes.length);
                    p2[prefixes.length] = prefix;
                    this.prefixesForUri[uriCode] = p2;
                    prefixPosition = prefixes.length;
                }
                pindex = prefixPosition + 1;
            }
            return (pindex << 20) + fp;
        }
        short uriCode = this.allocateCodeForURIInternal(uri);
        int hash = (localName.hashCode() & Integer.MAX_VALUE) % 1023;
        int depth = 1;
        String[] prefixes = this.prefixesForUri[uriCode];
        if (prefix.length() == 0) {
            prefixIndex = 0;
        } else {
            int prefixPosition = NamePool.search(prefixes, prefix);
            if (prefixPosition < 0) {
                if (prefixes.length == 1023) {
                    throw new NamePoolLimitException("NamePool limit exceeded: max 1023 prefixes per URI");
                }
                String[] p2 = new String[prefixes.length + 1];
                System.arraycopy(prefixes, 0, p2, 0, prefixes.length);
                p2[prefixes.length] = prefix;
                this.prefixesForUri[uriCode] = p2;
                prefixPosition = prefixes.length;
            }
            prefixIndex = prefixPosition + 1;
        }
        if (this.hashslots[hash] == null) {
            NameEntry entry;
            this.hashslots[hash] = entry = new NameEntry(uriCode, localName);
        } else {
            NameEntry entry = this.hashslots[hash];
            while (true) {
                boolean sameURI;
                boolean sameLocalName = entry.localName.equals(localName);
                boolean bl = sameURI = entry.uriCode == uriCode;
                if (sameLocalName && sameURI) break;
                NameEntry next = entry.nextEntry;
                if (++depth >= 1024) {
                    throw new NamePoolLimitException("Saxon name pool is full");
                }
                if (next == null) {
                    entry.nextEntry = new NameEntry(uriCode, localName);
                    break;
                }
                entry = next;
            }
        }
        return (prefixIndex << 20) + (depth << 10) + hash;
    }

    public String getURI(int nameCode) {
        if ((nameCode & 0xFFC00) == 0) {
            return StandardNames.getURI(nameCode & 0xFFFFF);
        }
        NameEntry entry = this.getNameEntry(nameCode);
        if (entry == null) {
            NamePool.unknownNameCode(nameCode);
            return "";
        }
        return this.uris[entry.uriCode];
    }

    public short getURICode(int nameCode) {
        if ((nameCode & 0xFFC00) == 0) {
            return StandardNames.getURICode(nameCode & 0xFFFFF);
        }
        NameEntry entry = this.getNameEntry(nameCode);
        if (entry == null) {
            NamePool.unknownNameCode(nameCode);
            return -1;
        }
        return entry.uriCode;
    }

    public String getLocalName(int nameCode) {
        if ((nameCode & 0xFFC00) == 0) {
            return StandardNames.getLocalName(nameCode & 0xFFFFF);
        }
        NameEntry entry = this.getNameEntry(nameCode);
        if (entry == null) {
            NamePool.unknownNameCode(nameCode);
            return null;
        }
        return entry.localName;
    }

    public String getPrefix(int nameCode) {
        int prefixIndex = nameCode >> 20 & 0x3FF;
        if (prefixIndex == 0) {
            return "";
        }
        short uriCode = this.getURICode(nameCode);
        return this.prefixesForUri[uriCode][prefixIndex - 1];
    }

    public String getDisplayName(int nameCode) {
        if ((nameCode & 0xFFC00) == 0) {
            short uriCode = this.getURICode(nameCode);
            if (uriCode == 1) {
                return "xml:" + StandardNames.getLocalName(nameCode & 0xFFFFF);
            }
            if (NamePool.isPrefixed(nameCode)) {
                return this.getPrefix(nameCode) + ':' + StandardNames.getLocalName(nameCode & 0xFFFFF);
            }
            return StandardNames.getLocalName(nameCode & 0xFFFFF);
        }
        NameEntry entry = this.getNameEntry(nameCode);
        if (entry == null) {
            NamePool.unknownNameCode(nameCode);
            return null;
        }
        if (NamePool.isPrefixed(nameCode)) {
            return this.getPrefix(nameCode) + ':' + entry.localName;
        }
        return entry.localName;
    }

    public String getClarkName(int nameCode) {
        if ((nameCode & 0xFFC00) == 0) {
            return StandardNames.getClarkName(nameCode & 0xFFFFF);
        }
        NameEntry entry = this.getNameEntry(nameCode);
        if (entry == null) {
            NamePool.unknownNameCode(nameCode);
            return null;
        }
        if (entry.uriCode == 0) {
            return entry.localName;
        }
        String n = '{' + this.getURIFromURICode(entry.uriCode) + '}' + entry.localName;
        return n.intern();
    }

    public String getEQName(int nameCode) {
        if ((nameCode & 0xFFC00) == 0) {
            return StandardNames.getClarkName(nameCode & 0xFFFFF);
        }
        NameEntry entry = this.getNameEntry(nameCode);
        if (entry == null) {
            NamePool.unknownNameCode(nameCode);
            return null;
        }
        return '\'' + this.getURIFromURICode(entry.uriCode) + "':" + entry.localName;
    }

    public int allocateClarkName(String expandedName) {
        String localName;
        String namespace;
        if (expandedName.charAt(0) == '{') {
            int closeBrace = expandedName.indexOf(125);
            if (closeBrace < 0) {
                throw new IllegalArgumentException("No closing '}' in Clark name");
            }
            namespace = expandedName.substring(1, closeBrace);
            if (closeBrace == expandedName.length()) {
                throw new IllegalArgumentException("Missing local part in Clark name");
            }
            localName = expandedName.substring(closeBrace + 1);
        } else {
            namespace = "";
            localName = expandedName;
        }
        return this.allocate("", namespace, localName);
    }

    public static String[] parseClarkName(String expandedName) {
        String localName;
        String namespace;
        if (expandedName.charAt(0) == '{') {
            int closeBrace = expandedName.indexOf(125);
            if (closeBrace < 0) {
                throw new IllegalArgumentException("No closing '}' in Clark name");
            }
            namespace = expandedName.substring(1, closeBrace);
            if (closeBrace == expandedName.length()) {
                throw new IllegalArgumentException("Missing local part in Clark name");
            }
            localName = expandedName.substring(closeBrace + 1);
        } else {
            namespace = "";
            localName = expandedName;
        }
        return new String[]{namespace, localName};
    }

    private static void unknownNameCode(int nameCode) {
        throw new IllegalArgumentException("Unknown name code " + nameCode);
    }

    public int getFingerprint(String uri, String localName) {
        short uriCode;
        if (uri.length() == 0) {
            uriCode = 0;
        } else {
            int fp;
            if ((NamespaceConstant.isReserved(uri) || uri.equals("http://saxon.sf.net/")) && (fp = StandardNames.getFingerprint(uri, localName)) != -1) {
                return fp;
            }
            uriCode = -1;
            for (short j = 0; j < this.urisUsed; j = (short)(j + 1)) {
                if (!this.uris[j].equals(uri)) continue;
                uriCode = j;
                break;
            }
            if (uriCode == -1) {
                return -1;
            }
        }
        int hash = (localName.hashCode() & Integer.MAX_VALUE) % 1023;
        int depth = 1;
        if (this.hashslots[hash] == null) {
            return -1;
        }
        NameEntry entry = this.hashslots[hash];
        while (entry.uriCode != uriCode || !entry.localName.equals(localName)) {
            NameEntry next = entry.nextEntry;
            ++depth;
            if (next == null) {
                return -1;
            }
            entry = next;
        }
        return (depth << 10) + hash;
    }

    public String getURIFromURICode(short code) {
        return this.uris[code];
    }

    public int allocateLexicalQName(CharSequence qname, boolean useDefault, NamespaceResolver resolver, NameChecker checker) throws XPathException {
        try {
            String[] parts = checker.getQNameParts(Whitespace.trimWhitespace(qname));
            String uri = resolver.getURIForPrefix(parts[0], useDefault);
            if (uri == null) {
                throw new XPathException("Namespace prefix '" + parts[0] + "' has not been declared");
            }
            return this.allocate(parts[0], uri, parts[1]);
        }
        catch (QNameException e) {
            throw new XPathException(e.getMessage());
        }
    }

    public void setClientData(Class key, Object value) {
        if (this.clientData == null) {
            this.clientData = new HashMap(10);
        }
        this.clientData.put(key, value);
    }

    public Object getClientData(Class key) {
        if (this.clientData == null) {
            return null;
        }
        return this.clientData.get(key);
    }

    public synchronized void diagnosticDump() {
        System.err.println("Contents of NamePool " + this);
        for (int i = 0; i < 1024; ++i) {
            NameEntry entry = this.hashslots[i];
            int depth = 0;
            while (entry != null) {
                System.err.println("Fingerprint " + depth + '/' + i);
                System.err.println("  local name = " + entry.localName + " uri code = " + entry.uriCode);
                entry = entry.nextEntry;
                ++depth;
            }
        }
        for (int u = 0; u < this.urisUsed; ++u) {
            System.err.println("URI " + u + " = " + this.uris[u]);
            FastStringBuffer fsb = new FastStringBuffer(64);
            for (int p = 0; p < this.prefixesForUri[u].length; ++p) {
                fsb.append(this.prefixesForUri[u][p] + ", ");
            }
            System.err.println("Prefix codes for URI " + u + " = " + fsb.toString());
        }
    }

    public synchronized void statistics() {
        int slots = 0;
        int entries = 0;
        for (int i = 0; i < 1024; ++i) {
            NameEntry entry = this.hashslots[i];
            if (entry != null) {
                ++slots;
            }
            while (entry != null) {
                entry = entry.nextEntry;
                ++entries;
            }
        }
        System.err.println("NamePool contents: " + entries + " entries in " + slots + " chains. " + this.urisUsed + " URIs");
    }

    public static class NamePoolLimitException
    extends RuntimeException {
        public NamePoolLimitException(String message) {
            super(message);
        }
    }

    private static class NameEntry
    implements Serializable {
        String localName;
        short uriCode;
        NameEntry nextEntry;

        public NameEntry(short uriCode, String localName) {
            this.uriCode = uriCode;
            this.localName = localName.intern();
            this.nextEntry = null;
        }
    }
}

