/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.management.interceptor;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.LoggingMessage;
import org.apache.cxf.io.CacheAndWriteOutputStream;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.io.CachedOutputStreamCallback;
import org.apache.cxf.management.persistence.ExchangeData;
import org.apache.cxf.management.persistence.ExchangeDataDAO;
import org.apache.cxf.management.persistence.ExchangeDataFilter;
import org.apache.cxf.management.persistence.ExchangeDataProperty;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.OperationInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistOutInterceptor
extends AbstractPhaseInterceptor<Message> {
    public static final String CXF_CONSOLE_ADDITIONAL_PROPERTY_PREFIX = "org.apache.cxf.management.interceptor.prefix";
    private ExchangeDataDAO exchangeDataDAO;
    private ExchangeDataFilter exchangeDataFilter;

    public PersistOutInterceptor() {
        super("pre-stream");
    }

    private static void addProperty(ExchangeData exchange, String key, String value) {
        ExchangeDataProperty exchangeProperty = new ExchangeDataProperty();
        exchangeProperty.setExchangeData(exchange);
        exchangeProperty.setName(key);
        exchangeProperty.setValue(value);
        if (exchange.getProperties() == null) {
            exchange.setProperties(new ArrayList<ExchangeDataProperty>());
        }
        exchange.getProperties().add(exchangeProperty);
    }

    private void addPropertiesFrom(ExchangeData exchange, Message message) {
        for (Map.Entry entry : message.entrySet()) {
            if (((String)entry.getKey()).equals(Message.ENCODING)) {
                exchange.setEncoding((String)entry.getValue());
                continue;
            }
            if (((String)entry.getKey()).equals("org.apache.cxf.request.uri")) {
                exchange.setUri((String)entry.getValue());
                continue;
            }
            if (((String)entry.getKey()).equals(Message.PROTOCOL_HEADERS)) {
                List userAgents;
                if (entry.getValue() instanceof Map && (userAgents = (List)((Map)entry.getValue()).get("user-agent")) != null && !userAgents.isEmpty()) {
                    exchange.setUserAgent(userAgents.get(0).toString());
                }
                if (entry.getValue() == null) continue;
                PersistOutInterceptor.addProperty(exchange, (String)entry.getKey(), entry.getValue().toString());
                continue;
            }
            if (((String)entry.getKey()).startsWith("org.apache.cxf.message.Message.") && (entry.getValue() instanceof String || entry.getValue() instanceof Integer || entry.getValue() instanceof Boolean)) {
                PersistOutInterceptor.addProperty(exchange, (String)entry.getKey(), entry.getValue().toString());
                continue;
            }
            if (!((String)entry.getKey()).startsWith(CXF_CONSOLE_ADDITIONAL_PROPERTY_PREFIX)) continue;
            PersistOutInterceptor.addProperty(exchange, ((String)entry.getKey()).substring(CXF_CONSOLE_ADDITIONAL_PROPERTY_PREFIX.length()), entry.getValue().toString());
        }
    }

    @Override
    public void handleMessage(Message message) throws Fault {
        ExchangeData exchangeData = message.getExchange().getInMessage().getContent(ExchangeData.class);
        if (exchangeData != null) {
            OutputStream os = message.getContent(OutputStream.class);
            if (os == null) {
                return;
            }
            try {
                Object nameProperty;
                String operationName;
                Service service = message.getExchange().get(Service.class);
                String serviceName = String.valueOf(service.getName());
                OperationInfo opInfo = message.getExchange().get(OperationInfo.class);
                String string = operationName = opInfo == null ? null : opInfo.getName().getLocalPart();
                if (operationName == null && (nameProperty = message.getExchange().get("org.apache.cxf.resource.operation.name")) != null) {
                    operationName = "\"" + nameProperty.toString() + "\"";
                }
                exchangeData.setServiceName(serviceName);
                exchangeData.setOperation(operationName);
                this.addPropertiesFrom(exchangeData, message.getExchange().getInMessage());
                this.addPropertiesFrom(exchangeData, message);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            CacheAndWriteOutputStream newOut = new CacheAndWriteOutputStream(os);
            message.setContent(OutputStream.class, newOut);
            newOut.registerCallback(new PersistOutInterceptorCallback(message, os, exchangeData));
            exchangeData.setOutDate(new Date());
            if (message.getContent(Exception.class) != null) {
                exchangeData.setStatus("ERROR");
                Exception exception = message.getContent(Exception.class);
                StringWriter stringWriter = new StringWriter();
                if (exception.getCause() != null) {
                    exchangeData.setExceptionType(exception.getCause().getClass().getName());
                    exception.getCause().printStackTrace(new PrintWriter(stringWriter));
                } else {
                    exchangeData.setExceptionType(exception.getClass().getName());
                    exception.printStackTrace(new PrintWriter(stringWriter));
                }
                exchangeData.setStackTrace(stringWriter.toString());
            } else {
                exchangeData.setStatus("OK");
            }
        }
    }

    public void setExchangeDataDAO(ExchangeDataDAO exchangeDataDAO) {
        this.exchangeDataDAO = exchangeDataDAO;
    }

    public void setExchangeDataFilter(ExchangeDataFilter exchangeDataFilter) {
        this.exchangeDataFilter = exchangeDataFilter;
    }

    class PersistOutInterceptorCallback
    implements CachedOutputStreamCallback {
        private final Message message;
        private final OutputStream origStream;
        private final ExchangeData exchange;

        public PersistOutInterceptorCallback(Message msg, OutputStream os, ExchangeData ex) {
            this.message = msg;
            this.origStream = os;
            this.exchange = ex;
        }

        public void onClose(CachedOutputStream cos) {
            String id = (String)this.message.getExchange().get(LoggingMessage.ID_KEY);
            if (id == null) {
                id = LoggingMessage.nextId();
                this.message.getExchange().put(LoggingMessage.ID_KEY, id);
            }
            try {
                StringBuilder buffer = new StringBuilder();
                cos.writeCacheTo(buffer, cos.size());
                this.exchange.setResponseSize((int)cos.size());
                this.exchange.setResponse(buffer.toString());
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                cos.lockOutputStream();
                cos.resetOut(null, false);
            }
            catch (Exception ex) {
                // empty catch block
            }
            this.message.setContent(OutputStream.class, this.origStream);
            if (PersistOutInterceptor.this.exchangeDataFilter == null || PersistOutInterceptor.this.exchangeDataFilter.shouldPersist(this.exchange)) {
                try {
                    PersistOutInterceptor.this.exchangeDataDAO.save(this.exchange);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }

        public void onFlush(CachedOutputStream cos) {
        }
    }
}

