/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.action;

import java.util.ArrayList;
import java.util.List;
import net.sf.vex.action.TableCellCallback;
import net.sf.vex.core.IntRange;
import net.sf.vex.css.StyleSheet;
import net.sf.vex.dom.IVexDocument;
import net.sf.vex.dom.IVexElement;
import net.sf.vex.dom.IVexNode;
import net.sf.vex.layout.BlockBox;
import net.sf.vex.layout.Box;
import net.sf.vex.layout.ElementOrRangeCallback;
import net.sf.vex.layout.LayoutUtils;
import net.sf.vex.layout.TableRowBox;
import net.sf.vex.widget.IBoxFilter;
import net.sf.vex.widget.IVexWidget;

public class ActionUtils {
    public static void cloneTableCells(final IVexWidget vexWidget, final TableRowBox tr, final boolean moveToFirstCell) {
        vexWidget.doWork(new Runnable(){

            @Override
            public void run() {
                int offset = vexWidget.getCaretOffset();
                boolean firstCellIsAnonymous = false;
                Box[] cells = tr.getChildren();
                int i = 0;
                while (i < cells.length) {
                    if (cells[i].isAnonymous()) {
                        vexWidget.insertText(" ");
                        if (i == 0) {
                            firstCellIsAnonymous = true;
                        }
                    } else {
                        vexWidget.insertElement(cells[i].getElement().clone());
                        vexWidget.moveBy(1);
                    }
                    ++i;
                }
                if (moveToFirstCell) {
                    vexWidget.moveTo(offset + 1);
                    if (firstCellIsAnonymous) {
                        vexWidget.moveBy(-1, true);
                    }
                }
            }
        });
    }

    public static void duplicateTableRow(final IVexWidget vexWidget, final TableRowBox tr) {
        vexWidget.doWork(new Runnable(){

            @Override
            public void run() {
                vexWidget.moveTo(tr.getEndOffset());
                if (!tr.isAnonymous()) {
                    vexWidget.moveBy(1);
                    vexWidget.insertElement(tr.getElement().clone());
                }
                ActionUtils.cloneTableCells(vexWidget, tr, true);
            }
        });
    }

    public static boolean elementOrRangeIsPartiallySelected(IVexWidget vexWidget, Object elementOrRange) {
        IntRange range = ActionUtils.getInnerRange(elementOrRange);
        return range.getEnd() >= vexWidget.getSelectionStart() && range.getStart() <= vexWidget.getSelectionEnd();
    }

    public static int getCurrentColumnIndex(IVexWidget vexWidget) {
        IVexElement row = ActionUtils.getCurrentTableRow(vexWidget);
        if (row == null) {
            return -1;
        }
        final int offset = vexWidget.getCaretOffset();
        final int[] column = new int[]{-1};
        LayoutUtils.iterateTableCells(vexWidget.getStyleSheet(), row, new ElementOrRangeCallback(){
            private int i = 0;

            @Override
            public void onElement(IVexElement child, String displayStyle) {
                if (offset > child.getStartOffset() && offset <= child.getEndOffset()) {
                    column[0] = this.i;
                }
                ++this.i;
            }

            @Override
            public void onRange(IVexElement parent, int startOffset, int endOffset) {
                ++this.i;
            }
        });
        return column[0];
    }

    public static IVexElement getCurrentTableRow(IVexWidget vexWidget) {
        StyleSheet ss = vexWidget.getStyleSheet();
        IVexElement element = vexWidget.getCurrentElement();
        while (element != null) {
            if (ss.getStyles(element).getDisplay().equalsIgnoreCase("table-row")) {
                return element;
            }
            element = element.getParent();
        }
        return null;
    }

    public static int getPreviousSiblingStart(IVexWidget vexWidget) {
        int startOffset;
        if (vexWidget.hasSelection()) {
            startOffset = vexWidget.getSelectionStart();
        } else {
            Box box = vexWidget.findInnermostBox(new IBoxFilter(){

                @Override
                public boolean matches(Box box) {
                    return box instanceof BlockBox && box.getElement() != null;
                }
            });
            if (box.getElement() == vexWidget.getDocument().getRootElement()) {
                return -1;
            }
            startOffset = box.getElement().getStartOffset();
        }
        int previousSiblingStart = -1;
        IVexElement parent = vexWidget.getDocument().getElementAt(startOffset);
        IVexNode[] children = parent.getChildNodes();
        int i = 0;
        while (i < children.length) {
            IVexNode child = children[i];
            if (startOffset == child.getStartOffset()) break;
            previousSiblingStart = child.getStartOffset();
            ++i;
        }
        return previousSiblingStart;
    }

    public static BlockBox[] getSelectedBlockBoxes(final IVexWidget vexWidget) {
        if (!vexWidget.hasSelection()) {
            return new BlockBox[0];
        }
        Box parent = vexWidget.findInnermostBox(new IBoxFilter(){

            @Override
            public boolean matches(Box box) {
                return box instanceof BlockBox && box.getStartOffset() <= vexWidget.getSelectionStart() && box.getEndOffset() >= vexWidget.getSelectionEnd();
            }
        });
        ArrayList<Box> blockList = new ArrayList<Box>();
        Box[] children = parent.getChildren();
        int i = 0;
        while (i < children.length) {
            Box child = children[i];
            if (child instanceof BlockBox && child.getStartOffset() >= vexWidget.getSelectionStart() && child.getEndOffset() <= vexWidget.getSelectionEnd()) {
                blockList.add(child);
            }
            ++i;
        }
        return blockList.toArray(new BlockBox[blockList.size()]);
    }

    public static SelectedRows getSelectedTableRows(final IVexWidget vexWidget) {
        final SelectedRows selected = new SelectedRows();
        ActionUtils.iterateTableCells(vexWidget, new TableCellCallback(){

            @Override
            public void startRow(Object row, int rowIndex) {
                if (ActionUtils.elementOrRangeIsPartiallySelected(vexWidget, row)) {
                    if (selected.rows == null) {
                        selected.rows = new ArrayList();
                    }
                    selected.rows.add(row);
                } else if (selected.rows == null) {
                    selected.rowBefore = row;
                } else if (selected.rowAfter == null) {
                    selected.rowAfter = row;
                }
            }

            @Override
            public void onCell(Object row, Object cell, int rowIndex, int cellIndex) {
            }

            @Override
            public void endRow(Object row, int rowIndex) {
            }
        });
        return selected;
    }

    public static void iterateTableCells(IVexWidget vexWidget, final TableCellCallback callback) {
        final StyleSheet ss = vexWidget.getStyleSheet();
        ActionUtils.iterateTableRows(vexWidget, new ElementOrRangeCallback(){
            private final int[] rowIndex = new int[1];

            @Override
            public void onElement(final IVexElement row, String displayStyle) {
                callback.startRow(row, this.rowIndex[0]);
                LayoutUtils.iterateTableCells(ss, row, new ElementOrRangeCallback(){
                    private int cellIndex = 0;

                    @Override
                    public void onElement(IVexElement cell, String displayStyle) {
                        callback.onCell(row, cell, rowIndex[0], this.cellIndex);
                        ++this.cellIndex;
                    }

                    @Override
                    public void onRange(IVexElement parent, int startOffset, int endOffset) {
                        callback.onCell(row, new IntRange(startOffset, endOffset), rowIndex[0], this.cellIndex);
                        ++this.cellIndex;
                    }
                });
                callback.endRow(row, this.rowIndex[0]);
                this.rowIndex[0] = this.rowIndex[0] + 1;
            }

            @Override
            public void onRange(IVexElement parent, int startOffset, int endOffset) {
                final IntRange row = new IntRange(startOffset, endOffset);
                callback.startRow(row, this.rowIndex[0]);
                LayoutUtils.iterateTableCells(ss, parent, startOffset, endOffset, new ElementOrRangeCallback(){
                    private int cellIndex = 0;

                    @Override
                    public void onElement(IVexElement cell, String displayStyle) {
                        callback.onCell(row, cell, rowIndex[0], this.cellIndex);
                        ++this.cellIndex;
                    }

                    @Override
                    public void onRange(IVexElement parent, int startOffset, int endOffset) {
                        callback.onCell(row, new IntRange(startOffset, endOffset), rowIndex[0], this.cellIndex);
                        ++this.cellIndex;
                    }
                });
                callback.endRow(row, this.rowIndex[0]);
                this.rowIndex[0] = this.rowIndex[0] + 1;
            }
        });
    }

    public static RowColumnInfo getRowColumnInfo(IVexWidget vexWidget) {
        final boolean[] found = new boolean[1];
        final RowColumnInfo[] rcInfo = new RowColumnInfo[]{new RowColumnInfo()};
        final int offset = vexWidget.getCaretOffset();
        rcInfo[0].cellIndex = -1;
        rcInfo[0].rowIndex = -1;
        ActionUtils.iterateTableCells(vexWidget, new TableCellCallback(){
            int rowColumnCount;

            @Override
            public void startRow(Object row, int rowIndex) {
                this.rowColumnCount = 0;
            }

            @Override
            public void onCell(Object row, Object cell, int rowIndex, int cellIndex) {
                found[0] = true;
                if (LayoutUtils.elementOrRangeContains(row, offset)) {
                    rcInfo[0].row = row;
                    rcInfo[0].rowIndex = rowIndex;
                    ++rcInfo[0].columnCount;
                    if (LayoutUtils.elementOrRangeContains(cell, offset)) {
                        rcInfo[0].cell = cell;
                        rcInfo[0].cellIndex = cellIndex;
                    }
                }
                ++this.rowColumnCount;
            }

            @Override
            public void endRow(Object row, int rowIndex) {
                ++rcInfo[0].rowCount;
                rcInfo[0].maxColumnCount = Math.max(rcInfo[0].maxColumnCount, this.rowColumnCount);
            }
        });
        if (found[0]) {
            return rcInfo[0];
        }
        return null;
    }

    public static void iterateTableRows(IVexWidget vexWidget, ElementOrRangeCallback callback) {
        StyleSheet ss = vexWidget.getStyleSheet();
        IVexDocument doc = vexWidget.getDocument();
        final int offset = vexWidget.getCaretOffset();
        IVexElement table = doc.getElementAt(offset);
        while (table != null && !LayoutUtils.isTableChild(ss, table)) {
            table = table.getParent();
        }
        while (table != null && LayoutUtils.isTableChild(ss, table)) {
            table = table.getParent();
        }
        if (table == null || table.getParent() == null) {
            return;
        }
        final ArrayList tableChildren = new ArrayList();
        final boolean[] found = new boolean[1];
        LayoutUtils.iterateChildrenByDisplayStyle(ss, LayoutUtils.TABLE_CHILD_STYLES, table, new ElementOrRangeCallback(){

            @Override
            public void onElement(IVexElement child, String displayStyle) {
                if (offset >= child.getStartOffset() && offset <= child.getEndOffset()) {
                    found[0] = true;
                }
                tableChildren.add(child);
            }

            @Override
            public void onRange(IVexElement parent, int startOffset, int endOffset) {
                if (!found[0]) {
                    tableChildren.clear();
                }
            }
        });
        if (!found[0]) {
            return;
        }
        int startOffset = ((IVexElement)tableChildren.get(0)).getStartOffset();
        int endOffset = ((IVexElement)tableChildren.get(tableChildren.size() - 1)).getEndOffset() + 1;
        LayoutUtils.iterateTableRows(ss, table, startOffset, endOffset, callback);
    }

    public static IntRange getInnerRange(Object elementOrRange) {
        if (elementOrRange instanceof IVexElement) {
            IVexElement element = (IVexElement)elementOrRange;
            return new IntRange(element.getStartOffset() + 1, element.getEndOffset());
        }
        return (IntRange)elementOrRange;
    }

    public static IntRange getOuterRange(Object elementOrRange) {
        if (elementOrRange instanceof IVexElement) {
            IVexElement element = (IVexElement)elementOrRange;
            return new IntRange(element.getStartOffset(), element.getEndOffset() + 1);
        }
        return (IntRange)elementOrRange;
    }

    public static class RowColumnInfo {
        public Object row;
        public Object cell;
        public int rowIndex;
        public int cellIndex;
        public int rowCount;
        public int columnCount;
        public int maxColumnCount;
    }

    public static class SelectedRows {
        private List rows;
        private Object rowBefore;
        private Object rowAfter;

        private SelectedRows() {
        }

        public List getRows() {
            return this.rows;
        }

        public Object getRowBefore() {
            return this.rowBefore;
        }

        public Object getRowAfter() {
            return this.rowAfter;
        }
    }
}

