/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.action;

import java.util.ArrayList;
import java.util.List;
import net.sf.vex.action.AbstractVexAction;
import net.sf.vex.action.ActionUtils;
import net.sf.vex.action.TableCellCallback;
import net.sf.vex.dom.IVexElement;
import net.sf.vex.widget.IVexWidget;

public class InsertRowAction
extends AbstractVexAction {
    private boolean above;

    public InsertRowAction(boolean above) {
        this.above = above;
    }

    @Override
    public void run(final IVexWidget vexWidget) {
        vexWidget.doWork(new Runnable(){

            @Override
            public void run() {
                int insertOffset;
                final ArrayList rowsToInsert = new ArrayList();
                final ArrayList rowCellsToInsert = new ArrayList();
                ActionUtils.iterateTableCells(vexWidget, new TableCellCallback(){
                    boolean rowSelected;
                    List cellsToInsert;

                    @Override
                    public void startRow(Object row, int rowIndex) {
                        this.rowSelected = ActionUtils.elementOrRangeIsPartiallySelected(vexWidget, row);
                        if (this.rowSelected) {
                            this.cellsToInsert = new ArrayList();
                        }
                    }

                    @Override
                    public void onCell(Object row, Object cell, int rowIndex, int cellIndex) {
                        if (this.rowSelected) {
                            this.cellsToInsert.add(cell);
                        }
                    }

                    @Override
                    public void endRow(Object row, int rowIndex) {
                        if (this.rowSelected) {
                            rowsToInsert.add(row);
                            rowCellsToInsert.add(this.cellsToInsert);
                        }
                    }
                });
                if (rowsToInsert.size() == 0) {
                    return;
                }
                int outerOffset = ActionUtils.getOuterRange(rowsToInsert.get(0)).getStart();
                List firstCells = (List)rowCellsToInsert.get(0);
                int innerOffset = firstCells.size() == 0 ? ActionUtils.getInnerRange(rowsToInsert.get(0)).getStart() : ActionUtils.getInnerRange(firstCells.get(0)).getStart();
                if (InsertRowAction.this.above) {
                    insertOffset = ActionUtils.getOuterRange(rowsToInsert.get(0)).getStart();
                } else {
                    Object lastRow = rowsToInsert.get(rowsToInsert.size() - 1);
                    insertOffset = ActionUtils.getOuterRange(lastRow).getEnd();
                }
                int finalOffset = insertOffset + (innerOffset - outerOffset);
                vexWidget.moveTo(insertOffset);
                int i = 0;
                while (i < rowsToInsert.size()) {
                    Object row = rowsToInsert.get(i);
                    if (row instanceof IVexElement) {
                        vexWidget.insertElement(((IVexElement)row).clone());
                    }
                    List cellsToInsert = (List)rowCellsToInsert.get(i);
                    int j = 0;
                    while (j < cellsToInsert.size()) {
                        Object cell = cellsToInsert.get(j);
                        if (cell instanceof IVexElement) {
                            vexWidget.insertElement(((IVexElement)cell).clone());
                            vexWidget.moveBy(1);
                        } else {
                            vexWidget.insertText(" ");
                        }
                        ++j;
                    }
                    if (row instanceof IVexElement) {
                        vexWidget.moveBy(1);
                    }
                    ++i;
                }
                vexWidget.moveTo(finalOffset);
            }
        });
    }

    @Override
    public boolean isEnabled(IVexWidget vexWidget) {
        return true;
    }
}

