/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.core;

public class Rectangle {
    private int x;
    private int y;
    private int width;
    private int height;

    public Rectangle(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public boolean intersects(Rectangle rect) {
        return rect.x < this.x + this.width && rect.x + rect.width > this.x && rect.y < this.y + this.height && rect.y + rect.height > this.y;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(80);
        sb.append(Rectangle.class.getName());
        sb.append("[x=");
        sb.append(this.getX());
        sb.append(",y=");
        sb.append(this.getY());
        sb.append(",width=");
        sb.append(this.getWidth());
        sb.append(",height=");
        sb.append(this.getHeight());
        sb.append("]");
        return sb.toString();
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public Rectangle union(Rectangle rect) {
        int left = Math.min(this.x, rect.x);
        int top = Math.min(this.y, rect.y);
        int right = Math.max(this.x + this.width, rect.x + rect.width);
        int bottom = Math.max(this.y + this.height, rect.y + rect.height);
        return new Rectangle(left, top, right - left, bottom - top);
    }
}

