/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.css;

import net.sf.vex.core.DisplayDevice;
import net.sf.vex.css.AbstractProperty;
import net.sf.vex.css.RelativeLength;
import net.sf.vex.css.Styles;
import org.w3c.css.sac.LexicalUnit;

public class LineHeightProperty
extends AbstractProperty {
    private static final float LINE_HEIGHT_NORMAL = 1.2f;

    public LineHeightProperty() {
        super("line-height");
    }

    @Override
    public Object calculate(LexicalUnit lu, Styles parentStyles, Styles styles) {
        int ppi = DisplayDevice.getCurrent().getVerticalPPI();
        if (LineHeightProperty.isLength(lu)) {
            return RelativeLength.createAbsolute(Math.round((float)LineHeightProperty.getIntLength(lu, styles.getFontSize(), ppi) / styles.getFontSize()));
        }
        if (LineHeightProperty.isNumber(lu)) {
            if (LineHeightProperty.getNumber(lu) <= 0.0f) {
                return RelativeLength.createRelative(1.2f);
            }
            return RelativeLength.createRelative(LineHeightProperty.getNumber(lu));
        }
        if (LineHeightProperty.isPercentage(lu)) {
            if (lu.getFloatValue() <= 0.0f) {
                return RelativeLength.createRelative(1.2f);
            }
            return RelativeLength.createRelative(lu.getFloatValue() / 100.0f);
        }
        if (parentStyles == null) {
            return RelativeLength.createRelative(1.2f);
        }
        return (RelativeLength)parentStyles.get("line-height");
    }
}

