/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.dom.linked;

import com.google.common.collect.Lists;
import info.textgrid.lab.core.swtutils.AdapterUtils;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.sf.vex.VexToolkitPlugin;
import net.sf.vex.dom.Content;
import net.sf.vex.dom.DocumentEvent;
import net.sf.vex.dom.DocumentValidationException;
import net.sf.vex.dom.IVexDocument;
import net.sf.vex.dom.IVexDocumentFragment;
import net.sf.vex.dom.IVexElement;
import net.sf.vex.dom.IVexNode;
import net.sf.vex.dom.IVexNonElement;
import net.sf.vex.dom.IVexText;
import net.sf.vex.dom.IWhitespacePolicy;
import net.sf.vex.dom.Validator;
import net.sf.vex.dom.impl.Document;
import net.sf.vex.dom.impl.WrongModelException;
import net.sf.vex.dom.linked.LinkedElement;
import net.sf.vex.dom.linked.LinkedNode;
import net.sf.vex.dom.linked.LinkedNonElement;
import net.sf.vex.dom.linked.LinkedRootElement;
import net.sf.vex.dom.linked.LinkedText;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.w3c.dom.Text;

public class LinkedDocument
extends Document
implements IVexDocument {
    private IDOMDocument domDocument;
    private IWhitespacePolicy whitespacePolicy;

    public LinkedDocument(IDOMDocument domDocument) {
        super(new LinkedRootElement(domDocument.getDocumentElement()));
        this.setDomDocument(domDocument);
    }

    private void setDomDocument(IDOMDocument domDocument) {
        this.domDocument = domDocument;
    }

    public IDOMDocument getDomDocument() {
        return this.domDocument;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void delete(int startOffset, int endOffset) throws DocumentValidationException {
        Object seq2;
        LinkedElement e2;
        LinkedElement e1 = (LinkedElement)this.getElementAt(startOffset);
        if (e1 != (e2 = (LinkedElement)this.getElementAt(endOffset))) {
            throw new IllegalArgumentException("Deletion from " + startOffset + " to " + endOffset + " is unbalanced");
        }
        Validator validator = this.getValidator();
        if (validator != null) {
            String[] seq1 = this.getNodeNames(e1.getStartOffset() + 1, startOffset);
            seq2 = this.getNodeNames(endOffset, e1.getEndOffset());
            if (!validator.isValidSequence(e1.getName(), seq1, (String[])seq2, null, true)) {
                throw new DocumentValidationException("Unable to delete from " + startOffset + " to " + endOffset);
            }
        }
        IVexDocumentFragment frag = this.getFragment(startOffset, endOffset);
        this.fireBeforeContentDeleted(new DocumentEvent(this, e1, startOffset, endOffset - startOffset, null));
        seq2 = e1;
        synchronized (seq2) {
            Iterator<IVexNode> iter = e1.getChildNodeIterator();
            while (iter.hasNext()) {
                IVexNode child = iter.next();
                if (startOffset <= child.getStartOffset() && child.getEndOffset() < endOffset) {
                    if (!(child instanceof LinkedNode)) continue;
                    LinkedNode linkedChild = (LinkedNode)child;
                    linkedChild.getDomNode().getParentNode().removeChild(linkedChild.getDomNode());
                    continue;
                }
                if (child instanceof LinkedNonElement && startOffset > child.getStartOffset() && endOffset <= child.getEndOffset()) {
                    ((LinkedNonElement)child).deleteTextAbs(startOffset, endOffset);
                    continue;
                }
                if (!(child instanceof LinkedText) || startOffset < child.getStartOffset() || endOffset > child.getEndOffset()) continue;
                ((LinkedText)child).deleteTextAbs(startOffset, endOffset);
            }
        }
        Document.DeleteEdit edit = this.isUndoEnabled() ? new Document.DeleteEdit(startOffset, endOffset, frag) : null;
        this.fireContentDeleted(new DocumentEvent(this, e1, startOffset, endOffset - startOffset, edit));
        if (VexToolkitPlugin.isDebugging("net.sf.vex.toolkit/debug")) {
            this.hasValidContent();
            System.out.println(this.getContent().getString(0, this.getContent().getLength()).replace("\u0000", "\\0").replace("\n", "\\n"));
        }
    }

    @Override
    public void insertElement(int offset, IVexElement elementArg) throws DocumentValidationException {
        IVexElement parent;
        WrongModelException.throwIfNeeded(elementArg, LinkedElement.class);
        LinkedElement element = (LinkedElement)elementArg;
        if (offset < 1 || offset >= this.getLength()) {
            throw new IllegalArgumentException("Error inserting element <" + element.getName() + ">: offset is " + offset + ", but it must be between 1 and " + (this.getLength() - 1));
        }
        Validator validator = this.getValidator();
        if (validator != null) {
            parent = this.getElementAt(offset);
            String[] seq1 = this.getNodeNames(parent.getStartOffset() + 1, offset);
            String[] seq2 = new String[]{element.getName()};
            String[] seq3 = this.getNodeNames(offset, parent.getEndOffset());
            if (!validator.isValidSequence(parent.getName(), seq1, seq2, seq3, true)) {
                throw new DocumentValidationException("Cannot insert element " + element.getName() + " at offset " + offset);
            }
        }
        parent = this.getRootElement();
        int childIndex = -1;
        while (childIndex == -1) {
            boolean tryAgain = false;
            IVexElement[] children = parent.getChildElements();
            int i = 0;
            while (i < children.length) {
                IVexElement child = children[i];
                if (offset <= child.getStartOffset()) {
                    childIndex = i;
                    break;
                }
                if (offset <= child.getEndOffset()) {
                    parent = child;
                    tryAgain = true;
                    break;
                }
                ++i;
            }
            if (tryAgain || childIndex != -1) continue;
            childIndex = children.length;
            break;
        }
        this.fireBeforeContentInserted(new DocumentEvent(this, parent, offset, 2, null));
        this.getContent().insertString(offset, "\u0000\u0000");
        element.setContent(this.getContent(), offset, offset + 1);
        element.setParent(parent);
        parent.internalInsertChild(childIndex, element);
        Document.InsertElementEdit edit = this.isUndoEnabled() ? new Document.InsertElementEdit(offset, element) : null;
        this.fireContentInserted(new DocumentEvent(this, parent, offset, 2, edit));
    }

    @Override
    public void insertFragment(int offset, IVexDocumentFragment fragment) throws DocumentValidationException {
        if (offset < 1 || offset >= this.getLength()) {
            throw new IllegalArgumentException("Error inserting document fragment");
        }
        IVexElement parent = this.getElementAt(offset);
        if (this.getValidator() != null) {
            String[] seq1 = this.getNodeNames(parent.getStartOffset() + 1, offset);
            String[] seq2 = fragment.getNodeNames();
            String[] seq3 = this.getNodeNames(offset, parent.getEndOffset());
            if (!this.getValidator().isValidSequence(parent.getName(), seq1, seq2, seq3, true)) {
                throw new DocumentValidationException("Cannot insert document fragment");
            }
        }
        this.fireBeforeContentInserted(new DocumentEvent(this, parent, offset, 2, null));
        Content c = fragment.getContent();
        String s = c.getString(0, c.getLength());
        this.getContent().insertString(offset, s);
        IVexElement[] children = parent.getChildElements();
        int index = 0;
        while (index < children.length && children[index].getEndOffset() < offset) {
            ++index;
        }
        IVexElement[] elements = fragment.getElements();
        int i = 0;
        while (i < elements.length) {
            IVexElement newElement = this.cloneElement(elements[i], this.getContent(), offset, parent);
            parent.internalInsertChild(index, newElement);
            ++index;
            ++i;
        }
        Document.InsertFragmentEdit edit = this.isUndoEnabled() ? new Document.InsertFragmentEdit(offset, fragment) : null;
        this.fireContentInserted(new DocumentEvent(this, parent, offset, fragment.getContent().getLength(), edit));
    }

    @Override
    public void insertText(int offset, String text) throws DocumentValidationException {
        if (offset < 1 || offset >= this.getLength()) {
            throw new IllegalArgumentException("Offset must be between 1 and " + this.getLength());
        }
        IVexElement parent = this.getElementAt(offset);
        boolean isValid = false;
        if (this.getCharacterAt(offset - 1) != '\u0000') {
            isValid = true;
        } else if (this.getCharacterAt(offset) != '\u0000') {
            isValid = true;
        } else {
            Validator validator = this.getValidator();
            if (validator != null) {
                String[] seq1 = this.getNodeNames(parent.getStartOffset() + 1, offset);
                String[] seq2 = new String[]{"#PCDATA"};
                String[] seq3 = this.getNodeNames(offset, parent.getEndOffset());
                isValid = validator.isValidSequence(parent.getName(), seq1, seq2, seq3, true);
            } else {
                isValid = true;
            }
        }
        if (!isValid) {
            throw new DocumentValidationException("Cannot insert text '" + text + "' at offset " + offset);
        }
        StringBuffer sb = new StringBuffer(text);
        int i = 0;
        while (i < sb.length()) {
            if (Character.isISOControl(sb.charAt(i)) && sb.charAt(i) != '\n') {
                sb.setCharAt(i, ' ');
            }
            ++i;
        }
        String s = sb.toString();
        this.fireBeforeContentInserted(new DocumentEvent(this, parent, offset, 2, null));
        LinkedNode node = this.getNodeAt(offset);
        if (node instanceof LinkedNonElement) {
            ((LinkedNonElement)node).insertTextAbs(offset, s);
        } else if (node instanceof LinkedText) {
            ((LinkedText)node).insertTextAbs(offset, s);
        } else if (node instanceof LinkedElement) {
            LinkedElement element = (LinkedElement)node;
            Text domText = this.getDomDocument().createTextNode(s);
            if (node instanceof LinkedElement && offset == node.getStartOffset()) {
                node.getParent().getDomNode().insertBefore(domText, node.getDomNode());
            } else {
                LinkedNode insertItBeforeMe = null;
                Iterator<IVexElement> children = element.getChildIterator();
                while (children.hasNext()) {
                    IVexElement next = children.next();
                    if (next.getStartOffset() != offset + 1) continue;
                    insertItBeforeMe = (LinkedNode)((Object)next);
                    break;
                }
                if (insertItBeforeMe != null) {
                    element.getDomNode().insertBefore(domText, insertItBeforeMe.getDomNode());
                } else {
                    element.getDomNode().appendChild(domText);
                }
            }
        }
        Document.InsertTextEdit edit = this.isUndoEnabled() ? new Document.InsertTextEdit(offset, s) : null;
        this.fireContentInserted(new DocumentEvent(this, parent, offset, s.length(), edit));
    }

    protected void fireElementChanged(IVexElement element) {
        DocumentEvent event = new DocumentEvent(this, element, element.getStartOffset(), element.getEndOffset() - element.getStartOffset(), null);
        this.getListeners().fireEvent("elementChanged", event);
    }

    public LinkedNode getNodeAt(int offset) {
        LinkedNode child;
        if (offset < 1 || offset >= this.getLength()) {
            throw new IllegalArgumentException("Illegal offset: " + offset + ". Must be between 1 and n-1");
        }
        LinkedElement parent = (LinkedElement)this.getRootElement();
        Iterator<IVexNode> iter = parent.getChildNodeIterator();
        while (true) {
            if (!iter.hasNext()) {
                return parent;
            }
            child = (LinkedNode)iter.next();
            if (child.getStartOffset() > offset || child.getEndOffset() < offset) continue;
            if (!(child instanceof LinkedElement)) break;
            if (!child.hasChildren()) {
                return child;
            }
            parent = (LinkedElement)child;
            iter = parent.getChildNodeIterator();
        }
        return child;
    }

    @Override
    public IVexNode[] getNodes(int startOffset, int endOffset) {
        IVexElement element = this.getElementAt(startOffset);
        if (element != this.getElementAt(endOffset)) {
            throw new IllegalArgumentException("Offsets are unbalanced: " + startOffset + " is in " + element.getName() + ", " + endOffset + " is in " + this.getElementAt(endOffset).getName());
        }
        ArrayList<IVexNode> list = new ArrayList<IVexNode>();
        IVexNode[] nodes = element.getChildNodes();
        int i = 0;
        while (i < nodes.length) {
            IVexNode node = nodes[i];
            if (node.getEndOffset() > startOffset) {
                if (node.getStartOffset() >= endOffset) break;
                if (node instanceof IVexElement) {
                    list.add(node);
                } else if (node instanceof IVexText) {
                    IVexText text = (IVexText)node;
                    list.add(text);
                } else if (node instanceof IVexNonElement) {
                    IVexNonElement ne = (IVexNonElement)node;
                    list.add(ne);
                } else {
                    throw new IllegalStateException("Unknown node type. Implement right here.");
                }
            }
            ++i;
        }
        return list.toArray(new IVexNode[list.size()]);
    }

    public boolean hasValidContent() {
        return ((LinkedElement)this.getRootElement()).hasValidContent();
    }

    @Deprecated
    public void printDocument() {
        this.printDocument(System.out);
    }

    public void printDocument(PrintStream output) {
        output.append("Document(" + this.getText(0, this.getLength()).replace("\u0000", "\\0").replace("\n", "\\n").replace("\r", "\\r") + ")");
        LinkedElement root = (LinkedElement)this.getRootElement();
        LinkedDocument.printElem(root, "", output);
    }

    @Deprecated
    protected static void printElem(LinkedElement element, String indent) {
        LinkedDocument.printElem(element, indent, System.out);
    }

    protected static void printElem(LinkedElement element, String indent, PrintStream output) {
        output.print(indent);
        output.println(element.toString());
        Iterator<IVexNode> i = element.getChildNodeIterator();
        while (i.hasNext()) {
            IVexNode node = i.next();
            if (node instanceof IVexElement) {
                LinkedDocument.printElem((LinkedElement)node, String.valueOf(indent) + " ", output);
                continue;
            }
            output.print(String.valueOf(indent) + " ");
            output.println(node.toString());
        }
    }

    protected static boolean isSubtreeConsistent(LinkedNode node, List<ModelError> broken, boolean failFast) {
        if (node.getStartOffset() > node.getEndOffset()) {
            broken.add(new ModelError("Start after end", node));
            if (failFast) {
                return false;
            }
        }
        if (node instanceof LinkedElement) {
            LinkedElement element = (LinkedElement)node;
            if (!"\u0000".equals(element.getContent().getString(element.getStartOffset(), 1))) {
                broken.add(new ModelError("Element content doesn't start with marker", element));
                if (failFast) {
                    return false;
                }
            }
            if (element.getEndOffset() < element.getContent().getLength() && !"\u0000".equals(element.getContent().getString(element.getEndOffset(), 1))) {
                broken.add(new ModelError("Element content doesn't end with marker", element));
                if (failFast) {
                    return false;
                }
            }
            int start = element.getStartOffset();
            IndexedRegion parentRegion = (IndexedRegion)AdapterUtils.getAdapter((Object)element.getDomNode(), IndexedRegion.class);
            IndexedRegion previousRegion = null;
            Iterator<IVexNode> iterator = element.getChildNodeIterator();
            while (iterator.hasNext()) {
                IndexedRegion currentRegion;
                LinkedNode child = (LinkedNode)iterator.next();
                if (child.getStartOffset() < start) {
                    broken.add(new ModelError("Starts before it should", child));
                    if (failFast) {
                        return false;
                    }
                }
                if ((currentRegion = (IndexedRegion)AdapterUtils.getAdapter((Object)child, IndexedRegion.class)).getStartOffset() < parentRegion.getStartOffset() || currentRegion.getEndOffset() > parentRegion.getEndOffset()) {
                    broken.add(new ModelError("DOM node outside of parent's DOM node", child));
                    if (failFast) {
                        return false;
                    }
                }
                if (previousRegion != null && currentRegion.getStartOffset() < previousRegion.getStartOffset()) {
                    broken.add(new ModelError("source region before previous node's source region", child));
                    if (failFast) {
                        return false;
                    }
                }
                start = child.getStartOffset();
                boolean subCheck = LinkedDocument.isSubtreeConsistent(child, broken, failFast);
                if (failFast && !subCheck) {
                    return subCheck;
                }
                if (child.getEndOffset() > node.getEndOffset()) {
                    broken.add(new ModelError("End of bounds", child));
                    if (failFast) {
                        return false;
                    }
                }
                previousRegion = currentRegion;
            }
            if (start > node.getEndOffset()) {
                broken.add(new ModelError("Bounds to tight", node));
                if (failFast) {
                    return false;
                }
            }
        }
        return broken.isEmpty();
    }

    public void printModelCheckReport(PrintStream output) {
        LinkedList broken = Lists.newLinkedList();
        LinkedDocument.isSubtreeConsistent((LinkedElement)this.getRootElement(), broken, false);
        if (broken.isEmpty()) {
            output.println("Automatic consistency check didn't find any problems in the WYSIWYM model.");
        } else {
            output.println(MessageFormat.format("Found {0} errors in the WYSIWYM model.", broken.size()));
            for (ModelError modelError : broken) {
                output.println(modelError);
            }
        }
    }

    @Override
    public void setWhitespacePolicy(IWhitespacePolicy whitespacePolicy) {
        this.whitespacePolicy = whitespacePolicy;
    }

    @Override
    public IWhitespacePolicy getWhitespacePolicy() {
        return this.whitespacePolicy;
    }

    public IRegion contentRegionFor(IRegion sourceRegion) {
        int sourceOffset = sourceRegion.getOffset();
        LinkedNode nodeAtStart = this.findNodeAtSourcePos(sourceOffset);
        if (nodeAtStart == null) {
            return null;
        }
        IndexedRegion regionAtStart = (IndexedRegion)nodeAtStart.getAdapter(IndexedRegion.class);
        LinkedNode nodeAtEnd = sourceOffset + sourceRegion.getLength() <= regionAtStart.getEndOffset() ? nodeAtStart : this.findNodeAtSourcePos(sourceOffset + sourceRegion.getLength());
        int contentStartOffset = nodeAtStart instanceof LinkedNonElement ? ((LinkedNonElement)nodeAtStart).getContentOffsetFor(sourceRegion.getOffset()) : (nodeAtStart instanceof LinkedText ? ((LinkedText)nodeAtStart).getContentOffsetFor(sourceRegion.getOffset()) : nodeAtStart.getStartOffset() + 1);
        int contentEndOffset = sourceRegion.getLength() == 0 ? contentStartOffset : (nodeAtEnd instanceof LinkedNonElement ? ((LinkedNonElement)nodeAtEnd).getContentOffsetFor(sourceRegion.getOffset() + sourceRegion.getLength()) : (nodeAtEnd instanceof LinkedText ? ((LinkedText)nodeAtEnd).getContentOffsetFor(sourceRegion.getOffset() + sourceRegion.getLength()) : nodeAtEnd.getEndOffset()));
        return new Region(contentStartOffset, contentEndOffset - contentStartOffset);
    }

    private LinkedNode findNodeAtSourcePos(int sourceOffset) {
        Iterator<IVexNode> children = ((LinkedElement)this.getRootElement()).getChildNodeIterator();
        LinkedNode nodeAtStart = null;
        while (children.hasNext()) {
            LinkedNode linkedNode = (LinkedNode)children.next();
            IndexedRegion indexedRegion = (IndexedRegion)linkedNode.getAdapter(IndexedRegion.class);
            if (indexedRegion.getStartOffset() > sourceOffset || sourceOffset >= indexedRegion.getEndOffset()) continue;
            nodeAtStart = linkedNode;
            if (!nodeAtStart.hasChildren()) break;
            children = ((LinkedElement)nodeAtStart).getChildNodeIterator();
        }
        if (nodeAtStart == null) {
            return (LinkedNode)((Object)this.getRootElement());
        }
        return nodeAtStart;
    }

    public void dispose() {
        IVexElement rootElement = this.getRootElement();
        if (rootElement != null && rootElement instanceof LinkedNode) {
            ((LinkedNode)((Object)rootElement)).dispose();
        }
    }

    public static IStatus deepCompare(LinkedNode left, LinkedNode right) {
        MultiStatus result = new MultiStatus("net.sf.vex.toolkit", 0, MessageFormat.format("There were differences between the nodes {0} and {1} or their children.", left, right), null);
        if (!left.equals(right)) {
            result.add((IStatus)new Status(4, "net.sf.vex.toolkit", MessageFormat.format("The nodes themselves differ:\n l: {0}\n r: {1}", left, right)));
        }
        Iterator<IVexNode> leftChildren = left.getChildNodeIterator();
        Iterator<IVexNode> rightChildren = right.getChildNodeIterator();
        while (leftChildren.hasNext()) {
            IVexNode leftChild = leftChildren.next();
            if (rightChildren.hasNext()) {
                IVexNode rightChild = rightChildren.next();
                IStatus childStatus = LinkedDocument.deepCompare((LinkedNode)leftChild, (LinkedNode)rightChild);
                if (childStatus.isOK()) continue;
                result.add(childStatus);
                continue;
            }
            result.add((IStatus)new Status(4, "net.sf.vex.toolkit", MessageFormat.format("{0} has more children than {1}: No match for child {2}", left, right, leftChild)));
        }
        while (rightChildren.hasNext()) {
            IVexNode rightChild = rightChildren.next();
            result.add((IStatus)new Status(4, "net.sf.vex.toolkit", MessageFormat.format("{0} has less children than {1}: No match for child {2}", left, right, rightChild)));
        }
        return result.isOK() ? Status.OK_STATUS : result;
    }

    protected static class ModelError {
        private final String message;
        private final LinkedNode node;

        public ModelError(String message, LinkedNode node) {
            this.message = message;
            this.node = node;
        }

        public String toString() {
            return "Error: " + this.message + "\t in " + this.node;
        }
    }
}

