/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.layout;

import net.sf.vex.core.Caret;
import net.sf.vex.core.Color;
import net.sf.vex.core.ColorResource;
import net.sf.vex.core.Graphics;
import net.sf.vex.core.Insets;
import net.sf.vex.core.Rectangle;
import net.sf.vex.css.Styles;
import net.sf.vex.dom.IVexElement;
import net.sf.vex.layout.Box;
import net.sf.vex.layout.BoxAndOffset;
import net.sf.vex.layout.InlineElementBox;
import net.sf.vex.layout.LayoutContext;

public abstract class AbstractBox
implements Box {
    private static final Box[] EMPTY_BOX_ARRAY = new Box[0];
    private int x;
    private int y;
    private int width = -1;
    private int height = -1;

    @Override
    public BoxAndOffset getChildAt(int x, int y) {
        if (x < 0 || y < 0 || x > this.getWidth() || y > this.getHeight()) {
            return null;
        }
        Box[] boxArray = this.getChildren();
        int n = boxArray.length;
        int n2 = 0;
        while (n2 < n) {
            Box child = boxArray[n2];
            if (child.getY() <= y && child.getY() + child.getHeight() >= y && child.getX() <= x && child.getX() + child.getWidth() >= x) {
                BoxAndOffset result = child.getChildAt(x - child.getX(), y - child.getY());
                result.x += child.getX();
                result.y += child.getY();
                return result;
            }
            ++n2;
        }
        return new BoxAndOffset(this, -this.getX(), -this.getY());
    }

    @Override
    public boolean containsOffset(int offset) {
        return offset >= this.getStartOffset() && offset <= this.getEndOffset();
    }

    @Override
    public Caret getCaret(LayoutContext context, int offset) {
        throw new IllegalStateException();
    }

    @Override
    public Box[] getChildren() {
        return EMPTY_BOX_ARRAY;
    }

    @Override
    public IVexElement getElement() {
        return null;
    }

    @Override
    public int getEndOffset() {
        throw new IllegalStateException();
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getStartOffset() {
        throw new IllegalStateException();
    }

    @Override
    public Insets getInsets(LayoutContext context, int containerWidth) {
        return Insets.ZERO_INSETS;
    }

    @Override
    public boolean hasContent() {
        return false;
    }

    @Override
    public boolean isAnonymous() {
        return true;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public void paint(LayoutContext context, int x, int y, Rectangle area) {
        if (this.skipPaint(context, x, y)) {
            return;
        }
        this.paintChildren(context, x, y, area);
    }

    protected void paintChildren(LayoutContext context, int x, int y, Rectangle area) {
        Box[] children = this.getChildren();
        int i = 0;
        while (children != null && i < children.length) {
            if (y + children[i].getY() + children[i].getHeight() > area.getY()) {
                Box child = children[i];
                child.paint(context, x + child.getX(), y + child.getY(), area);
                if (y + children[i].getY() > area.getY() + area.getHeight()) break;
            }
            ++i;
        }
    }

    @Override
    public void setHeight(int height) {
        this.height = height;
    }

    @Override
    public void setWidth(int width) {
        this.width = width;
    }

    @Override
    public void setX(int x) {
        this.x = x;
    }

    @Override
    public void setY(int y) {
        this.y = y;
    }

    protected boolean skipPaint(LayoutContext context, int x, int y) {
        Rectangle clipBounds = context.getGraphics().getClipBounds();
        return clipBounds.getY() + clipBounds.getHeight() <= y || clipBounds.getY() >= y + this.getHeight();
    }

    @Override
    public int viewToModel(LayoutContext context, int x, int y) {
        throw new IllegalStateException();
    }

    protected void drawBox(LayoutContext context, int x, int y, int containerWidth, boolean drawBorders) {
        this.drawBox(context, this.getElement(), x, y, containerWidth, drawBorders);
    }

    protected void drawBox(LayoutContext context, IVexElement vexElement, int x, int y, int containerWidth, boolean drawBorders) {
        Color backgroundColor;
        if (vexElement == null) {
            return;
        }
        Graphics g = context.getGraphics();
        Styles styles = context.getStyleSheet().getStyles(vexElement);
        boolean hasLeft = true;
        boolean hasRight = true;
        int left = x - styles.getPaddingLeft().get(containerWidth) - styles.getBorderLeftWidth();
        int top = y - styles.getPaddingTop().get(containerWidth) - styles.getBorderTopWidth();
        int right = x + this.getWidth() + styles.getPaddingRight().get(containerWidth) + styles.getBorderRightWidth();
        int bottom = y + this.getHeight() + styles.getPaddingBottom().get(containerWidth) + styles.getBorderBottomWidth();
        if (this instanceof InlineElementBox) {
            hasLeft = this.getStartOffset() == vexElement.getStartOffset() + 1;
            boolean bl = hasRight = this.getEndOffset() == vexElement.getEndOffset();
        }
        if ((backgroundColor = styles.getBackgroundColor()) != null) {
            ColorResource color = g.createColor(backgroundColor);
            ColorResource oldColor = g.setColor(color);
            g.fillRect(left, top, right - left, bottom - top);
            g.setColor(oldColor);
            color.dispose();
        }
        if (drawBorders) {
            ColorResource oldColor;
            ColorResource color;
            boolean oldAntiAlias = g.isAntiAliased();
            g.setAntiAliased(false);
            int bw2 = styles.getBorderBottomWidth() / 2;
            int lw2 = styles.getBorderLeftWidth() / 2;
            int rw2 = styles.getBorderRightWidth() / 2;
            int tw2 = styles.getBorderTopWidth() / 2;
            if (styles.getBorderBottomWidth() > 0) {
                color = g.createColor(styles.getBorderBottomColor());
                oldColor = g.setColor(color);
                g.setLineStyle(AbstractBox.lineStyle(styles.getBorderBottomStyle()));
                g.setLineWidth(styles.getBorderBottomWidth());
                g.drawLine(left + bw2, bottom - bw2 - 1, right - bw2, bottom - bw2 - 1);
                g.setColor(oldColor);
                color.dispose();
            }
            if (hasLeft && styles.getBorderLeftWidth() > 0) {
                color = g.createColor(styles.getBorderLeftColor());
                oldColor = g.setColor(color);
                g.setLineStyle(AbstractBox.lineStyle(styles.getBorderLeftStyle()));
                g.setLineWidth(styles.getBorderLeftWidth());
                g.drawLine(left + lw2, top + lw2, left + lw2, bottom - lw2 - 1);
                g.setColor(oldColor);
                color.dispose();
            }
            if (hasRight && styles.getBorderRightWidth() > 0) {
                color = g.createColor(styles.getBorderRightColor());
                oldColor = g.setColor(color);
                g.setLineStyle(AbstractBox.lineStyle(styles.getBorderRightStyle()));
                g.setLineWidth(styles.getBorderRightWidth());
                g.drawLine(right - rw2 - 1, top + rw2, right - rw2 - 1, bottom - rw2 - 1);
                g.setColor(oldColor);
                color.dispose();
            }
            if (styles.getBorderTopWidth() > 0) {
                color = g.createColor(styles.getBorderTopColor());
                oldColor = g.setColor(color);
                g.setLineStyle(AbstractBox.lineStyle(styles.getBorderTopStyle()));
                g.setLineWidth(styles.getBorderTopWidth());
                g.drawLine(left + tw2, top + tw2, right - tw2, top + tw2);
                g.setColor(oldColor);
                color.dispose();
            }
            g.setAntiAliased(oldAntiAlias);
        }
    }

    private static int lineStyle(String style) {
        if (style.equalsIgnoreCase("dotted")) {
            return 2;
        }
        if (style.equalsIgnoreCase("dashed")) {
            return 1;
        }
        return 0;
    }

    public static Insets getInsets(Styles styles, int containerWidth) {
        int top = styles.getMarginTop().get(containerWidth) + styles.getBorderTopWidth() + styles.getPaddingTop().get(containerWidth);
        int left = styles.getMarginLeft().get(containerWidth) + styles.getBorderLeftWidth() + styles.getPaddingLeft().get(containerWidth);
        int bottom = styles.getMarginBottom().get(containerWidth) + styles.getBorderBottomWidth() + styles.getPaddingBottom().get(containerWidth);
        int right = styles.getMarginRight().get(containerWidth) + styles.getBorderRightWidth() + styles.getPaddingRight().get(containerWidth);
        return new Insets(top, left, bottom, right);
    }
}

