/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.layout;

import net.sf.vex.core.Color;
import net.sf.vex.core.ColorResource;
import net.sf.vex.core.FontMetrics;
import net.sf.vex.core.FontResource;
import net.sf.vex.core.FontSpec;
import net.sf.vex.core.Graphics;
import net.sf.vex.core.Insets;
import net.sf.vex.core.IntRange;
import net.sf.vex.core.Rectangle;
import net.sf.vex.css.Styles;
import net.sf.vex.dom.IVexElement;
import net.sf.vex.layout.AbstractBox;
import net.sf.vex.layout.AnnotationRenderingInfo;
import net.sf.vex.layout.BlockBox;
import net.sf.vex.layout.BlockElementBox;
import net.sf.vex.layout.Clickable;
import net.sf.vex.layout.LayoutContext;
import net.sf.vex.layout.LineBox;
import net.sf.vex.layout.VexAnnotationTracker;

public class BlockElementWidget
extends AbstractBox
implements BlockBox,
Clickable {
    private LayoutContext context;
    private BlockElementBox parent;
    protected static int size = 15;
    protected static Color fgColor = new Color(255, 255, 255);
    protected static Color bgColor = new Color(150, 150, 255);
    protected static String[] fontFamily = new String[]{"sans-serif"};
    protected int width;
    protected static int collapseButtonSize = 11;

    public BlockElementWidget(LayoutContext context, BlockElementBox parent) {
        this.context = context;
        this.setWidth(this.width);
        this.setHeight(size);
        this.parent = parent;
    }

    @Override
    public IVexElement getElement() {
        return this.parent.getElement();
    }

    @Override
    public void paint(LayoutContext context, int x, int y, Rectangle area) {
        Graphics g = context.getGraphics();
        Styles styles = context.getStyleSheet().getStyles(this.parent.getElement());
        boolean drawSelected = false;
        FontMetrics fm = g.getFontMetrics();
        FontResource oldFont = g.getFont();
        ColorResource oldColor = g.getColor();
        FontResource font = context.getGraphics().createFont(new FontSpec(fontFamily, 0, (int)((float)size * 0.8f)));
        AnnotationRenderingInfo rendering = VexAnnotationTracker.getRenderingInfo(context, this.getElement());
        ColorResource color = rendering != null && rendering.isShownInText() ? g.createColor(rendering.getColor()) : g.createColor(bgColor);
        g.setColor(color);
        g.fillRect(x, y, this.width, size);
        color.dispose();
        color = g.createColor(fgColor);
        if (drawSelected) {
            Rectangle bounds = this.getBounds();
            g.setColor(g.getSystemColor(0));
            g.fillRect(x + bounds.getX(), y, bounds.getWidth(), styles.getLineHeight() - fm.getDescent());
            g.setColor(g.getSystemColor(1));
        } else {
            g.setColor(color);
        }
        g.setFont(font);
        g.setLineStyle(0);
        g.setLineWidth(1);
        int collapseButtonMargin = (size - collapseButtonSize) / 2;
        g.fillRect(x + collapseButtonMargin, y + collapseButtonMargin, collapseButtonSize, collapseButtonSize);
        int xPlusOffset = x + (collapseButtonMargin * 2 + collapseButtonSize);
        g.drawString(this.parent.getElement().getName(), xPlusOffset + 2, y + (int)((float)size * 0.1f) - 2);
        g.drawLine(x, y, x, y + size);
        g.drawLine(x, y, x + this.width, y);
        g.drawLine(x, y + size, x + this.width, y + size);
        g.drawLine(x + this.width, y, x + this.width, y + size);
        color = g.createColor(bgColor);
        g.setColor(color);
        g.drawLine(x + 2 * collapseButtonMargin, y + collapseButtonMargin + collapseButtonSize / 2, x + collapseButtonSize, y + collapseButtonMargin + collapseButtonSize / 2);
        if (context.isCollapsed(this.parent.getElement())) {
            g.drawLine(x + collapseButtonMargin + collapseButtonSize / 2, y + 2 * collapseButtonMargin, x + collapseButtonMargin + collapseButtonSize / 2, y + collapseButtonSize);
        }
        g.setColor(oldColor);
        g.setFont(oldFont);
    }

    public Rectangle getBounds() {
        return new Rectangle(0, size, this.width + size, size);
    }

    public String toString() {
        return "[BlockElementWidget]";
    }

    @Override
    public Insets getInsets(LayoutContext context, int containerWidth) {
        return new Insets(0, 0, 3, 0);
    }

    @Override
    public void click(int x, int y) {
        if (this.insideExpandButton(x, y)) {
            if (this.context.isCollapsed(this.parent.getElement())) {
                this.context.expand(this.parent.getElement());
            } else {
                this.context.collapse(this.parent.getElement());
            }
            this.parent.findRoot().getVexWidget().reLayout();
        }
    }

    private boolean insideExpandButton(int x, int y) {
        int collapseButtonMargin = (size - collapseButtonSize) / 2;
        return x > collapseButtonMargin && x < collapseButtonMargin + collapseButtonSize && y > collapseButtonMargin && y < collapseButtonMargin + collapseButtonSize;
    }

    @Override
    public LineBox getFirstLine() {
        return null;
    }

    @Override
    public LineBox getLastLine() {
        return null;
    }

    @Override
    public int getLineEndOffset(int offset) {
        return 0;
    }

    @Override
    public int getLineStartOffset(int offset) {
        return 0;
    }

    @Override
    public int getMarginBottom() {
        return 0;
    }

    @Override
    public int getMarginTop() {
        return 0;
    }

    @Override
    public int getNextLineOffset(LayoutContext context, int offset, int x) {
        return 0;
    }

    @Override
    public BlockBox getParent() {
        return null;
    }

    @Override
    public int getPreviousLineOffset(LayoutContext context, int offset, int x) {
        return 0;
    }

    @Override
    public void invalidate(boolean direct) {
    }

    @Override
    public IntRange layout(LayoutContext context, int top, int bottom) {
        return null;
    }

    @Override
    public void setInitialSize(LayoutContext context) {
    }

    @Override
    public void setParent(BlockBox parent) {
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public void setWidth(int width) {
        this.width = width;
    }

    public static void setFgColor(Color fgColor) {
        BlockElementWidget.fgColor = fgColor;
    }

    public static void setBgColor(Color bgColor) {
        BlockElementWidget.bgColor = bgColor;
    }

    @Override
    public boolean hasContent() {
        return false;
    }
}

