/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.layout;

import java.util.List;
import net.sf.vex.core.IntRange;
import net.sf.vex.core.Rectangle;
import net.sf.vex.css.Styles;
import net.sf.vex.dom.IVexElement;
import net.sf.vex.layout.AbstractBox;
import net.sf.vex.layout.BlockBox;
import net.sf.vex.layout.Box;
import net.sf.vex.layout.LayoutContext;
import net.sf.vex.layout.LayoutUtils;
import net.sf.vex.layout.LineBox;
import net.sf.vex.layout.ParagraphBox;

public class BlockPseudoElementBox
extends AbstractBox
implements BlockBox {
    private IVexElement pseudoElement;
    private BlockBox parent;
    private ParagraphBox para;
    private int marginTop;
    private int marginBottom;

    public BlockPseudoElementBox(LayoutContext context, IVexElement pseudoElement, BlockBox parent, int width) {
        this.pseudoElement = pseudoElement;
        this.parent = parent;
        Styles styles = context.getStyleSheet().getStyles(pseudoElement);
        this.marginTop = styles.getMarginTop().get(width);
        this.marginBottom = styles.getMarginBottom().get(width);
        int leftInset = styles.getMarginLeft().get(width) + styles.getBorderLeftWidth() + styles.getPaddingLeft().get(width);
        int rightInset = styles.getMarginRight().get(width) + styles.getBorderRightWidth() + styles.getPaddingRight().get(width);
        int childWidth = width - leftInset - rightInset;
        List inlines = LayoutUtils.createGeneratedInlines(context, pseudoElement);
        this.para = ParagraphBox.create(context, pseudoElement, inlines, childWidth);
        this.para.setX(0);
        this.para.setY(0);
        this.setWidth(width - leftInset - rightInset);
        this.setHeight(this.para.getHeight());
    }

    @Override
    public Box[] getChildren() {
        return new Box[]{this.para};
    }

    @Override
    public IVexElement getElement() {
        return this.pseudoElement;
    }

    @Override
    public LineBox getFirstLine() {
        throw new IllegalStateException();
    }

    @Override
    public LineBox getLastLine() {
        throw new IllegalStateException();
    }

    @Override
    public int getLineEndOffset(int offset) {
        throw new IllegalStateException();
    }

    @Override
    public int getLineStartOffset(int offset) {
        throw new IllegalStateException();
    }

    @Override
    public int getMarginBottom() {
        return this.marginBottom;
    }

    @Override
    public int getMarginTop() {
        return this.marginTop;
    }

    @Override
    public int getNextLineOffset(LayoutContext context, int offset, int x) {
        throw new IllegalStateException();
    }

    @Override
    public BlockBox getParent() {
        return this.parent;
    }

    @Override
    public int getPreviousLineOffset(LayoutContext context, int offset, int x) {
        throw new IllegalStateException();
    }

    @Override
    public IntRange layout(LayoutContext context, int top, int bottom) {
        return null;
    }

    @Override
    public void invalidate(boolean direct) {
        throw new IllegalStateException("invalidate called on a non-element BlockBox");
    }

    @Override
    public void paint(LayoutContext context, int x, int y, Rectangle area) {
        this.drawBox(context, x, y, this.getParent().getWidth(), true);
        super.paint(context, x, y, area);
    }

    @Override
    public void setInitialSize(LayoutContext context) {
    }

    @Override
    public void setParent(BlockBox parent) {
        this.parent = parent;
    }
}

