/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.layout;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.sf.vex.core.IntRange;
import net.sf.vex.css.StyleSheet;
import net.sf.vex.css.Styles;
import net.sf.vex.dom.IVexElement;
import net.sf.vex.dom.IVexNode;
import net.sf.vex.layout.ElementOrRangeCallback;
import net.sf.vex.layout.LayoutContext;
import net.sf.vex.layout.StaticTextBox;

public class LayoutUtils {
    public static Set TABLE_CHILD_STYLES = new HashSet();
    private static Set nonRowStyles = new HashSet();
    private static Set rowStyles = new HashSet();
    private static Set cellStyles = new HashSet();

    static {
        nonRowStyles.add("table-caption");
        nonRowStyles.add("table-column");
        nonRowStyles.add("table-column-group");
        nonRowStyles.add("table-row-group");
        nonRowStyles.add("table-header-group");
        nonRowStyles.add("table-footer-group");
        rowStyles.add("table-row");
        cellStyles.add("table-cell");
        TABLE_CHILD_STYLES.addAll(nonRowStyles);
        TABLE_CHILD_STYLES.addAll(rowStyles);
        TABLE_CHILD_STYLES.addAll(cellStyles);
    }

    public static List createGeneratedInlines(LayoutContext context, IVexElement pseudoElement) {
        String text = LayoutUtils.getGeneratedContent(context, pseudoElement);
        ArrayList<StaticTextBox> list = new ArrayList<StaticTextBox>();
        if (text.length() > 0) {
            list.add(new StaticTextBox(context, pseudoElement, text));
        }
        return list;
    }

    public static List createFirstInlines(LayoutContext context, IVexElement pseudoElement) {
        int dot_pos;
        String text = "";
        ArrayList<StaticTextBox> list = new ArrayList<StaticTextBox>();
        if (pseudoElement.getName().equals("first-letter")) {
            if (pseudoElement.getParent().getChildElements().length <= 0) {
                if (pseudoElement.getParent().getText().length() > 1) {
                    text = pseudoElement.getParent().getText().substring(1, 2);
                }
            } else if (pseudoElement.getParent().getChildElements()[0].getText().length() > 1) {
                text = pseudoElement.getParent().getChildElements()[0].getText().substring(1, 2);
            }
        } else if (pseudoElement.getName().equals("first-line") && pseudoElement.getParent().getText().length() > 1 && (dot_pos = pseudoElement.getParent().getText().indexOf(".")) != -1) {
            text = pseudoElement.getParent().getText().substring(1, dot_pos);
        }
        if (text.length() > 0) {
            list.add(new StaticTextBox(context, pseudoElement, text));
        }
        return list;
    }

    public static boolean elementOrRangeContains(Object elementOrRange, int offset) {
        if (elementOrRange instanceof IVexElement) {
            IVexElement element = (IVexElement)elementOrRange;
            return offset > element.getStartOffset() && offset <= element.getEndOffset();
        }
        IntRange range = (IntRange)elementOrRange;
        return offset >= range.getStart() && offset <= range.getEnd();
    }

    private static String getGeneratedContent(LayoutContext context, IVexElement pseudoElement) {
        Styles styles = context.getStyleSheet().getStyles(pseudoElement);
        List content = styles.getContent();
        StringBuffer sb = new StringBuffer();
        Iterator it = content.iterator();
        while (it.hasNext()) {
            sb.append((String)it.next());
        }
        return sb.toString();
    }

    public static void iterateChildrenByDisplayStyle(StyleSheet styleSheet, Set displayStyles, IVexElement element, int startOffset, int endOffset, ElementOrRangeCallback callback) {
        ArrayList<IVexNode> nonMatching = new ArrayList<IVexNode>();
        IVexNode[] nodes = element.getChildNodes();
        int i = 0;
        while (i < nodes.length) {
            if (nodes[i].getEndOffset() > startOffset) {
                if (nodes[i].getStartOffset() >= endOffset) break;
                IVexNode node = nodes[i];
                if (node instanceof IVexElement) {
                    IVexElement childElement = (IVexElement)node;
                    String display = styleSheet.getStyles(childElement).getDisplay();
                    if (displayStyles.contains(display)) {
                        if (nonMatching.size() > 0) {
                            IVexNode firstNode = (IVexNode)nonMatching.get(0);
                            IVexNode lastNode = (IVexNode)nonMatching.get(nonMatching.size() - 1);
                            if (lastNode instanceof IVexElement) {
                                callback.onRange(element, firstNode.getStartOffset(), lastNode.getEndOffset() + 1);
                            } else {
                                callback.onRange(element, firstNode.getStartOffset(), lastNode.getEndOffset());
                            }
                            nonMatching.clear();
                        }
                        callback.onElement(childElement, display);
                    } else {
                        nonMatching.add(node);
                    }
                } else {
                    nonMatching.add(node);
                }
            }
            ++i;
        }
        if (nonMatching.size() > 0) {
            IVexNode firstNode = (IVexNode)nonMatching.get(0);
            IVexNode lastNode = (IVexNode)nonMatching.get(nonMatching.size() - 1);
            if (lastNode instanceof IVexElement) {
                callback.onRange(element, firstNode.getStartOffset(), lastNode.getEndOffset() + 1);
            } else {
                callback.onRange(element, firstNode.getStartOffset(), lastNode.getEndOffset());
            }
        }
    }

    public static void iterateChildrenByDisplayStyle(StyleSheet styleSheet, Set displayStyles, IVexElement element, ElementOrRangeCallback callback) {
        LayoutUtils.iterateChildrenByDisplayStyle(styleSheet, displayStyles, element, element.getStartOffset() + 1, element.getEndOffset(), callback);
    }

    public static boolean isTableChild(StyleSheet styleSheet, IVexElement element) {
        String display = styleSheet.getStyles(element).getDisplay();
        return TABLE_CHILD_STYLES.contains(display);
    }

    public static void iterateTableRows(final StyleSheet styleSheet, final IVexElement element, int startOffset, int endOffset, final ElementOrRangeCallback callback) {
        LayoutUtils.iterateChildrenByDisplayStyle(styleSheet, nonRowStyles, element, startOffset, endOffset, new ElementOrRangeCallback(){

            @Override
            public void onElement(IVexElement child, String displayStyle) {
                if (displayStyle.equalsIgnoreCase("table-row-group") || displayStyle.equalsIgnoreCase("table-header-group") || displayStyle.equalsIgnoreCase("table-footer-group")) {
                    LayoutUtils.iterateChildrenByDisplayStyle(styleSheet, rowStyles, child, child.getStartOffset() + 1, child.getEndOffset(), callback);
                }
            }

            @Override
            public void onRange(IVexElement parent, int startOffset, int endOffset) {
                LayoutUtils.iterateChildrenByDisplayStyle(styleSheet, rowStyles, element, startOffset, endOffset, callback);
            }
        });
    }

    public static void iterateTableCells(StyleSheet styleSheet, IVexElement element, int startOffset, int endOffset, ElementOrRangeCallback callback) {
        LayoutUtils.iterateChildrenByDisplayStyle(styleSheet, cellStyles, element, startOffset, endOffset, callback);
    }

    public static void iterateTableCells(StyleSheet styleSheet, IVexElement row, ElementOrRangeCallback callback) {
        LayoutUtils.iterateChildrenByDisplayStyle(styleSheet, cellStyles, row, row.getStartOffset(), row.getEndOffset(), callback);
    }
}

