/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.layout;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.vex.core.Insets;
import net.sf.vex.core.IntRange;
import net.sf.vex.core.Rectangle;
import net.sf.vex.css.StyleSheet;
import net.sf.vex.css.Styles;
import net.sf.vex.dom.IVexElement;
import net.sf.vex.layout.AbstractBlockBox;
import net.sf.vex.layout.BlockBox;
import net.sf.vex.layout.BlockElementBox;
import net.sf.vex.layout.ElementOrRangeCallback;
import net.sf.vex.layout.LayoutContext;
import net.sf.vex.layout.LayoutUtils;
import net.sf.vex.layout.TableBodyBox;

public class TableBox
extends AbstractBlockBox {
    private static Set captionOrColumnStyles = new HashSet();
    private int[] columnWidths;
    private int horizonalSpacing;
    private int verticalSpacing;

    static {
        captionOrColumnStyles.add("table-caption");
        captionOrColumnStyles.add("table-column");
        captionOrColumnStyles.add("table-column-group");
    }

    public TableBox(LayoutContext context, BlockBox parent, IVexElement element) {
        super(context, parent, element);
    }

    public TableBox(LayoutContext context, BlockBox parent, int startOffset, int endOffset) {
        super(context, parent, startOffset, endOffset);
    }

    @Override
    protected List createChildren(final LayoutContext context) {
        final ArrayList children = new ArrayList();
        this.iterateChildrenByDisplayStyle(context.getStyleSheet(), captionOrColumnStyles, new ElementOrRangeCallback(){

            @Override
            public void onElement(IVexElement child, String displayStyle) {
                children.add(new BlockElementBox(context, TableBox.this, child));
            }

            @Override
            public void onRange(IVexElement parent, int startOffset, int endOffset) {
                children.add(new TableBodyBox(context, TableBox.this, startOffset, endOffset));
            }
        });
        return children;
    }

    public int[] getColumnWidths() {
        return this.columnWidths;
    }

    public int getHorizonalSpacing() {
        return this.horizonalSpacing;
    }

    @Override
    public Insets getInsets(LayoutContext context, int containerWidth) {
        Insets markerInsets = BlockElementBox.getMarkerInsets(context);
        return new Insets(this.getMarginTop() + markerInsets.getTop(), markerInsets.getLeft(), this.getMarginBottom() + markerInsets.getBottom(), markerInsets.getRight());
    }

    public int getVerticalSpacing() {
        return this.verticalSpacing;
    }

    @Override
    public IntRange layout(LayoutContext context, int top, int bottom) {
        int newColCount = this.computeColumnCount(context);
        if (this.columnWidths == null || newColCount != this.columnWidths.length) {
            this.setLayoutState((byte)2);
        }
        if (this.getLayoutState() == 2) {
            this.computeColumnWidths(context, newColCount);
        }
        return super.layout(context, top, bottom);
    }

    @Override
    public void paint(LayoutContext context, int x, int y, Rectangle area) {
        if (this.skipPaint(context, x, y)) {
            return;
        }
        this.paintChildren(context, x, y, area);
        if (this.getElement() != null && context.showBlockMarkers()) {
            this.paintMarkerFrame(context, x, y, this.getParent().getWidth());
        }
    }

    private int computeColumnCount(LayoutContext context) {
        IVexElement tableElement = this.findContainingElement();
        final int[] columnCounts = new int[]{0};
        final StyleSheet styleSheet = context.getStyleSheet();
        final CountingCallback callback = new CountingCallback();
        LayoutUtils.iterateTableRows(styleSheet, tableElement, this.getStartOffset(), this.getEndOffset(), new ElementOrRangeCallback(){

            @Override
            public void onElement(IVexElement child, String displayStyle) {
                LayoutUtils.iterateTableCells(styleSheet, child, callback);
                columnCounts[0] = Math.max(columnCounts[0], callback.getCount());
                callback.reset();
            }

            @Override
            public void onRange(IVexElement parent, int startOffset, int endOffset) {
                LayoutUtils.iterateTableCells(styleSheet, parent, startOffset, endOffset, callback);
                columnCounts[0] = Math.max(columnCounts[0], callback.getCount());
                callback.reset();
            }
        });
        return columnCounts[0];
    }

    private void computeColumnWidths(LayoutContext context, int columnCount) {
        int myWidth;
        this.columnWidths = new int[columnCount];
        if (columnCount == 0) {
            return;
        }
        this.horizonalSpacing = 0;
        this.verticalSpacing = 0;
        int availableWidth = myWidth = this.getWidth();
        if (!this.isAnonymous()) {
            Styles styles = context.getStyleSheet().getStyles(this.getElement());
            this.horizonalSpacing = styles.getBorderSpacing().getHorizontal();
            this.verticalSpacing = styles.getBorderSpacing().getVertical();
            availableWidth -= styles.getMarginLeft().get(myWidth) + styles.getBorderLeftWidth() + styles.getPaddingLeft().get(myWidth) + styles.getPaddingRight().get(myWidth) + styles.getBorderRightWidth() + styles.getMarginRight().get(myWidth);
        }
        int totalColumnWidth = this.horizonalSpacing;
        int columnWidth = (availableWidth - this.horizonalSpacing * (columnCount + 1)) / columnCount;
        int i = 0;
        while (i < this.columnWidths.length - 1) {
            System.err.print(" " + columnWidth);
            this.columnWidths[i] = columnWidth;
            totalColumnWidth += columnWidth + this.horizonalSpacing;
            ++i;
        }
        this.columnWidths[this.columnWidths.length - 1] = availableWidth - totalColumnWidth - this.horizonalSpacing;
    }

    private static class CountingCallback
    implements ElementOrRangeCallback {
        private int count;

        private CountingCallback() {
        }

        public int getCount() {
            return this.count;
        }

        public void reset() {
            this.count = 0;
        }

        @Override
        public void onElement(IVexElement child, String displayStyle) {
            ++this.count;
        }

        @Override
        public void onRange(IVexElement parent, int startOffset, int endOffset) {
            ++this.count;
        }
    }
}

